/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Vector2f;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.ActorSpriteConfig;
import com.threerings.tudey.config.BehaviorConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.TagConfig;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

public class ActorConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public ActorSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
        return this.implementation.getSpriteImplementation(ctx, scope, impl);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<ActorConfig> actor;

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            ActorConfig config = cfgmgr.getConfig(ActorConfig.class, this.actor);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        @Override
        public ShapeConfig getShape(ConfigManager cfgmgr) {
            return this.getOriginal(cfgmgr).getShape(cfgmgr);
        }

        @Override
        public ActorSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
            ActorConfig config = ctx.getConfigManager().getConfig(ActorConfig.class, this.actor);
            return config == null ? null : config.getSpriteImplementation(ctx, scope, impl);
        }
    }

    public static class Agent
    extends Pawn {
        @Editable(min=0.0, scale=0.017453292519943295)
        public float turnRate = (float)Math.PI;
        @Editable(nullable=true)
        @Strippable
        public ConfigReference<BehaviorConfig> behavior;

        public Agent() {
            this.startInStasis = true;
            this.stasisInterval = 5000;
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.AgentLogic";
        }

        @Override
        public Actor createActor(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
            return new com.threerings.tudey.data.actor.Agent(config, id, created, translation, rotation);
        }
    }

    public static class Pawn
    extends Mobile {
        public Pawn() {
            this.startInStasis = false;
            this.stasisInterval = 0;
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.PawnLogic";
        }

        @Override
        public Actor createActor(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
            return new com.threerings.tudey.data.actor.Pawn(config, id, created, translation, rotation);
        }
    }

    public static class Mobile
    extends Original {
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float speed = 6.0f;
        @Editable(hgroup="s")
        public boolean startMoving;
        @Editable(hgroup="a")
        @Strippable
        public boolean startInStasis = true;
        @Editable(min=0.0, hgroup="a")
        @Strippable
        public int stasisInterval = 5000;

        public Mobile() {
            this.isStatic = false;
        }

        @Override
        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.MobileLogic";
        }

        @Override
        public Actor createActor(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
            return new com.threerings.tudey.data.actor.Mobile(config, id, created, translation, rotation);
        }
    }

    public static class EntryState
    extends Original {
        @Editable
        public ActionConfig[] stateActions = new ActionConfig[0];

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            for (ActionConfig action : this.stateActions) {
                action.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public void invalidate() {
            super.invalidate();
            for (ActionConfig action : this.stateActions) {
                action.invalidate();
            }
        }

        @Override
        public Actor createActor(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
            return new com.threerings.tudey.data.actor.EntryState(config, id, created, translation, rotation);
        }
    }

    public static class Original
    extends Implementation {
        @Editable
        public ActorSpriteConfig sprite = new ActorSpriteConfig.Default();
        @Editable
        public ShapeConfig shape = new ShapeConfig.Point();
        @Editable
        public boolean rotateShape = true;
        @Editable
        @Strippable
        public TagConfig tags = new TagConfig();
        @Editable(collapsible=true)
        public HandlerConfig[] handlers = new HandlerConfig[0];
        @Editable(hgroup="s")
        public boolean isStatic = true;
        @Editable(hgroup="d")
        @Strippable
        public boolean defaultEntrance;
        @Editable(editor="mask", mode="collision", hgroup="d")
        @Strippable
        public int spawnMask;
        @Editable(editor="mask", mode="collision", hgroup="d")
        @Strippable
        public int spawnAdjustMask = 3;
        @Editable(editor="mask", mode="collision", hgroup="c")
        public int collisionFlags = 1;
        @Editable(editor="mask", mode="collision", hgroup="c")
        public int collisionMask = 1;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.ActorLogic";
        }

        public Actor createActor(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
            return new Actor(config, id, created, translation, rotation);
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.sprite.getPreloads(cfgmgr, preloads);
            for (HandlerConfig handler : this.handlers) {
                if (handler == null) continue;
                handler.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public ShapeConfig getShape(ConfigManager cfgmgr) {
            return this.shape;
        }

        @Override
        public ActorSprite.Implementation getSpriteImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
            return this.sprite.getImplementation(ctx, scope, impl);
        }

        @Override
        public void invalidate() {
            this.sprite.invalidate();
            this.shape.invalidate();
            for (HandlerConfig handler : this.handlers) {
                if (handler == null) continue;
                handler.invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Mobile.class, Pawn.class, Agent.class, Derived.class, EntryState.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract ShapeConfig getShape(ConfigManager var1);

        public abstract ActorSprite.Implementation getSpriteImplementation(TudeyContext var1, Scope var2, ActorSprite.Implementation var3);

        public void invalidate() {
        }
    }
}

