/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.text;

import com.samskivert.util.IntTuple;
import com.threerings.opengl.gui.Log;
import java.util.ArrayList;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class Document {
    protected String _text = "";
    protected ArrayList<Listener> _listeners;
    protected UndoableEditSupport _undosup = new UndoableEditSupport(this);
    protected UndoableEdit _compoundEdit;
    protected int _lastUndoId;

    public void addListener(Listener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
        this._undosup.addUndoableEditListener(listener);
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
        this._undosup.removeUndoableEditListener(listener);
    }

    public Object getValue() {
        return this.getText();
    }

    public String getText() {
        return this._text;
    }

    public String getText(int offset, int length) {
        return this._text.substring(offset, offset + length);
    }

    public boolean setText(String text, int undoId) {
        return -1 != this.replace(0, this.getLength(), text, undoId);
    }

    public int indexOfWordEnd(int from) {
        boolean consumingNonword = true;
        int nn = this._text.length();
        for (int ii = from; ii < nn; ++ii) {
            boolean nonword;
            boolean bl = nonword = !Character.isLetterOrDigit(this._text.charAt(ii));
            if (consumingNonword) {
                consumingNonword = nonword;
                continue;
            }
            if (!nonword) continue;
            return ii;
        }
        return this._text.length();
    }

    public int lastIndexOfWordStart(int from) {
        boolean consumingNonword = true;
        for (int ii = from - 1; ii >= 0; --ii) {
            boolean nonword;
            boolean bl = nonword = !Character.isLetterOrDigit(this._text.charAt(ii));
            if (consumingNonword) {
                consumingNonword = nonword;
                continue;
            }
            if (!nonword) continue;
            return ii + 1;
        }
        return 0;
    }

    public IntTuple getWordExtents(int start) {
        int end;
        int length = this._text.length();
        boolean word = Character.isLetterOrDigit(this._text.charAt(Math.min(start, length - 1)));
        while (start > 0 && Character.isLetterOrDigit(this._text.charAt(start - 1)) == word) {
            --start;
        }
        for (end = start; end < length && Character.isLetterOrDigit(this._text.charAt(end)) == word; ++end) {
        }
        return new IntTuple(start, end);
    }

    public int getLength() {
        return this._text.length();
    }

    public int moveCursor(int position, int offset) {
        return Math.max(0, Math.min(position + offset, this.getLength()));
    }

    public int insert(int offset, String text, int undoId) {
        return this.replace(offset, 0, text, undoId);
    }

    public int remove(int offset, int length, int undoId) {
        return this.replace(offset, length, "", undoId);
    }

    public int replace(final int offset, final int length, final String text, int undoId) {
        int docLength = this._text.length();
        int insLength = text.length();
        final int cutStart = Math.max(0, offset + Math.min(length, 0));
        int cutEnd = Math.min(docLength, offset + Math.max(length, 0));
        String ntext = new StringBuilder().append(this._text, 0, cutStart).append(text).append(this._text, cutEnd, docLength).toString();
        if (!this.validateEdit(this._text, ntext)) {
            return -1;
        }
        if (undoId > 0) {
            if (undoId != this._lastUndoId) {
                this._compoundEdit = new AbstractUndoableEdit(){
                    protected ArrayList<UndoableEdit> _edits = new ArrayList();

                    @Override
                    public boolean addEdit(UndoableEdit edit) {
                        return edit.isSignificant() ? false : this._edits.add(edit);
                    }

                    @Override
                    public void undo() {
                        super.undo();
                        for (int ii = this._edits.size() - 1; ii >= 0; --ii) {
                            this._edits.get(ii).undo();
                        }
                    }

                    @Override
                    public void redo() {
                        super.redo();
                        int nn = this._edits.size();
                        for (int ii = 0; ii < nn; ++ii) {
                            this._edits.get(ii).redo();
                        }
                    }
                };
                this._undosup.postEdit(this._compoundEdit);
            }
            final String otext = this._text.substring(cutStart, cutEnd);
            this._compoundEdit.addEdit(new AbstractUndoableEdit(){

                @Override
                public void undo() {
                    super.undo();
                    Document.this.replace(cutStart, text.length(), otext, -1);
                }

                @Override
                public void redo() {
                    super.redo();
                    Document.this.replace(offset, length, text, -1);
                }

                @Override
                public boolean isSignificant() {
                    return false;
                }
            });
        }
        this._lastUndoId = undoId;
        this._text = ntext;
        int cutLength = cutEnd - cutStart;
        if (cutLength > 0) {
            this.notify(false, cutStart, cutLength);
        }
        if (insLength > 0) {
            this.notify(true, cutStart, insLength);
        }
        return cutStart + insLength;
    }

    protected boolean validateEdit(String oldText, String newText) {
        return true;
    }

    protected void notify(boolean inserted, int offset, int length) {
        if (this._listeners != null) {
            String action = inserted ? "insertion" : "removal";
            for (int ii = this._listeners.size() - 1; ii >= 0; --ii) {
                Listener list = this._listeners.get(ii);
                try {
                    if (inserted) {
                        list.textInserted(this, offset, length);
                        continue;
                    }
                    list.textRemoved(this, offset, length);
                    continue;
                }
                catch (Throwable t) {
                    Log.log.warning((Object)("Document listener choked on " + action + " [doc=" + this + ", offset=" + offset + ", length=" + length + ", listener=" + list + "]."), new Object[]{t});
                }
            }
        }
    }

    public static interface Listener {
        public void textInserted(Document var1, int var2, int var3);

        public void textRemoved(Document var1, int var2, int var3);
    }
}

