/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.config.ComponentConfig;
import com.threerings.opengl.gui.layout.AbsoluteLayout;
import com.threerings.opengl.gui.layout.AnchorLayout;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.gui.layout.GroupLayout;
import com.threerings.opengl.gui.layout.HGroupLayout;
import com.threerings.opengl.gui.layout.TableLayout;
import com.threerings.opengl.gui.layout.VGroupLayout;
import com.threerings.opengl.gui.util.Point;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.MessageBundle;

@EditorTypes(value={Absolute.class, Anchor.class, Border.class, HorizontalGroup.class, VerticalGroup.class, Table.class})
public abstract class LayoutConfig
extends DeepObject
implements Exportable {
    public void configure(GlContext ctx, Scope scope, MessageBundle msgs, Container cont) {
        Component[] ochildren = new Component[cont.getComponentCount()];
        for (int ii = 0; ii < ochildren.length; ++ii) {
            ochildren[ii] = cont.getComponent(ii);
        }
        cont.removeAll();
        this.layout(ctx, scope, msgs, cont, ochildren);
    }

    public void invalidate() {
    }

    protected abstract void layout(GlContext var1, Scope var2, MessageBundle var3, Container var4, Component[] var5);

    public static class Table
    extends LayoutConfig {
        @Editable(min=1.0, hgroup="c")
        public int columns = 1;
        @Editable(hgroup="c")
        public boolean equalRows;
        @Editable(hgroup="g")
        public int rowGap;
        @Editable(hgroup="g")
        public int columnGap;
        @Editable(hgroup="a")
        public HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
        @Editable(hgroup="a")
        public VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
        @Editable
        public Child[] children = new Child[0];

        @Override
        public void invalidate() {
            for (Child child : this.children) {
                child.component.invalidate();
            }
        }

        @Override
        protected void layout(GlContext ctx, Scope scope, MessageBundle msgs, Container cont, Component[] ochildren) {
            TableLayout layout = new TableLayout(this.columns, this.rowGap, this.columnGap);
            layout.setHorizontalAlignment(this.horizontalAlignment.getAlignment());
            layout.setVerticalAlignment(this.verticalAlignment.getAlignment());
            layout.setEqualRows(this.equalRows);
            cont.setLayoutManager(layout);
            for (int ii = 0; ii < this.children.length; ++ii) {
                Component ochild = ii < ochildren.length ? ochildren[ii] : null;
                cont.add(this.children[ii].component.getComponent(ctx, scope, msgs, ochild));
            }
        }

        public static class Child
        extends DeepObject
        implements Exportable {
            @Editable
            public ComponentConfig component = new ComponentConfig.Spacer();
        }
    }

    public static class VerticalGroup
    extends Group {
        @Override
        protected GroupLayout createLayout() {
            return new VGroupLayout();
        }
    }

    public static class HorizontalGroup
    extends Group {
        @Override
        protected GroupLayout createLayout() {
            return new HGroupLayout();
        }
    }

    public static abstract class Group
    extends LayoutConfig {
        @Editable(hgroup="p")
        public OnAxisPolicy policy = OnAxisPolicy.NONE;
        @Editable(hgroup="p")
        public OffAxisPolicy offAxisPolicy = OffAxisPolicy.CONSTRAIN;
        @Editable(hgroup="p")
        public int gap = 5;
        @Editable(hgroup="j")
        public Justification justification = Justification.CENTER;
        @Editable(hgroup="j")
        public Justification offAxisJustification = Justification.CENTER;
        @Editable
        public Child[] children = new Child[0];

        @Override
        public void invalidate() {
            for (Child child : this.children) {
                child.component.invalidate();
            }
        }

        @Override
        protected void layout(GlContext ctx, Scope scope, MessageBundle msgs, Container cont, Component[] ochildren) {
            GroupLayout layout = this.createLayout();
            layout.setPolicy(this.policy.getPolicy());
            layout.setOffAxisPolicy(this.offAxisPolicy.getPolicy());
            layout.setGap(this.gap);
            layout.setJustification(this.justification.getJustification());
            layout.setOffAxisJustification(this.offAxisJustification.getJustification());
            cont.setLayoutManager(layout);
            for (int ii = 0; ii < this.children.length; ++ii) {
                Child child = this.children[ii];
                Component ochild = ii < ochildren.length ? ochildren[ii] : null;
                cont.add(child.component.getComponent(ctx, scope, msgs, ochild), child.getConstraints());
            }
        }

        protected abstract GroupLayout createLayout();

        public static class Child
        extends DeepObject
        implements Exportable {
            @Editable(hgroup="f")
            public boolean fixed;
            @Editable(min=0.0, hgroup="f")
            public int weight = 1;
            @Editable
            public ComponentConfig component = new ComponentConfig.Spacer();

            public Object getConstraints() {
                return this.fixed ? GroupLayout.FIXED : new GroupLayout.Constraints(this.weight);
            }
        }
    }

    public static class Border
    extends LayoutConfig {
        @Editable(hgroup="g")
        public int horizontalGap;
        @Editable(hgroup="g")
        public int verticalGap;
        @Editable
        public Child[] children = new Child[0];

        @Override
        public void invalidate() {
            for (Child child : this.children) {
                child.component.invalidate();
            }
        }

        @Override
        protected void layout(GlContext ctx, Scope scope, MessageBundle msgs, Container cont, Component[] ochildren) {
            cont.setLayoutManager(new BorderLayout(this.horizontalGap, this.verticalGap));
            for (int ii = 0; ii < this.children.length; ++ii) {
                Child child = this.children[ii];
                Component ochild = ii < ochildren.length ? ochildren[ii] : null;
                cont.add(child.component.getComponent(ctx, scope, msgs, ochild), child.getConstraints());
            }
        }

        public static class Child
        extends DeepObject
        implements Exportable {
            @Editable
            public Location location = Location.CENTER;
            @Editable
            public ComponentConfig component = new ComponentConfig.Spacer();

            public Object getConstraints() {
                return this.location.getConstant();
            }
        }
    }

    public static class Anchor
    extends LayoutConfig {
        @Editable
        public Child[] children = new Child[0];

        @Override
        public void invalidate() {
            for (Child child : this.children) {
                child.component.invalidate();
            }
        }

        @Override
        protected void layout(GlContext ctx, Scope scope, MessageBundle msgs, Container cont, Component[] ochildren) {
            cont.setLayoutManager(new AnchorLayout());
            for (int ii = 0; ii < this.children.length; ++ii) {
                Child child = this.children[ii];
                Component ochild = ii < ochildren.length ? ochildren[ii] : null;
                cont.add(child.component.getComponent(ctx, scope, msgs, ochild), child.createConstraints());
            }
        }

        public static class Child
        extends DeepObject
        implements Exportable {
            @Editable(step=0.01, hgroup="c")
            public float childX = 0.5f;
            @Editable(step=0.01, hgroup="c")
            public float childY = 0.5f;
            @Editable(step=0.01, hgroup="p")
            public float parentX = 0.5f;
            @Editable(step=0.01, hgroup="p")
            public float parentY = 0.5f;
            @Editable(hgroup="o")
            public int offsetX = 0;
            @Editable(hgroup="o")
            public int offsetY = 0;
            @Editable
            public boolean fitToContainer;
            @Editable
            public ComponentConfig component = new ComponentConfig.Spacer();

            public Object createConstraints() {
                return new AnchorLayout.Anchor(this.childX, this.childY, this.parentX, this.parentY, this.offsetX, this.offsetY, this.fitToContainer);
            }
        }
    }

    public static class Absolute
    extends LayoutConfig {
        @Editable
        public boolean flipped;
        @Editable
        public Child[] children = new Child[0];

        @Override
        public void invalidate() {
            for (Child child : this.children) {
                child.component.invalidate();
            }
        }

        @Override
        protected void layout(GlContext ctx, Scope scope, MessageBundle msgs, Container cont, Component[] ochildren) {
            cont.setLayoutManager(new AbsoluteLayout(this.flipped));
            for (int ii = 0; ii < this.children.length; ++ii) {
                Child child = this.children[ii];
                Component ochild = ii < ochildren.length ? ochildren[ii] : null;
                cont.add(child.component.getComponent(ctx, scope, msgs, ochild), child.createConstraints());
            }
        }

        public static class SizedChild
        extends Child {
            @Editable(hgroup="c")
            public int width;
            @Editable(hgroup="c")
            public int height;

            @Override
            public Object createConstraints() {
                return new Rectangle(this.x, this.y, this.width, this.height);
            }
        }

        @EditorTypes(value={Child.class, SizedChild.class})
        public static class Child
        extends DeepObject
        implements Exportable {
            @Editable(hgroup="c")
            public int x;
            @Editable(hgroup="c")
            public int y;
            @Editable(weight=1.0)
            public ComponentConfig component = new ComponentConfig.Spacer();

            public Object createConstraints() {
                return new Point(this.x, this.y);
            }
        }
    }

    public static enum Justification {
        CENTER(GroupLayout.CENTER),
        LEFT(GroupLayout.LEFT),
        RIGHT(GroupLayout.RIGHT),
        TOP(GroupLayout.TOP),
        BOTTOM(GroupLayout.BOTTOM);

        protected GroupLayout.Justification _justification;

        public GroupLayout.Justification getJustification() {
            return this._justification;
        }

        private Justification(GroupLayout.Justification justification) {
            this._justification = justification;
        }
    }

    public static enum OffAxisPolicy {
        NONE(GroupLayout.NONE),
        STRETCH(GroupLayout.STRETCH),
        EQUALIZE(GroupLayout.EQUALIZE),
        CONSTRAIN(GroupLayout.CONSTRAIN);

        protected GroupLayout.Policy _policy;

        public GroupLayout.Policy getPolicy() {
            return this._policy;
        }

        private OffAxisPolicy(GroupLayout.Policy policy) {
            this._policy = policy;
        }
    }

    public static enum OnAxisPolicy {
        NONE(GroupLayout.NONE),
        STRETCH(GroupLayout.STRETCH),
        EQUALIZE(GroupLayout.EQUALIZE);

        protected GroupLayout.Policy _policy;

        public GroupLayout.Policy getPolicy() {
            return this._policy;
        }

        private OnAxisPolicy(GroupLayout.Policy policy) {
            this._policy = policy;
        }
    }

    public static enum VerticalAlignment {
        TOP(TableLayout.TOP),
        CENTER(TableLayout.CENTER),
        BOTTOM(TableLayout.BOTTOM);

        protected TableLayout.Alignment _alignment;

        public TableLayout.Alignment getAlignment() {
            return this._alignment;
        }

        private VerticalAlignment(TableLayout.Alignment alignment) {
            this._alignment = alignment;
        }
    }

    public static enum HorizontalAlignment {
        LEFT(TableLayout.LEFT),
        CENTER(TableLayout.CENTER),
        RIGHT(TableLayout.RIGHT),
        STRETCH(TableLayout.STRETCH);

        protected TableLayout.Alignment _alignment;

        public TableLayout.Alignment getAlignment() {
            return this._alignment;
        }

        private HorizontalAlignment(TableLayout.Alignment alignment) {
            this._alignment = alignment;
        }
    }

    public static enum Location {
        NORTH(BorderLayout.NORTH),
        SOUTH(BorderLayout.SOUTH),
        EAST(BorderLayout.EAST),
        WEST(BorderLayout.WEST),
        CENTER(BorderLayout.CENTER),
        IGNORE(BorderLayout.IGNORE);

        protected Integer _constant;

        public Integer getConstant() {
            return this._constant;
        }

        private Location(Integer constant) {
            this._constant = constant;
        }
    }
}

