/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.util.GlContext;

public class Window
extends Container
implements Comparable<Window> {
    protected Root _root;
    protected boolean _modal;
    protected int _layer;
    protected Component _savedFocus;
    protected Window _parentWindow;

    public Window(GlContext ctx, LayoutManager layout) {
        super(ctx);
        this.setLayoutManager(layout);
    }

    public void pack() {
        this.pack(-1, -1);
    }

    public void pack(int whint, int hhint) {
        Dimension ps = this.getPreferredSize(whint, hhint);
        this.setBounds(this._x, this._y, ps.width, ps.height);
    }

    public void center() {
        int width = this._root.getDisplayWidth();
        int height = this._root.getDisplayHeight();
        this.setLocation((width - this.getWidth()) / 2, (height - this.getHeight()) / 2);
    }

    public void setModal(boolean modal) {
        this._modal = modal;
    }

    public boolean isModal() {
        return this._modal;
    }

    public boolean shouldShadeBehind() {
        return this._modal;
    }

    public boolean isOverlay() {
        return false;
    }

    public Root getRoot() {
        return this._root;
    }

    public int getLayer() {
        return this._layer;
    }

    public void setLayer(int layer) {
        this._layer = layer;
        if (this._root != null) {
            this._root.resortWindows();
        }
    }

    public void dismiss() {
        if (this._root != null) {
            this._root.removeWindow(this);
        } else {
            Log.log.warning((Object)("Unmanaged window dismissed: " + this + "."), new Object[]{new Exception()});
        }
    }

    @Override
    public int compareTo(Window other) {
        return this._layer - other._layer;
    }

    @Override
    public void setParent(Container parent) {
        throw new RuntimeException("A window may not be added as a child of any other component. Add it to a BRootNode.");
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this._root != null) {
            this._root.rootInvalidated(this);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        boolean relocated = x != this._x || y != this._y;
        super.setBounds(x, y, width, height);
        if (relocated && this._root != null) {
            this._root.windowDidMove(this);
        }
    }

    @Override
    public boolean isAdded() {
        return this._root != null;
    }

    public void setParentWindow(Window parentWindow) {
        this._parentWindow = parentWindow;
    }

    public Window getParentWindow() {
        return this._parentWindow;
    }

    public ActionListener dismissListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Window.this.dismiss();
            }
        };
    }

    @Override
    protected String getDefaultStyleConfig() {
        return "Default/Window";
    }

    protected void setRoot(Root root) {
        if (this._root != root) {
            this._root = root;
            if (this._root == null) {
                this.wasRemoved();
            } else {
                this.wasAdded();
                if (this._width != 0 && this._height != 0) {
                    this.validate();
                }
            }
        }
    }

    protected void requestFocus(Component component) {
        if (this._root == null) {
            this._savedFocus = component;
        } else {
            this._root.requestFocus(component);
        }
    }

    protected void gotFocus() {
        if (this._savedFocus != null) {
            this._root.setFocus(this._savedFocus);
            this._savedFocus = null;
        }
    }
}

