/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.collect.Lists;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.ObserverList;
import com.samskivert.util.PropertiesUtil;
import com.samskivert.util.QuickSort;
import com.samskivert.util.SoftCache;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.config.ManagedConfig;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.expr.Scope;
import com.threerings.resource.ResourceManager;
import com.threerings.tudey.Log;
import com.threerings.util.Copyable;
import com.threerings.util.MessageManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;

public class ConfigManager
implements Copyable,
Exportable {
    Comparator ConfigGroupComparator = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getSimpleName().compareToIgnoreCase(o2.getSimpleName());
        }
    };
    protected String _type;
    protected ConfigManager _parent;
    protected ResourceManager _rsrcmgr;
    protected MessageManager _msgmgr;
    protected String _configPath;
    protected HashMap<Class<?>, ConfigGroup> _groups = new HashMap();
    protected SoftCache<String, ManagedConfig> _resources;
    protected HashMap<String, Class<?>[]> _classes;
    protected ObserverList<ConfigUpdateListener<ManagedConfig>> _updateListeners;
    protected boolean _ignoreUpdates;

    public ConfigManager(ResourceManager rsrcmgr, MessageManager msgmgr, String configPath) {
        this._type = "global";
        this._rsrcmgr = rsrcmgr;
        this._msgmgr = msgmgr;
        this._configPath = configPath + (configPath.endsWith("/") ? "" : "/");
    }

    public ConfigManager() {
    }

    public boolean isInitialized() {
        return this._resources != null;
    }

    public void init() {
        try {
            this.loadManagerProperties();
        }
        catch (IOException e) {
            ClydeLog.log.warning((Object)"Failed to load manager properties.", new Object[]{e});
            return;
        }
        this._resources = new SoftCache();
        Class<?>[] classes = this._classes.get("global");
        if (classes == null) {
            return;
        }
        Arrays.sort(classes, this.ConfigGroupComparator);
        Class<?>[] arr$ = classes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> clazz;
            Class<?> cclass = clazz = arr$[i$];
            this.registerGroup(cclass);
        }
    }

    public void init(String type, ConfigManager parent) {
        this._type = type;
        this._parent = parent;
        this._rsrcmgr = parent._rsrcmgr;
        this._msgmgr = parent._msgmgr;
        this._resources = parent._resources;
        this._classes = parent._classes;
        this._configPath = parent._configPath;
        HashMap<Class<?>, ConfigGroup> ogroups = this._groups;
        this._groups = new HashMap();
        Class<?>[] classes = this._classes.get(type);
        if (classes == null) {
            return;
        }
        ConfigManager root = parent.getRoot();
        Class<?>[] arr$ = classes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> clazz;
            Class<?> cclass = clazz = arr$[i$];
            root.registerGroup(cclass);
            ConfigGroup group = ogroups.get(clazz);
            if (group == null) continue;
            group.init(this);
            this._groups.put(clazz, group);
        }
    }

    public String getType() {
        return this._type;
    }

    public ConfigManager getParent() {
        return this._parent;
    }

    public ConfigManager getRoot() {
        return this._parent == null ? this : this._parent.getRoot();
    }

    public ResourceManager getResourceManager() {
        return this._rsrcmgr;
    }

    public MessageManager getMessageManager() {
        return this._msgmgr;
    }

    public String getConfigPath() {
        return this._configPath;
    }

    public boolean isResourceClass(Class<?> clazz) {
        return ListUtil.contains((Object[])this.getResourceClasses(), clazz);
    }

    public Class<?>[] getResourceClasses() {
        return this._classes.get("resource");
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, ConfigReference<T> ref) {
        return this.getConfig(clazz, ref, null);
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, ConfigReference<T> ref, Scope scope) {
        return ref == null ? null : (T)this.getConfig(clazz, ref.getName(), scope, ref.getArguments());
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getConfig(clazz, name, null, firstKey, firstValue, otherArgs);
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, Scope scope, String firstKey, Object firstValue, Object ... otherArgs) {
        return this.getConfig(clazz, name, scope, new ArgumentMap(firstKey, firstValue, otherArgs));
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, Scope scope) {
        return this.getConfig(clazz, name, scope, null);
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, ArgumentMap args) {
        return this.getConfig(clazz, name, null, args);
    }

    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name, Scope scope, ArgumentMap args) {
        T config = this.getConfig(clazz, name);
        return (T)(config == null ? null : (ManagedConfig)clazz.cast(((ManagedConfig)config).getInstance(scope, args)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends ManagedConfig> T getConfig(Class<T> clazz, String name) {
        T t;
        T t2;
        Object var3_3 = null;
        if (name == null) {
            T t3 = null;
            return t3;
        }
        if (this.isResourceClass(clazz)) {
            ManagedConfig managedConfig;
            ManagedConfig cfg = this.getResourceConfig(name);
            if (cfg != null && !clazz.isInstance(cfg)) {
                throw new ClassCastException("[config=" + name + ", expected=" + clazz + ", actual=" + cfg.getClass() + "]");
            }
            ManagedConfig managedConfig2 = managedConfig = (ManagedConfig)clazz.cast(cfg);
            return (T)managedConfig2;
        }
        ConfigGroup<T> group = this.getGroup(clazz);
        if (group != null && (t2 = group.getConfig(name)) != null) {
            T t4 = t2;
            return t4;
        }
        if (this._parent == null) {
            t = null;
        } else {
            T t5 = this._parent.getConfig(clazz, name);
            t = t5;
            T t6 = t5;
        }
        T t7 = t;
        return t7;
    }

    public ManagedConfig getResourceConfig(String name) {
        ManagedConfig config = (ManagedConfig)this._resources.get((Object)name);
        if (config == null) {
            try {
                BinaryImporter in = new BinaryImporter(this._rsrcmgr.getResource(name));
                config = (ManagedConfig)in.readObject();
                this._resources.put((Object)name, (Object)config);
                config.setName(name);
                config.init(this.getRoot());
                in.close();
            }
            catch (FileNotFoundException fnfe) {
                return null;
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Failed to load config from resource.", new Object[]{"name", name, e});
                return null;
            }
        }
        return config;
    }

    public <T extends ManagedConfig> ConfigGroup<T>[] getGroups(Class<T> clazz) {
        ArrayList<ConfigGroup<T>> groups = new ArrayList<ConfigGroup<T>>();
        for (ConfigManager cfgmgr = this; cfgmgr != null; cfgmgr = cfgmgr.getParent()) {
            ConfigGroup<T> group = cfgmgr.getGroup(clazz);
            if (group == null) continue;
            groups.add(group);
        }
        ConfigGroup[] array = new ConfigGroup[groups.size()];
        return groups.toArray(array);
    }

    public <T extends ManagedConfig> ConfigGroup<T> getGroup(Class<T> clazz) {
        ConfigGroup group = this._groups.get(clazz);
        return group;
    }

    public ConfigGroup[] getGroups(String name) {
        ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
        for (ConfigManager cfgmgr = this; cfgmgr != null; cfgmgr = cfgmgr.getParent()) {
            ConfigGroup group = cfgmgr.getGroup(name, false);
            if (group == null) continue;
            groups.add(group);
        }
        return groups.toArray(new ConfigGroup[groups.size()]);
    }

    public ConfigGroup getGroup(String name) {
        return this.getGroup(name, true);
    }

    public ConfigGroup getGroup(String name, boolean forward) {
        for (ConfigGroup group : this._groups.values()) {
            if (!group.getName().equals(name)) continue;
            return group;
        }
        return forward && this._parent != null ? this._parent.getGroup(name) : null;
    }

    public Collection<ConfigGroup> getGroups() {
        ArrayList<ConfigGroup> list = new ArrayList<ConfigGroup>();
        Class<?>[] classes = this.getRoot()._classes.get(this.getType());
        if (classes == null) {
            return list;
        }
        for (Class<?> clazz : classes) {
            ConfigGroup<?>[] groups;
            for (ConfigGroup<?> group : groups = this.getGroups(clazz)) {
                list.add(group);
            }
        }
        return list;
    }

    public void addUpdateListener(ConfigUpdateListener listener) {
        if (this._updateListeners == null) {
            this._updateListeners = ObserverList.newFastUnsafe();
        }
        ConfigUpdateListener mlistener = listener;
        this._updateListeners.add((Object)mlistener);
    }

    public void removeUpdateListener(ConfigUpdateListener listener) {
        if (this._updateListeners != null) {
            ConfigUpdateListener mlistener = listener;
            this._updateListeners.remove((Object)mlistener);
            if (this._updateListeners.isEmpty()) {
                this._updateListeners = null;
            }
        }
    }

    public void saveAll() {
        for (ConfigGroup group : this._groups.values()) {
            group.save();
        }
    }

    public void revertAll() {
        for (ConfigGroup group : this._groups.values()) {
            group.revert();
        }
    }

    public ManagedConfig updateResourceConfig(String name, ManagedConfig config) {
        ManagedConfig oconfig = (ManagedConfig)this._resources.get((Object)name);
        if (oconfig == null) {
            this._resources.put((Object)name, (Object)config);
            return config;
        }
        config.copy(oconfig);
        oconfig.wasUpdated();
        return oconfig;
    }

    public boolean validateReferences(String where, PrintStream out) {
        boolean result = true;
        for (ConfigGroup group : this.getGroups()) {
            String gwhere = where + group.getName() + ":";
            for (ManagedConfig config : group.getConfigs()) {
                result = config.validateReferences(gwhere + config.getName(), out) && result;
            }
        }
        return result;
    }

    public void refresh(Class<? extends ManagedConfig> clazz) {
        ConfigGroup<? extends ManagedConfig>[] groups = this.getGroups(clazz);
        if (groups.length > 0) {
            for (ConfigGroup<? extends ManagedConfig> group : groups) {
                for (ManagedConfig managedConfig : group.getConfigs()) {
                    this.refresh(managedConfig);
                }
            }
            return;
        }
        for (SoftReference ref : Lists.newArrayList(this._resources.getMap().values())) {
            ManagedConfig nconfig;
            ManagedConfig oconfig = (ManagedConfig)ref.get();
            if (!clazz.isInstance(oconfig)) continue;
            String name = oconfig.getName();
            try {
                BinaryImporter binaryImporter = new BinaryImporter(this._rsrcmgr.getResource(name));
                nconfig = (ManagedConfig)binaryImporter.readObject();
                nconfig.setName(name);
                nconfig.init(this.getRoot());
                binaryImporter.close();
            }
            catch (Exception exception) {
                ClydeLog.log.warning((Object)"Failed to refresh config from resource.", new Object[]{"name", name, exception});
                continue;
            }
            nconfig.copy(oconfig);
            this.refresh(oconfig);
        }
    }

    public void writeFields(Exporter out) throws IOException {
        ArrayList list = Lists.newArrayList();
        for (ConfigGroup group : this._groups.values()) {
            if (group.getConfigs().isEmpty()) continue;
            list.add(group);
        }
        Object[] groups = list.toArray(new ConfigGroup[list.size()]);
        QuickSort.sort((Object[])groups, (Comparator)new Comparator<ConfigGroup>(){

            @Override
            public int compare(ConfigGroup g1, ConfigGroup g2) {
                return g1.getName().compareTo(g2.getName());
            }
        });
        out.write("groups", groups, new ConfigGroup[0], ConfigGroup[].class);
    }

    public void readFields(Importer in) throws IOException {
        ConfigGroup[] groups;
        for (ConfigGroup group : groups = in.read("groups", new ConfigGroup[0], ConfigGroup[].class)) {
            this._groups.put(group.getConfigClass(), group);
        }
    }

    @Override
    public Object copy(Object dest) {
        return this.copy(dest, null);
    }

    @Override
    public Object copy(Object dest, Object outer) {
        ConfigManager other = dest instanceof ConfigManager ? (ConfigManager)dest : new ConfigManager();
        for (ConfigGroup group : this._groups.values()) {
            Class clazz = group.getConfigClass();
            ConfigGroup ogroup = other._groups.get(clazz);
            other._groups.put(clazz, (ConfigGroup)group.copy(ogroup));
        }
        return other;
    }

    protected void loadManagerProperties() throws IOException {
        Properties props = new Properties();
        InputStream in = this.getClass().getResourceAsStream("/manager.properties");
        props.load(in == null ? this._rsrcmgr.getResource(this._configPath + "manager.properties") : in);
        this._classes = new HashMap();
        Object[] types = StringUtil.parseStringArray((String)props.getProperty("types", ""));
        for (Object type : types = (String[])ArrayUtil.append((Object[])types, (Object)"resource")) {
            Properties tprops = PropertiesUtil.getSubProperties((Properties)props, (String)type);
            String[] names = StringUtil.parseStringArray((String)tprops.getProperty("classes", ""));
            Class[] classes = new Class[names.length];
            for (int ii = 0; ii < names.length; ++ii) {
                try {
                    classes[ii] = Class.forName(names[ii]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    Log.log.warning((Object)("class not found:" + e.getMessage()), new Object[]{e});
                }
            }
            Arrays.sort(classes, this.ConfigGroupComparator);
            this._classes.put((String)type, classes);
        }
    }

    protected <T extends ManagedConfig> ConfigGroup<T> registerGroup(Class<T> clazz) {
        ConfigGroup<T> group = this._groups.get(clazz);
        if (group == null) {
            group = new ConfigGroup<T>(clazz);
            group.init(this);
            this._groups.put(clazz, group);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(ManagedConfig config) {
        this._ignoreUpdates = true;
        try {
            config.wasUpdated();
        }
        finally {
            this._ignoreUpdates = false;
        }
    }

    protected void fireConfigUpdated(ManagedConfig config) {
        if (this._updateListeners != null && !this._ignoreUpdates) {
            final ConfigEvent<ManagedConfig> event = new ConfigEvent<ManagedConfig>(this, config);
            this._updateListeners.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigUpdateListener<ManagedConfig>>(){

                public boolean apply(ConfigUpdateListener<ManagedConfig> listener) {
                    listener.configUpdated(event);
                    return true;
                }
            });
        }
    }
}

