/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.Interval;
import com.samskivert.util.RunQueue;
import com.threerings.config.ConfigManager;
import com.threerings.crowd.data.BodyObject;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.tudey.data.TudeyCodes;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.server.TudeySceneMoveHandler;
import com.threerings.tudey.server.util.SceneTicker;
import com.threerings.whirled.client.SceneService;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.server.SceneMoveHandler;
import com.threerings.whirled.server.SceneRegistry;
import com.threerings.whirled.util.UpdateList;
import java.util.Iterator;

@Singleton
public class TudeySceneRegistry
extends SceneRegistry
implements TudeyCodes {
    protected PresentsDObjectMgr _omgr;
    @Inject
    protected ConfigManager _cfgmgr;
    protected HashIntMap<PortalMapping> _portals = IntMaps.newHashIntMap();
    protected SceneTicker _defaultTicker;
    protected static final long PORTAL_MAPPING_LIFESPAN = 30000L;
    protected static final long PORTAL_PRUNE_INTERVAL = 300000L;

    @Inject
    public TudeySceneRegistry(PresentsDObjectMgr omgr, InvocationManager invmgr) {
        super(invmgr);
        this._omgr = omgr;
        this._defaultTicker = this.createDefaultTicker();
        new Interval((RunQueue)this._omgr){

            public void expired() {
                TudeySceneRegistry.this.prunePortalMappings();
            }
        }.schedule(300000L, true);
    }

    public void moveBody(BodyObject source, int sceneId, Object portalKey) {
        this.addPortalMapping(source, sceneId, portalKey);
        super.moveBody(source, sceneId);
    }

    public void resolveScene(ClientObject caller, int sceneId, SceneRegistry.ResolutionListener listener) {
        this.resolveScene(sceneId, listener);
    }

    public SceneTicker getDefaultTicker() {
        return this._defaultTicker;
    }

    public void moveTo(ClientObject caller, int sceneId, int sceneVer, SceneService.SceneMoveListener listener) {
        BodyObject body = (BodyObject)caller;
        Object portalKey = this.removePortalMapping(body, sceneId);
        SceneMoveHandler handler = portalKey != null ? new TudeySceneMoveHandler(this._locman, body, sceneVer, portalKey, listener) : new SceneMoveHandler(this._locman, body, sceneVer, listener);
        this.resolveScene(caller, sceneId, (SceneRegistry.ResolutionListener)handler);
    }

    protected void processSuccessfulResolution(SceneModel model, UpdateList updates, Object extras) {
        ((TudeySceneModel)model).init(this._cfgmgr);
        super.processSuccessfulResolution(model, updates, extras);
    }

    protected SceneTicker createDefaultTicker() {
        return new SceneTicker.EventThread((RunQueue)this._omgr, 50);
    }

    protected void addPortalMapping(BodyObject source, int sceneId, Object portalKey) {
        this._portals.put(source.getOid(), (Object)new PortalMapping(sceneId, portalKey));
    }

    protected Object removePortalMapping(BodyObject source, int sceneId) {
        PortalMapping mapping = (PortalMapping)this._portals.remove(source.getOid());
        return mapping != null && mapping.getSceneId() == sceneId && mapping.getExpiry() > System.currentTimeMillis() ? mapping.getPortalKey() : null;
    }

    protected void prunePortalMappings() {
        long now = System.currentTimeMillis();
        Iterator it = this._portals.intEntrySet().iterator();
        while (it.hasNext()) {
            IntMap.IntEntry entry = (IntMap.IntEntry)it.next();
            if (this._omgr.getObject(entry.getIntKey()) != null && now < ((PortalMapping)entry.getValue()).getExpiry()) continue;
            it.remove();
        }
    }

    protected static class PortalMapping {
        protected int _sceneId;
        protected Object _portalKey;
        protected long _expiry;

        public PortalMapping(int sceneId, Object portalKey) {
            this._sceneId = sceneId;
            this._portalKey = portalKey;
            this._expiry = System.currentTimeMillis() + 30000L;
        }

        public int getSceneId() {
            return this._sceneId;
        }

        public Object getPortalKey() {
            return this._portalKey;
        }

        public long getExpiry() {
            return this._expiry;
        }
    }
}

