/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.tools;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.opengl.GlCanvasTool;
import com.threerings.opengl.Log;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.ModelObserver;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.tools.ModelTool;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.ChangeBlock;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModelViewer
extends ModelTool
implements ChangeListener,
ConfigUpdateListener<ModelConfig>,
ModelObserver {
    protected JCheckBoxMenuItem _autoReset;
    protected JPanel _cpanel;
    protected EditorPanel _epanel;
    protected JPanel _apanel;
    protected JPanel _tpanels;
    protected JButton _removeTrack;
    protected DraggableSpinner _speedSpinner;
    protected long _lastUpdate = System.currentTimeMillis();
    protected float _elapsed;
    protected ChangeBlock _block = new ChangeBlock();
    protected static Preferences _prefs = Preferences.userNodeForPackage(ModelViewer.class);
    protected static final DecimalFormat SPEED_FORMAT = new DecimalFormat("0.00x");

    public static void main(String[] args) {
        new ModelViewer(args.length > 0 ? args[0] : null).startup();
    }

    public ModelViewer(String model) {
        super("editor.viewer");
        String path;
        this._frame.setTitle(this._msgs.get("m.title"));
        JMenuBar menubar = new JMenuBar();
        this._frame.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        file.add(this.createMenuItem("quit", 81, 81));
        JMenu edit = this.createMenu("edit", 69);
        menubar.add(edit);
        edit.add(this.createMenuItem("configs", 67, 71));
        edit.add(this.createMenuItem("resources", 82, 82));
        edit.add(this.createMenuItem("preferences", 80, 80));
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._autoReset = this.createCheckBoxMenuItem("auto_reset", 65, 69);
        view.add(this._autoReset);
        view.addSeparator();
        this._showEnvironment = this.createCheckBoxMenuItem("environment", 69, 86);
        view.add(this._showEnvironment);
        this._showEnvironment.setSelected(true);
        this._showGrid = this.createCheckBoxMenuItem("grid", 71, 68);
        view.add(this._showGrid);
        this._showGrid.setSelected(true);
        this._showBounds = this.createCheckBoxMenuItem("bounds", 66, 66);
        view.add(this._showBounds);
        this._showCompass = this.createCheckBoxMenuItem("compass", 67, 77);
        view.add(this._showCompass);
        this._showCompass.setSelected(true);
        this._showStats = this.createCheckBoxMenuItem("stats", 83, 84);
        view.add(this._showStats);
        view.addSeparator();
        view.add(this.createMenuItem("refresh", 70, 70));
        view.addSeparator();
        view.add(this.createMenuItem("recenter", 67, 67));
        view.add(this.createMenuItem("reset", 82, 82, 0));
        JMenu tools = this.createMenu("tools", 84);
        menubar.add(tools);
        tools.add(this.createMenuItem("save_snapshot", 83, 123, 0));
        this._cpanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._cpanel.setPreferredSize(new Dimension(350, 1));
        this._epanel = new EditorPanel(this);
        this._cpanel.add((Component)((Object)this._epanel));
        this._apanel = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._apanel.setBorder(BorderFactory.createTitledBorder(this._msgs.get("m.animations")));
        this._cpanel.add((Component)this._apanel, GroupLayout.FIXED);
        this._apanel.setVisible(false);
        this._tpanels = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._apanel.add(this._tpanels);
        JPanel buttons = new JPanel();
        this._apanel.add(buttons);
        buttons.add(this.createButton("add_track"));
        this._removeTrack = this.createButton("remove_track");
        buttons.add(this._removeTrack);
        this._removeTrack.setEnabled(false);
        JPanel controls = new JPanel();
        this._cpanel.add((Component)controls, GroupLayout.FIXED);
        controls.add(new JLabel(this._msgs.get("m.global_speed")));
        this._speedSpinner = new DraggableSpinner(1.0f, 0.0f, Float.MAX_VALUE, 0.01f);
        controls.add(this._speedSpinner);
        this._speedSpinner.setMinimumSize(this._speedSpinner.getPreferredSize());
        this._speedSpinner.setMaximumSize(this._speedSpinner.getPreferredSize());
        this._speedSpinner.addChangeListener(this);
        ModelConfig.Derived impl = new ModelConfig.Derived();
        if (model != null && (path = this._rsrcmgr.getResourcePath(new File(model))) != null) {
            impl.model = new ConfigReference(path);
        }
        this._epanel.setObject(impl);
        this._epanel.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this._epanel) {
            if (!this._block.enter()) {
                return;
            }
            try {
                this._model.getConfig().wasUpdated();
            }
            finally {
                this._block.leave();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configUpdated(ConfigEvent<ModelConfig> event) {
        Animation[] anims = this._model.getAnimations();
        if (anims.length == 0) {
            this._apanel.setVisible(false);
        } else {
            this._apanel.setVisible(true);
            int nn = this._tpanels.getComponentCount();
            for (int ii = 0; ii < nn; ++ii) {
                ((TrackPanel)this._tpanels.getComponent(ii)).updateAnimations();
            }
        }
        if (!this._block.enter()) {
            return;
        }
        try {
            this._epanel.update();
            this._epanel.validate();
        }
        finally {
            this._block.leave();
        }
    }

    @Override
    public boolean animationStarted(Animation animation) {
        this.updateTrackControls();
        return true;
    }

    @Override
    public boolean animationStopped(Animation animation, boolean completed) {
        this.updateTrackControls();
        return true;
    }

    @Override
    public boolean modelCompleted(Model model) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("add_track")) {
            this._tpanels.add(new TrackPanel());
            this._removeTrack.setEnabled(true);
            SwingUtil.refresh((JComponent)this._cpanel);
        } else if (action.equals("remove_track")) {
            this._tpanels.remove(this._tpanels.getComponentCount() - 1);
            this._removeTrack.setEnabled(this._tpanels.getComponentCount() > 1);
            SwingUtil.refresh((JComponent)this._cpanel);
        } else if (action.equals("save_snapshot")) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            File file = new File("./snapshot", "viewer_" + fmt.format(new Date()) + ".png");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                ImageIO.write((RenderedImage)this.createSnapshot(true), "png", file);
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to write snapshot.", new Object[]{"file", file, e});
            }
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    protected JComponent createCanvasContainer() {
        this._cpanel = GroupLayout.makeVStretchBox((int)5);
        JSplitPane pane = new JSplitPane(1, true, this._canvas, this._cpanel);
        this._canvas.setMinimumSize(new Dimension(1, 1));
        pane.setResizeWeight(1.0);
        pane.setOneTouchExpandable(true);
        return pane;
    }

    @Override
    protected GlCanvasTool.CanvasToolPrefs createEditablePrefs() {
        return new ModelTool.ModelToolPrefs(_prefs);
    }

    @Override
    protected void didInit() {
        super.didInit();
        ModelConfig config = new ModelConfig();
        config.init(this._cfgmgr);
        config.implementation = (ModelConfig.Derived)this._epanel.getObject();
        config.addListener(this);
        this._model = new Model((GlContext)this, config);
        this._scene.add(this._model);
        this._model.addObserver(this);
        this._apanel.setVisible(this._model.getAnimations().length > 0);
        this._tpanels.add(new TrackPanel());
    }

    @Override
    protected void updateView() {
        long nnow = System.currentTimeMillis();
        this._elapsed += (float)(nnow - this._lastUpdate) * this._speedSpinner.getFloatValue();
        this._lastUpdate = nnow;
        long lelapsed = (long)this._elapsed;
        this._elapsed -= (float)lelapsed;
        this._now.value += lelapsed;
        this.updateView((float)lelapsed / 1000.0f);
    }

    @Override
    protected void updateView(float elapsed) {
        super.updateView(elapsed);
        if (this._autoReset.isSelected() && this._model.hasCompleted()) {
            this._model.reset();
        }
    }

    protected void updateTrackControls() {
        int nn = this._tpanels.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            ((TrackPanel)this._tpanels.getComponent(ii)).updateControls();
        }
    }

    static {
        SPEED_FORMAT.setMaximumFractionDigits(2);
    }

    protected class TrackPanel
    extends JPanel
    implements ActionListener {
        protected JComboBox _box;
        protected JButton _start;
        protected JButton _stop;

        public TrackPanel() {
            this._box = new JComboBox<Animation>(ModelViewer.this._model.getAnimations());
            this.add(this._box);
            this._box.addActionListener(this);
            this.add((Component)new Spacer(1, 1));
            this._start = new JButton(ModelViewer.this._msgs.get("m.start"));
            this.add(this._start);
            this._start.addActionListener(this);
            this._stop = new JButton(ModelViewer.this._msgs.get("m.stop"));
            this.add(this._stop);
            this._stop.addActionListener(this);
            this.updateControls();
        }

        public void updateAnimations() {
            this._box.setModel(new DefaultComboBoxModel<Animation>(ModelViewer.this._model.getAnimations()));
            this.updateControls();
        }

        public void updateControls() {
            Animation animation = (Animation)this._box.getSelectedItem();
            this._start.setEnabled(animation != null);
            this._stop.setEnabled(animation != null && animation.isPlaying());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this._box) {
                this.updateControls();
            } else if (source == this._start) {
                ((Animation)this._box.getSelectedItem()).start();
            } else if (source == this._stop) {
                ((Animation)this._box.getSelectedItem()).stop();
            }
        }
    }
}

