/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.samskivert.util.ListUtil;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;

public class BorderLayout
extends LayoutManager {
    public static final Integer NORTH = new Integer(0);
    public static final Integer SOUTH = new Integer(1);
    public static final Integer EAST = new Integer(2);
    public static final Integer WEST = new Integer(3);
    public static final Integer CENTER = new Integer(4);
    public static final Integer IGNORE = new Integer(5);
    protected int _hgap;
    protected int _vgap;
    protected Component[] _components = new Component[5];
    protected static final Integer[] VERTS = new Integer[]{SOUTH, NORTH};
    protected static final Integer[] HORIZS = new Integer[]{EAST, WEST};

    public BorderLayout() {
        this(0, 0);
    }

    public BorderLayout(int hgap, int vgap) {
        this.setGaps(hgap, vgap);
    }

    public void setGaps(int hgap, int vgap) {
        this._hgap = hgap;
        this._vgap = vgap;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Integer) {
            if (constraints != IGNORE) {
                this._components[((Integer)constraints).intValue()] = comp;
            }
        } else {
            throw new IllegalArgumentException("Components added to a BorderLayout must have proper constraints (eg. BorderLayout.NORTH).");
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (int ii = 0; ii < this._components.length; ++ii) {
            if (this._components[ii] != comp) continue;
            this._components[ii] = null;
            break;
        }
    }

    @Override
    public Object getConstraints(Component comp) {
        int idx = ListUtil.indexOfRef((Object[])this._components, (Object)comp);
        return idx == -1 ? null : Integer.valueOf(idx);
    }

    @Override
    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        Component comp;
        Dimension psize = new Dimension();
        int horizComps = 0;
        int vertComps = 0;
        for (Integer vert : VERTS) {
            comp = this._components[vert];
            if (comp == null || !comp.isVisible()) continue;
            Dimension cpsize = comp.getPreferredSize(whint, -1);
            psize.width = Math.max(psize.width, cpsize.width);
            psize.height += cpsize.height;
            ++vertComps;
            if (hhint <= 0) continue;
            hhint -= cpsize.height + this._vgap;
        }
        int centerWidth = 0;
        int centerHeight = 0;
        for (Integer horiz : HORIZS) {
            comp = this._components[horiz];
            if (comp == null || !comp.isVisible()) continue;
            Dimension cpsize = comp.getPreferredSize(-1, hhint);
            centerWidth += cpsize.width;
            centerHeight = Math.max(centerHeight, cpsize.height);
            ++horizComps;
            if (whint <= 0) continue;
            whint -= cpsize.width + this._hgap;
        }
        comp = this._components[CENTER];
        if (comp != null && comp.isVisible()) {
            Dimension cpsize = comp.getPreferredSize(whint, hhint);
            centerWidth += cpsize.width;
            centerHeight = Math.max(centerHeight, cpsize.height);
            ++horizComps;
        }
        centerWidth += Math.max(horizComps - 1, 0) * this._hgap;
        if (centerHeight > 0) {
            ++vertComps;
        }
        psize.width = Math.max(psize.width, centerWidth);
        psize.height += centerHeight;
        psize.height += Math.max(vertComps - 1, 0) * this._vgap;
        return psize;
    }

    @Override
    public void layoutContainer(Container target) {
        Dimension cpsize;
        Insets insets = target.getInsets();
        int x = insets.left;
        int y = insets.bottom;
        int width = target.getWidth() - insets.getHorizontal();
        int height = target.getHeight() - insets.getVertical();
        Component comp = this._components[SOUTH];
        if (comp != null && comp.isVisible()) {
            cpsize = comp.getPreferredSize(width, -1);
            comp.setBounds(x, y, width, cpsize.height);
            y += cpsize.height + this._vgap;
            height -= cpsize.height + this._vgap;
        }
        if ((comp = this._components[NORTH]) != null && comp.isVisible()) {
            cpsize = comp.getPreferredSize(width, -1);
            comp.setBounds(x, target.getHeight() - insets.top - cpsize.height, width, cpsize.height);
            height -= cpsize.height + this._vgap;
        }
        if ((comp = this._components[WEST]) != null && comp.isVisible()) {
            cpsize = comp.getPreferredSize(-1, -1);
            comp.setBounds(x, y, cpsize.width, height);
            x += cpsize.width + this._hgap;
            width -= cpsize.width + this._hgap;
        }
        if ((comp = this._components[EAST]) != null && comp.isVisible()) {
            cpsize = comp.getPreferredSize(-1, -1);
            comp.setBounds(target.getWidth() - insets.right - cpsize.width, y, cpsize.width, height);
            width -= cpsize.width + this._hgap;
        }
        if ((comp = this._components[CENTER]) != null && comp.isVisible()) {
            comp.setBounds(x, y, width, height);
        }
    }
}

