/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Box;
import com.threerings.math.Vector3f;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.material.config.GeometryMaterial;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.Static;
import com.threerings.opengl.model.config.InfluenceFlagConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;

public class GeneratedStaticConfig
extends ModelConfig.Implementation {
    @Editable
    public InfluenceFlagConfig influences = new InfluenceFlagConfig();
    @Editable
    public Generator generator = new Quad();
    @DeepOmit
    protected transient SoftReference<StaticConfig.Resolved> _resolved;

    @Override
    public void preload(GlContext ctx) {
        this.generator.preload(ctx);
    }

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        StaticConfig.Resolved resolved;
        StaticConfig.Resolved resolved2 = resolved = this._resolved == null ? null : this._resolved.get();
        if (resolved == null) {
            resolved = this.generator.generate(ctx, this.influences.getFlags());
            this._resolved = new SoftReference<StaticConfig.Resolved>(resolved);
        }
        if (impl instanceof Static) {
            ((Static)impl).setConfig(ctx, resolved);
        } else {
            impl = new Static(ctx, scope, resolved);
        }
        return impl;
    }

    @Override
    public void invalidate() {
        this._resolved = null;
    }

    public static class Quad
    extends Generator {
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float sizeX = 2.0f;
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float sizeY = 2.0f;
        @Editable(min=1.0, hgroup="d")
        public int divisionsX = 1;
        @Editable(min=1.0, hgroup="d")
        public int divisionsY = 1;
        @Editable(nullable=true)
        public ConfigReference<MaterialConfig> material;

        @Override
        public void preload(GlContext ctx) {
            new Preloadable.Config(MaterialConfig.class, this.material).preload(ctx);
        }

        @Override
        public StaticConfig.Resolved generate(GlContext ctx, int influenceFlags) {
            float lx = -this.sizeX / 2.0f;
            float ux = this.sizeX / 2.0f;
            float ly = -this.sizeY / 2.0f;
            float uy = this.sizeY / 2.0f;
            Box bounds = new Box(new Vector3f(lx, ly, 0.0f), new Vector3f(ux, uy, 0.0f));
            CollisionMesh collision = new CollisionMesh(new Vector3f(lx, ly, 0.0f), new Vector3f(ux, uy, 0.0f), new Vector3f(lx, uy, 0.0f), new Vector3f(lx, ly, 0.0f), new Vector3f(ux, ly, 0.0f), new Vector3f(ux, uy, 0.0f));
            MaterialConfig material = ctx.getConfigManager().getConfig(MaterialConfig.class, this.material);
            GeometryConfig geometry = GeometryConfig.createQuad(this.sizeX, this.sizeY, this.divisionsX, this.divisionsY);
            GeometryMaterial[] gmats = new GeometryMaterial[]{new GeometryMaterial(geometry, material)};
            return new StaticConfig.Resolved(bounds, collision, gmats, influenceFlags);
        }
    }

    @EditorTypes(value={Quad.class})
    public static abstract class Generator
    extends DeepObject
    implements Exportable,
    Preloadable.LoadableConfig {
        public abstract StaticConfig.Resolved generate(GlContext var1, int var2);
    }
}

