/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.samskivert.util.Tuple;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.ReferenceConstraints;
import com.threerings.editor.Editable;
import com.threerings.editor.Introspector;
import com.threerings.editor.Log;
import com.threerings.editor.Property;
import com.threerings.editor.Strippable;
import com.threerings.export.Exportable;
import com.threerings.export.ObjectMarshaller;
import com.threerings.resource.ResourceManager;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PropertyUtil {
    protected static final Object STRIP_OUT = new Object();

    public static String getMode(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            String mode = lineage[ii].getMode();
            if ("%INHERIT%".equals(mode)) continue;
            return mode;
        }
        return "";
    }

    public static String getUnits(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            String units = lineage[ii].getUnits();
            if ("%INHERIT%".equals(units)) continue;
            return units;
        }
        return "";
    }

    public static double getMinimum(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            double min = lineage[ii].getMinimum();
            if (min == Double.NEGATIVE_INFINITY) continue;
            return min;
        }
        return -1.7976931348623157E308;
    }

    public static double getMaximum(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            double max = lineage[ii].getMaximum();
            if (max == Double.NEGATIVE_INFINITY) continue;
            return max;
        }
        return Double.MAX_VALUE;
    }

    public static double getStep(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            double step = lineage[ii].getStep();
            if (step == Double.NEGATIVE_INFINITY) continue;
            return step;
        }
        return 1.0;
    }

    public static double getScale(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            double scale = lineage[ii].getScale();
            if (scale == Double.NEGATIVE_INFINITY) continue;
            return scale;
        }
        return 1.0;
    }

    public static int getMinSize(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            int min = lineage[ii].getMinSize();
            if (min == Integer.MIN_VALUE) continue;
            return min;
        }
        return 0;
    }

    public static int getMaxSize(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            int max = lineage[ii].getMaxSize();
            if (max == Integer.MIN_VALUE) continue;
            return max;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isFixedSize(Property[] lineage) {
        for (int ii = lineage.length - 1; ii >= 0; --ii) {
            if (!lineage[ii].isFixedSize()) continue;
            return true;
        }
        return false;
    }

    public static Predicate<ManagedConfig> getRawConfigPredicate(ReferenceConstraints constraints) {
        if (constraints == null) {
            return Predicates.alwaysTrue();
        }
        final List<Class<? extends ManagedConfig>> vals = Arrays.asList(constraints.value());
        return new Predicate<ManagedConfig>(){

            public boolean apply(ManagedConfig cfg) {
                return vals.contains(cfg.getClass());
            }
        };
    }

    public static void getReferences(ConfigManager cfgmgr, Object object, Set<Tuple<Class<?>, String>> configs, Set<String> resources) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            for (Object element : (Object[])object) {
                PropertyUtil.getReferences(cfgmgr, element, configs, resources);
            }
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int nn = list.size();
            for (int ii = 0; ii < nn; ++ii) {
                PropertyUtil.getReferences(cfgmgr, list.get(ii), configs, resources);
            }
            return;
        }
        for (Property property : Introspector.getProperties(object)) {
            PropertyUtil.getReferences(cfgmgr, object, property, configs, resources);
        }
    }

    public static boolean validateReferences(String where, ConfigManager cfgmgr, Set<Tuple<Class<?>, String>> configs, Set<String> resources, PrintStream out) {
        boolean result = true;
        for (Tuple<Class<?>, String> tuple : configs) {
            Class cclass = (Class)tuple.left;
            if (cfgmgr.getConfig(cclass, (String)tuple.right) != null) continue;
            out.println(where + " references missing config of type " + ConfigGroup.getName(cclass) + ": " + (String)tuple.right);
            result = false;
        }
        ResourceManager rsrcmgr = cfgmgr.getResourceManager();
        for (String resource : resources) {
            if (rsrcmgr.getResourceFile(resource).exists()) continue;
            out.println(where + " references missing resource: " + resource);
            result = false;
        }
        return result;
    }

    public static void getResources(ConfigManager cfgmgr, Object object, Set<String> paths) {
        PropertyUtil.getResources(cfgmgr, object, paths, new ConfigReferenceSet());
    }

    public static void transferCompatibleProperties(Object source, Object dest) {
        Property[] destProps = Introspector.getProperties(dest);
        block2: for (Property srcProp : Introspector.getProperties(source)) {
            String name = srcProp.getName();
            for (Property destProp : destProps) {
                if (!name.equals(destProp.getName())) continue;
                if (!srcProp.isCompatible(destProp)) continue block2;
                try {
                    destProp.set(dest, srcProp.get(source));
                }
                catch (Throwable t) {
                    Log.log.warning((Object)"Destination property not compatible after all?", new Object[]{t});
                }
                continue block2;
            }
        }
    }

    public static Object strip(ConfigManager cfgmgr, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] oarray;
            ArrayList list = Lists.newArrayList();
            for (Object element : oarray = (Object[])object) {
                if (PropertyUtil.isStrippable(element)) continue;
                list.add(PropertyUtil.strip(cfgmgr, element));
            }
            int nsize = list.size();
            return list.toArray(oarray.length == nsize ? oarray : (Object[])Array.newInstance(oarray.getClass().getComponentType(), nsize));
        }
        if (object instanceof List) {
            List list = (List)object;
            for (int ii = list.size() - 1; ii >= 0; --ii) {
                Object element = list.get(ii);
                if (PropertyUtil.isStrippable(element)) {
                    list.remove(ii);
                    continue;
                }
                list.set(ii, PropertyUtil.strip(cfgmgr, element));
            }
            return list;
        }
        if (!(object instanceof Exportable)) {
            return object;
        }
        Class<?> clazz = object.getClass();
        Object prototype = ObjectMarshaller.getObjectMarshaller(clazz).getPrototype();
        Property[] arr$ = Introspector.getProperties(clazz);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Property property;
            Object result = PropertyUtil.strip(cfgmgr, object, property = arr$[i$]);
            property.set(object, result == STRIP_OUT ? property.get(prototype) : result);
        }
        return object;
    }

    protected static Object strip(ConfigManager cfgmgr, Object object, Property property) {
        Object value = property.get(object);
        if (PropertyUtil.isStrippable(property) || PropertyUtil.isStrippable(value)) {
            return STRIP_OUT;
        }
        if (value == null) {
            return null;
        }
        if (property.getType().equals(ConfigReference.class)) {
            Class<?> cclass = property.getArgumentType(ConfigReference.class);
            ConfigReference ref = (ConfigReference)value;
            ArgumentMap args = ref.getArguments();
            if (args.isEmpty()) {
                return ref;
            }
            Object config = cfgmgr.getConfig(cclass, ref.getName());
            if (!(config instanceof ParameterizedConfig)) {
                args.clear();
                return ref;
            }
            ParameterizedConfig pconfig = (ParameterizedConfig)config;
            Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                Parameter param = pconfig.getParameter(entry.getKey());
                if (param == null) {
                    it.remove();
                    continue;
                }
                Property prop = param.getArgumentProperty(pconfig);
                if (prop == null) {
                    it.remove();
                    continue;
                }
                Object result = PropertyUtil.strip(cfgmgr, args, prop);
                if (result == STRIP_OUT) {
                    it.remove();
                    continue;
                }
                entry.setValue(result);
            }
            return ref;
        }
        return PropertyUtil.strip(cfgmgr, value);
    }

    protected static boolean isStrippable(Property property) {
        Class<?> type = property.getType();
        return property.isAnnotationPresent(Strippable.class) || PropertyUtil.isStrippable(type) || PropertyUtil.isStrippable(property.getComponentType()) || ConfigReference.class.isAssignableFrom(type) && PropertyUtil.isStrippable(property.getArgumentType(ConfigReference.class));
    }

    protected static boolean isStrippable(Object object) {
        return object != null && PropertyUtil.isStrippable(object.getClass());
    }

    protected static boolean isStrippable(Class<?> clazz) {
        return clazz != null && (clazz.isAnnotationPresent(Strippable.class) || PropertyUtil.isStrippable(clazz.getComponentType()) || PropertyUtil.isStrippable(clazz.getSuperclass()));
    }

    protected static void getReferences(ConfigManager cfgmgr, Object object, Property property, Set<Tuple<Class<?>, String>> configs, Set<String> resources) {
        Object value = property.get(object);
        if (value == null) {
            return;
        }
        Editable annotation = property.getAnnotation();
        String editor = annotation.editor();
        if (editor.equals("resource")) {
            resources.add((String)value);
        } else if (editor.equals("config")) {
            ConfigGroup group = cfgmgr.getGroup(annotation.mode());
            if (group != null) {
                configs.add(new Tuple(group.getConfigClass(), (Object)((String)value)));
            }
        } else if (property.getType().equals(ConfigReference.class)) {
            Class<?> cclass = property.getArgumentType(ConfigReference.class);
            ConfigReference ref = (ConfigReference)value;
            configs.add(new Tuple(cclass, (Object)ref.getName()));
            ArgumentMap args = ref.getArguments();
            if (args.isEmpty()) {
                return;
            }
            Object config = cfgmgr.getConfig(cclass, ref.getName());
            if (!(config instanceof ParameterizedConfig)) {
                return;
            }
            ParameterizedConfig pconfig = (ParameterizedConfig)config;
            Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                Parameter param = pconfig.getParameter(entry.getKey());
                if (param == null) {
                    it.remove();
                    continue;
                }
                Property prop = param.getArgumentProperty(pconfig);
                if (prop == null) continue;
                PropertyUtil.getReferences(cfgmgr, args, prop, configs, resources);
            }
        } else {
            PropertyUtil.getReferences(cfgmgr, value, configs, resources);
        }
    }

    protected static void getResources(ConfigManager cfgmgr, Object object, Set<String> paths, ConfigReferenceSet refs) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            for (Object element : (Object[])object) {
                PropertyUtil.getResources(cfgmgr, element, paths, refs);
            }
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int nn = list.size();
            for (int ii = 0; ii < nn; ++ii) {
                PropertyUtil.getResources(cfgmgr, list.get(ii), paths, refs);
            }
            return;
        }
        for (Property property : Introspector.getProperties(object)) {
            Object value = property.get(object);
            if (value == null) continue;
            Editable annotation = property.getAnnotation();
            String editor = annotation.editor();
            boolean cfg = editor.equals("config");
            if (cfg || property.getType().equals(ConfigReference.class)) {
                Object config;
                ConfigReference ref;
                Class<Object> cclass;
                if (cfg) {
                    ConfigGroup group = cfgmgr.getGroup(annotation.mode());
                    if (group == null) continue;
                    Class mclass = group.getConfigClass();
                    cclass = mclass;
                    ref = new ConfigReference((String)value);
                } else {
                    Class<?> mclass = property.getArgumentType(ConfigReference.class);
                    ConfigReference mref = (ConfigReference)value;
                    cclass = mclass;
                    ref = mref;
                }
                if (!refs.add(cclass, ref)) continue;
                if (cfgmgr.isResourceClass(cclass)) {
                    paths.add(ref.getName());
                }
                if ((config = cfgmgr.getConfig(cclass, ref)) == null) continue;
                PropertyUtil.getResources(cfgmgr, config, paths, refs);
                continue;
            }
            if (editor.equals("resource")) {
                paths.add((String)value);
                continue;
            }
            PropertyUtil.getResources(cfgmgr, value, paths, refs);
        }
    }
}

