/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.media.image.Colorization;
import com.threerings.media.image.ImageUtil;
import com.threerings.opengl.Log;
import com.threerings.opengl.gui.Image;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.util.DDSLoader;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.ResourceCache;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;

public class ImageCache
extends ResourceCache {
    protected ResourceCache.Subcache<ImageKey, Image> _images = new ResourceCache.Subcache<ImageKey, Image>(){

        @Override
        protected Image loadResource(ImageKey key) {
            if (key.path.endsWith(".dds")) {
                Texture2D texture = new Texture2D(ImageCache.this._ctx.getRenderer());
                try {
                    DDSLoader.load(ImageCache.this._ctx.getResourceManager().getResourceFile(key.path), texture, false);
                    Image.configureTexture(texture);
                    return new Image(texture);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new Image(ImageCache.this._buffered.getResource(key));
        }

        @Override
        protected String getResourcePath(ImageKey key) {
            return key.path;
        }
    };
    protected ResourceCache.Subcache<ImageKey, BufferedImage> _buffered = new ResourceCache.Subcache<ImageKey, BufferedImage>(){

        @Override
        protected BufferedImage loadResource(ImageKey key) {
            if (key.zations.length > 0) {
                return ImageUtil.recolorImage((BufferedImage)ImageCache.this.getBufferedImage(key.path, new Colorization[0]), (Colorization[])key.zations);
            }
            BufferedImage image = null;
            try {
                image = ImageCache.this._ctx.getResourceManager().getImageResource(key.path);
                if (image == null) {
                    Log.log.warning((Object)"Unknown image format.", new Object[]{"path", key.path});
                }
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to read image.", new Object[]{"path", key.path, e});
            }
            return image == null ? ImageUtil.createErrorImage((int)64, (int)64) : image;
        }

        @Override
        protected String getResourcePath(ImageKey key) {
            return key.path;
        }
    };

    public ImageCache(GlContext ctx, boolean checkTimestamps) {
        super(ctx, checkTimestamps);
    }

    public Image getImage(String path, Colorization ... zations) {
        return this._images.getResource(new ImageKey(path, zations));
    }

    public BufferedImage getBufferedImage(String path, Colorization ... zations) {
        return this._buffered.getResource(new ImageKey(path, zations));
    }

    public void clear() {
        this._images.clear();
        this._buffered.clear();
    }

    protected static class ImageKey {
        public String path;
        public Colorization[] zations;

        public ImageKey(String path, Colorization[] zations) {
            this.path = path;
            this.zations = zations;
        }

        public int hashCode() {
            return this.path.hashCode() ^ Arrays.hashCode(this.zations);
        }

        public boolean equals(Object other) {
            ImageKey okey = (ImageKey)other;
            return this.path.equals(okey.path) && Arrays.equals(this.zations, okey.zations);
        }
    }
}

