/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.MaterialState;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;
import org.lwjgl.opengl.GLContext;

@EditorTypes(value={OneSided.class, TwoSided.class})
public abstract class MaterialStateConfig
extends DeepObject
implements Exportable {
    @Editable(weight=1.0, hgroup="cm")
    public ColorMaterialMode colorMaterialMode = ColorMaterialMode.AMBIENT_AND_DIFFUSE;
    @Editable(hgroup="m3", weight=2.0)
    public boolean localViewer;
    @Editable(hgroup="m3", weight=2.0)
    public boolean separateSpecular;
    @Editable(hgroup="m3", weight=2.0)
    public boolean flatShading;
    @Editable(weight=2.0)
    public boolean uniqueInstance;
    @DeepOmit
    protected transient SoftReference<MaterialState> _instance;

    public boolean isSupported(boolean fallback) {
        return !this.separateSpecular || GLContext.getCapabilities().OpenGL12 || fallback;
    }

    public MaterialState getState() {
        MaterialState instance;
        if (this.uniqueInstance) {
            return this.createInstance();
        }
        MaterialState materialState = instance = this._instance == null ? null : this._instance.get();
        if (instance == null) {
            instance = MaterialState.getInstance(this.createInstance());
            this._instance = new SoftReference<MaterialState>(instance);
        }
        return instance;
    }

    public void invalidate() {
        this._instance = null;
    }

    protected abstract MaterialState createInstance();

    public static class Side
    extends DeepObject
    implements Exportable {
        @Editable(mode="alpha")
        public Color4f ambient = new Color4f(Color4f.WHITE);
        @Editable(mode="alpha")
        public Color4f diffuse = new Color4f(Color4f.WHITE);
        @Editable(mode="alpha")
        public Color4f specular = new Color4f(Color4f.BLACK);
        @Editable(mode="alpha")
        public Color4f emission = new Color4f(Color4f.BLACK);
        @Editable(min=0.0, max=128.0, step=0.1)
        public float shininess;

        public void set(OneSided other) {
            this.ambient.set(other.ambient);
            this.diffuse.set(other.diffuse);
            this.specular.set(other.specular);
            this.emission.set(other.emission);
            this.shininess = other.shininess;
        }
    }

    public static class TwoSided
    extends MaterialStateConfig {
        @Editable(hgroup="s")
        public Side front = new Side();
        @Editable(hgroup="s")
        public Side back = new Side();
        @Editable(weight=1.0, hgroup="cm")
        public ColorMaterialFace colorMaterialFace = ColorMaterialFace.FRONT_AND_BACK;

        public TwoSided(OneSided other) {
            this.front.set(other);
            this.back.set(other);
        }

        public TwoSided() {
        }

        @Override
        protected MaterialState createInstance() {
            return new MaterialState(this.front.ambient, this.front.diffuse, this.front.specular, this.front.emission, this.front.shininess, this.back.ambient, this.back.diffuse, this.back.specular, this.back.emission, this.back.shininess, this.colorMaterialMode.getConstant(), this.colorMaterialFace.getConstant(), this.localViewer, this.separateSpecular && GLContext.getCapabilities().OpenGL12, this.flatShading);
        }
    }

    public static class OneSided
    extends MaterialStateConfig {
        @Editable(mode="alpha", hgroup="m1")
        public Color4f ambient = new Color4f(Color4f.WHITE);
        @Editable(mode="alpha", hgroup="m1")
        public Color4f specular = new Color4f(Color4f.BLACK);
        @Editable(mode="alpha", hgroup="m2")
        public Color4f diffuse = new Color4f(Color4f.WHITE);
        @Editable(mode="alpha", hgroup="m2")
        public Color4f emission = new Color4f(Color4f.BLACK);
        @Editable(min=0.0, max=128.0, step=0.1, hgroup="cm")
        public float shininess;

        public OneSided(TwoSided other) {
            this.ambient.set(other.front.ambient);
            this.diffuse.set(other.front.diffuse);
            this.specular.set(other.front.specular);
            this.emission.set(other.front.emission);
            this.shininess = other.front.shininess;
        }

        public OneSided() {
        }

        @Override
        protected MaterialState createInstance() {
            return new MaterialState(this.ambient, this.diffuse, this.specular, this.emission, this.shininess, this.colorMaterialMode.getConstant(), this.localViewer, this.separateSpecular && GLContext.getCapabilities().OpenGL12, this.flatShading);
        }
    }

    public static enum ColorMaterialFace {
        FRONT(1028),
        BACK(1029),
        FRONT_AND_BACK(1032);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private ColorMaterialFace(int constant) {
            this._constant = constant;
        }
    }

    public static enum ColorMaterialMode {
        DISABLED(-1),
        AMBIENT(4608),
        DIFFUSE(4609),
        AMBIENT_AND_DIFFUSE(5634),
        SPECULAR(4610),
        EMISSION(5632);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private ColorMaterialMode(int constant) {
            this._constant = constant;
        }
    }
}

