/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.MouseInputAdapter;

public class DraggableSpinner
extends JSpinner {
    protected boolean _suppressStateChanged;

    public DraggableSpinner(double value, double minimum, double maximum, double stepSize) {
        this((Number)value, Double.valueOf(minimum), Double.valueOf(maximum), (Number)stepSize);
    }

    public DraggableSpinner(float value, float minimum, float maximum, float stepSize) {
        this(Float.valueOf(value), Float.valueOf(minimum), Float.valueOf(maximum), Float.valueOf(stepSize));
    }

    public DraggableSpinner(int value, int minimum, int maximum, int stepSize) {
        this((Number)value, Integer.valueOf(minimum), Integer.valueOf(maximum), (Number)stepSize);
    }

    public DraggableSpinner(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
        this(new NumberModel(value, minimum, maximum, stepSize));
    }

    public DraggableSpinner(final SpinnerNumberModel model) {
        super(model);
        MouseInputAdapter adapter = new MouseInputAdapter(){
            protected int _lx;

            @Override
            public void mousePressed(MouseEvent event) {
                this._lx = event.getX();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent event) {
                this._lx = event.getX();
                Object ovalue = DraggableSpinner.this.getValue();
                DraggableSpinner.this._suppressStateChanged = true;
                try {
                    int dx;
                    int dir;
                    int n = dir = dx < 0 ? 1 : -1;
                    for (dx = event.getX() - this._lx; dx != 0; dx += dir) {
                        Object nvalue;
                        Object object = nvalue = dx < 0 ? DraggableSpinner.this.getPreviousValue() : DraggableSpinner.this.getNextValue();
                        if (nvalue == null) {
                            DraggableSpinner.this.setValue(dx < 0 ? model.getMinimum() : model.getMaximum());
                            break;
                        }
                        DraggableSpinner.this.setValue(nvalue);
                    }
                }
                finally {
                    DraggableSpinner.this._suppressStateChanged = false;
                }
                if (!DraggableSpinner.this.getValue().equals(ovalue)) {
                    DraggableSpinner.this.fireStateChanged();
                }
            }
        };
        int nn = this.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            Component child = this.getComponent(ii);
            if (!(child instanceof JButton)) continue;
            child.addMouseListener(adapter);
            child.addMouseMotionListener(adapter);
        }
        double step = model.getStepSize().doubleValue();
        int digits = (int)Math.round(-Math.log(step) / Math.log(10.0));
        ((JSpinner.NumberEditor)this.getEditor()).getFormat().setMinimumFractionDigits(Math.max(digits, 0));
        ((JSpinner.NumberEditor)this.getEditor()).getTextField().setValue(this.getValue());
        Dimension dim = this.getPreferredSize();
        this.setPreferredSize(new Dimension(65, dim.height));
    }

    public double getDoubleValue() {
        return ((Number)this.getValue()).doubleValue();
    }

    public float getFloatValue() {
        return ((Number)this.getValue()).floatValue();
    }

    public int getIntValue() {
        return ((Number)this.getValue()).intValue();
    }

    @Override
    protected void fireStateChanged() {
        if (!this._suppressStateChanged) {
            super.fireStateChanged();
        }
    }

    protected static class NumberModel
    extends SpinnerNumberModel {
        public NumberModel(Number value, Comparable minimum, Comparable maximum, Number stepSize) {
            super(value, minimum, maximum, stepSize);
            this.setValue(value);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Float && ((Float)value).floatValue() == 0.0f) {
                super.setValue(Float.valueOf(0.0f));
            } else if (value instanceof Double && (Double)value == 0.0) {
                super.setValue(0.0);
            } else {
                super.setValue(value);
            }
        }
    }
}

