/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.samskivert.util.IntTuple;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.tudey.config.PaintableConfig;
import com.threerings.tudey.config.TileConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.Direction;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;

public class GroundConfig
extends PaintableConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    protected static int createPattern(TudeySceneModel scene, ConfigReference<GroundConfig> ref, Original original, int x, int y, int elevation) {
        int pattern = 0;
        for (Direction dir : Direction.values()) {
            int dy;
            int dx = x + dir.getX();
            if (!original.isFloor(scene, ref, dx, dy = y + dir.getY(), elevation)) continue;
            pattern |= 1 << dir.ordinal();
        }
        return pattern;
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<GroundConfig> ground;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(GroundConfig.class, this.ground);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            GroundConfig config = cfgmgr.getConfig(GroundConfig.class, this.ground);
            return config == null ? null : config.getOriginal(cfgmgr);
        }
    }

    public static class TransitionCase
    extends EdgeCase {
        @Editable(nullable=true)
        public ConfigReference<GroundConfig> other;
        @Editable(hgroup="d")
        public boolean on;
        @Editable(hgroup="d")
        public boolean onw;
        @Editable(hgroup="d")
        public boolean ow;
        @Editable(hgroup="d")
        public boolean osw;
        @Editable(hgroup="d")
        public boolean os;
        @Editable(hgroup="d")
        public boolean ose;
        @Editable(hgroup="d")
        public boolean oe;
        @Editable(hgroup="d")
        public boolean one;
        @DeepOmit
        protected transient int[] _opatterns;

        @Override
        public int getRotations(TudeySceneModel scene, ConfigReference<GroundConfig> ref, Original original, int x, int y, int elevation) {
            Original ooriginal;
            int base = super.getRotations(scene, ref, original, x, y, elevation);
            GroundConfig oconfig = scene.getConfigManager().getConfig(GroundConfig.class, this.other);
            Original original2 = ooriginal = oconfig == null ? null : oconfig.getOriginal(scene.getConfigManager());
            if (ooriginal == null) {
                return base;
            }
            return base & this.getRotations(this.getOtherPatterns(), GroundConfig.createPattern(scene, this.other, ooriginal, x, y, elevation));
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this._opatterns = null;
        }

        protected int[] getOtherPatterns() {
            if (this._opatterns == null) {
                this._opatterns = new int[]{PaintableConfig.createPattern(this.on, this.onw, this.ow, this.osw, this.os, this.ose, this.oe, this.one), PaintableConfig.createPattern(this.oe, this.one, this.on, this.onw, this.ow, this.osw, this.os, this.ose), PaintableConfig.createPattern(this.os, this.ose, this.oe, this.one, this.on, this.onw, this.ow, this.osw), PaintableConfig.createPattern(this.ow, this.osw, this.os, this.ose, this.oe, this.one, this.on, this.onw)};
            }
            return this._opatterns;
        }
    }

    @EditorTypes(value={EdgeCase.class, TransitionCase.class})
    public static class EdgeCase
    extends PaintableConfig.Case {
        public int getRotations(TudeySceneModel scene, ConfigReference<GroundConfig> ref, Original original, int x, int y, int elevation) {
            return this.getRotations(GroundConfig.createPattern(scene, ref, original, x, y, elevation));
        }
    }

    public static class Original
    extends Implementation {
        @Editable(hgroup="p")
        public int priority;
        @Editable(hgroup="p")
        public boolean extendEdge;
        @Editable(nullable=true)
        public ConfigReference<GroundConfig> base;
        @Editable
        public PaintableConfig.Tile[] floor = new PaintableConfig.Tile[0];
        @Editable
        public EdgeCase[] edgeCases = new EdgeCase[0];

        public boolean isFloor(TudeySceneModel scene, ConfigReference<GroundConfig> ref, int x, int y, int elevation) {
            TudeySceneModel.Paint paint = scene.getPaint(x, y);
            if (paint != null && paint.type != TudeySceneModel.Paint.Type.WALL && paint.elevation == elevation) {
                Original original;
                if (paint.type == TudeySceneModel.Paint.Type.FLOOR && paint.paintable.equals(ref)) {
                    return true;
                }
                GroundConfig config = paint.getConfig(scene.getConfigManager(), GroundConfig.class);
                Original original2 = original = config == null ? null : config.getOriginal(scene.getConfigManager());
                if (original != null && ref.equals(original.base)) {
                    return true;
                }
            }
            return PaintableConfig.matchesAny(this.floor, scene.getTileEntry(x, y), elevation);
        }

        public TudeySceneModel.TileEntry createFloor(ConfigManager cfgmgr, int maxWidth, int maxHeight, int elevation) {
            return PaintableConfig.createRandomEntry(cfgmgr, this.floor, maxWidth, maxHeight, elevation);
        }

        public boolean isEdge(TudeySceneModel.TileEntry entry, int elevation) {
            for (EdgeCase caze : this.edgeCases) {
                if (!PaintableConfig.matchesAny(caze.tiles, entry, elevation)) continue;
                return true;
            }
            return false;
        }

        public boolean isEdge(TudeySceneModel.TileEntry entry, IntTuple caseRotations, int elevation) {
            return PaintableConfig.matchesAny(this.edgeCases, entry, caseRotations, elevation);
        }

        public IntTuple getEdgeCaseRotations(TudeySceneModel scene, ConfigReference<GroundConfig> ref, int x, int y, int elevation) {
            for (int ii = 0; ii < this.edgeCases.length; ++ii) {
                int rotations = this.edgeCases[ii].getRotations(scene, ref, this, x, y, elevation);
                if (rotations == 0) continue;
                return new IntTuple(ii, rotations);
            }
            return null;
        }

        public TudeySceneModel.TileEntry createEdge(ConfigManager cfgmgr, IntTuple caseRotations, int maxWidth, int maxHeight, int elevation) {
            return PaintableConfig.createRandomEntry(cfgmgr, this.edgeCases[caseRotations.left].tiles, caseRotations.right, maxWidth, maxHeight, elevation);
        }

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            for (PaintableConfig.Tile tile : this.floor) {
                refs.add(TileConfig.class, tile.tile);
            }
            for (DeepObject deepObject : this.edgeCases) {
                ((PaintableConfig.Case)deepObject).getUpdateReferences(refs);
            }
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public void invalidate() {
            for (PaintableConfig.Tile tile : this.floor) {
                tile.invalidate();
            }
            for (DeepObject deepObject : this.edgeCases) {
                ((PaintableConfig.Case)deepObject).invalidate();
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public void invalidate() {
        }
    }
}

