/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.probs;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.media.util.MathUtil;
import com.threerings.util.DeepObject;

@EditorTypes(value={Constant.class, Uniform.class, Normal.class, Sin.class, Exponential.class}, label="distribution")
public abstract class FloatVariable
extends DeepObject
implements Exportable {
    public abstract float getValue();

    public abstract float getMean();

    public static class Exponential
    extends FloatVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float mean;

        public Exponential(float mean) {
            this.mean = mean;
        }

        public Exponential(FloatVariable variable) {
            this.mean = variable.getMean();
        }

        public Exponential() {
        }

        @Override
        public float getValue() {
            return FloatMath.exponential(this.mean);
        }

        @Override
        public float getMean() {
            return this.mean;
        }
    }

    public static class Sin
    extends FloatVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity, hgroup="b")
        public float start;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity, hgroup="b")
        public float step;
        @Editable(min=0.0, max=180.0, scale=0.017453292519943295, hgroup="c")
        public float value;

        public Sin(float start, float step) {
            this.start = start;
            this.step = step;
        }

        public Sin(FloatVariable variable) {
            this.step = variable.getMean();
        }

        public Sin() {
        }

        @Override
        public float getValue() {
            return this.value * (float)MathUtil.sign((int)((int)(this.start += this.step)));
        }

        @Override
        public float getMean() {
            return this.start;
        }
    }

    public static class Normal
    extends FloatVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float mean;
        @Editable(min=0.0, max=1.7976931348623157E308, step=-Infinity, scale=-Infinity)
        public float stddev;

        public Normal(float mean, float stddev) {
            this.mean = mean;
            this.stddev = stddev;
        }

        public Normal(FloatVariable variable) {
            this.mean = variable.getMean();
        }

        public Normal() {
        }

        @Override
        public float getValue() {
            return FloatMath.normal(this.mean, this.stddev);
        }

        @Override
        public float getMean() {
            return this.mean;
        }
    }

    public static class Uniform
    extends FloatVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float minimum;
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float maximum;

        public Uniform(float minimum, float maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public Uniform(FloatVariable variable) {
            this.minimum = this.maximum = variable.getMean();
        }

        public Uniform() {
        }

        @Override
        public float getValue() {
            return FloatMath.random(this.minimum, this.maximum);
        }

        @Override
        public float getMean() {
            return (this.minimum + this.maximum) * 0.5f;
        }
    }

    public static class Constant
    extends FloatVariable {
        @Editable(min=-Infinity, max=-Infinity, step=-Infinity, scale=-Infinity)
        public float value;

        public Constant(float value) {
            this.value = value;
        }

        public Constant(FloatVariable variable) {
            this.value = variable.getMean();
        }

        public Constant() {
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public float getMean() {
            return this.value;
        }
    }
}

