/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.samskivert.util.StringUtil;
import com.threerings.expr.Bound;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.CompoundConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Compound
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected CompoundConfig _config;
    protected Model[] _models;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform = new Transform3D();
    protected SceneElement.TickPolicy _tickPolicy;
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    protected Box _nbounds = new Box();
    protected boolean _completed;

    public Compound(GlContext ctx, Scope parentScope, CompoundConfig config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, CompoundConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
    }

    @Override
    public List<Model> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this._models));
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void setVisible(boolean visible) {
        for (Model model : this._models) {
            model.setVisible(visible);
        }
    }

    @Override
    public void reset() {
        for (Model model : this._models) {
            model.reset();
        }
        this._completed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        this.tick(0.0f);
    }

    @Override
    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
        for (Model model : this._models) {
            model.drawBounds();
        }
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(prefix + "Compound: " + this._worldTransform + " " + this._bounds);
        String pprefix = prefix + "  ";
        for (Model model : this._models) {
            model.dumpInfo(pprefix);
        }
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void wasAdded() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        for (Model model : this._models) {
            model.wasAdded(scene);
        }
    }

    @Override
    public void willBeRemoved() {
        for (Model model : this._models) {
            model.willBeRemoved();
        }
    }

    @Override
    public void tick(float elapsed) {
        if (this._completed) {
            return;
        }
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._nbounds.setToEmpty();
        this._completed = true;
        for (Model model : this._models) {
            model.tick(elapsed);
            this._nbounds.addLocal(model.getBounds());
            this._completed &= model.hasCompleted();
        }
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed) {
            ((Model)this._parentScope).completed(this);
        }
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        Vector3f closest = result;
        for (Model model : this._models) {
            if (!model.getIntersection(ray, result)) continue;
            result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
        }
        return result != closest;
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        for (Model model : this._models) {
            model.composite();
        }
    }

    protected void updateFromConfig() {
        int ii;
        Scene scene = ((Model)this._parentScope).getScene(this);
        Model[] omodels = this._models;
        this._models = new Model[this._config.models.length];
        Function getNodeFn = ScopeUtil.resolve((Scope)this, "getNode", Function.NULL);
        for (ii = 0; ii < this._models.length; ++ii) {
            Model model;
            boolean create = omodels == null || omodels.length <= ii;
            this._models[ii] = model = create ? new Model(this._ctx) : omodels[ii];
            CompoundConfig.ComponentModel component = this._config.models[ii];
            Scope node = StringUtil.isBlank((String)component.node) ? null : (Scope)getNodeFn.call(component.node);
            model.setParentScope(node == null ? this : node);
            model.setConfig(component.model);
            model.getLocalTransform().set(component.transform);
            if (!create || scene == null) continue;
            model.wasAdded(scene);
        }
        if (omodels != null) {
            for (ii = this._models.length; ii < omodels.length; ++ii) {
                Model model = omodels[ii];
                if (scene != null) {
                    model.willBeRemoved();
                }
                model.dispose();
            }
        }
        this._influenceFlags = this._config.influences.getFlags();
        SceneElement.TickPolicy npolicy = this._config.tickPolicy;
        if (npolicy == SceneElement.TickPolicy.DEFAULT) {
            npolicy = SceneElement.TickPolicy.NEVER;
            for (Model model : this._models) {
                SceneElement.TickPolicy mpolicy = model.getTickPolicy();
                if (mpolicy.ordinal() <= npolicy.ordinal()) continue;
                npolicy = mpolicy;
            }
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
        this.updateBounds();
    }
}

