/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.geometry.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.threerings.export.Exportable;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.Matrix4f;
import com.threerings.math.Vector3f;
import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.geometry.config.DeformerConfig;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.geometry.config.PassSummary;
import com.threerings.opengl.geometry.config.TransformedGeometry;
import com.threerings.opengl.geometry.util.GeometryUtil;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.opengl.renderer.DisplayList;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.config.ClientArrayConfig;
import com.threerings.opengl.renderer.config.CoordSpace;
import com.threerings.opengl.renderer.state.ArrayState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlUtil;
import com.threerings.util.ArrayKey;
import com.threerings.util.CacheUtil;
import com.threerings.util.DeepObject;
import com.threerings.util.IdentityKey;
import com.threerings.util.Shallow;
import java.lang.ref.SoftReference;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GLContext;

public abstract class GeometryConfig
extends DeepObject
implements Exportable {
    protected static Map<ArrayKey, GeometryConfig> _generated = CacheUtil.softValues();

    public static GeometryConfig getQuad(int divisionsX, int divisionsY) {
        ArrayKey key = new ArrayKey("quad", divisionsX, divisionsY);
        GeometryConfig quad = _generated.get(key);
        if (quad == null) {
            quad = GeometryConfig.createQuad(2.0f, 2.0f, divisionsX, divisionsY);
            _generated.put(key, quad);
        }
        return quad;
    }

    public static GeometryConfig createQuad(float sizeX, float sizeY, int divisionsX, int divisionsY) {
        int vx = divisionsX + 1;
        int vy = divisionsY + 1;
        FloatBuffer floatArray = BufferUtils.createFloatBuffer((int)(vx * vy * 8));
        for (int ii = 0; ii <= divisionsY; ++ii) {
            float t = (float)ii / (float)divisionsY;
            float y = sizeY * (t - 0.5f);
            for (int jj = 0; jj <= divisionsX; ++jj) {
                float s = (float)jj / (float)divisionsX;
                float x = sizeX * (s - 0.5f);
                floatArray.put(s).put(t);
                floatArray.put(0.0f).put(0.0f).put(1.0f);
                floatArray.put(x).put(y).put(0.0f);
            }
        }
        floatArray.rewind();
        ShortBuffer indices = BufferUtils.createShortBuffer((int)(divisionsX * divisionsY * 2 * 3));
        for (int ii = 0; ii < divisionsY; ++ii) {
            for (int jj = 0; jj < divisionsX; ++jj) {
                short ll = (short)(ii * vx + jj);
                short ul = (short)(ll + vx);
                short ur = (short)(ul + 1);
                short lr = (short)(ll + 1);
                indices.put(ul).put(ll).put(ur);
                indices.put(ur).put(ll).put(lr);
            }
        }
        indices.rewind();
        ClientArrayConfig texCoordArray = new ClientArrayConfig(2, 32, 0, floatArray);
        ClientArrayConfig normalArray = new ClientArrayConfig(3, 32, 8, floatArray);
        ClientArrayConfig vertexArray = new ClientArrayConfig(3, 32, 20, floatArray);
        float hx = sizeX * 0.5f;
        float hy = sizeY * 0.5f;
        return new IndexedStored(new Box(new Vector3f(-hx, -hy, 0.0f), new Vector3f(hx, hy, 0.0f)), Mode.TRIANGLES, new AttributeArrayConfig[0], new ClientArrayConfig[]{texCoordArray}, null, normalArray, vertexArray, 0, indices.capacity() - 1, indices);
    }

    public abstract Box getBounds();

    public GeometryConfig merge(List<TransformedGeometry> glist) {
        return null;
    }

    public abstract Geometry createGeometry(GlContext var1, Scope var2, DeformerConfig var3, PassDescriptor[] var4);

    public static class AttributeArrayConfig
    extends ClientArrayConfig {
        public String name;

        public AttributeArrayConfig(int size, String name) {
            super(size);
            this.name = name;
        }

        public AttributeArrayConfig(int size, int stride, int offset, FloatBuffer floatArray, String name) {
            super(size, stride, offset, floatArray);
            this.name = name;
        }

        public AttributeArrayConfig() {
        }

        @Override
        public boolean canMerge(ClientArrayConfig oarray) {
            return super.canMerge(oarray) && oarray instanceof AttributeArrayConfig && ((AttributeArrayConfig)oarray).name.equals(this.name);
        }
    }

    public static class SkinnedIndexedStored
    extends IndexedStored {
        public String[] bones;

        public SkinnedIndexedStored(Box bounds, Mode mode, AttributeArrayConfig[] vertexAttribArrays, ClientArrayConfig[] texCoordArrays, ClientArrayConfig colorArray, ClientArrayConfig normalArray, ClientArrayConfig vertexArray, int start, int end, ShortBuffer indices, String[] bones) {
            super(bounds, mode, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray, start, end, indices);
            this.bones = bones;
        }

        public SkinnedIndexedStored() {
        }

        @Override
        public Matrix4f[] getBoneMatrices(Scope scope) {
            Function getBoneMatrix = ScopeUtil.resolve(scope, "getBoneMatrix", Function.NULL);
            Matrix4f[] matrices = new Matrix4f[this.bones.length];
            for (int ii = 0; ii < this.bones.length; ++ii) {
                Matrix4f matrix = (Matrix4f)getBoneMatrix.call(this.bones[ii]);
                matrices[ii] = matrix == null ? new Matrix4f() : matrix;
            }
            return matrices;
        }
    }

    public static class IndexedStored
    extends Stored {
        public int start;
        public int end;
        @Shallow
        public ShortBuffer indices;
        protected transient SoftReference<BufferObject> _elementArrayBuffer;

        public IndexedStored(Box bounds, Mode mode, AttributeArrayConfig[] vertexAttribArrays, ClientArrayConfig[] texCoordArrays, ClientArrayConfig colorArray, ClientArrayConfig normalArray, ClientArrayConfig vertexArray, int start, int end, ShortBuffer indices) {
            super(bounds, mode, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray);
            this.start = start;
            this.end = end;
            this.indices = indices;
        }

        public IndexedStored() {
        }

        @Override
        public SimpleBatch.DrawCommand createDrawCommand(boolean ibo) {
            return ibo ? SimpleBatch.createDrawBufferElements(this.mode.getConstant(), this.start, this.end, this.indices.capacity(), 5123, 0L) : SimpleBatch.createDrawShortElements(this.mode.getConstant(), this.start, this.end, this.indices);
        }

        @Override
        protected int getFirst() {
            return this.start;
        }

        @Override
        protected int getCount() {
            return this.end - this.start + 1;
        }

        @Override
        protected Stored createMerged(List<TransformedGeometry> glist) {
            IndexedStored merged = new IndexedStored();
            int vcount = 0;
            int icount = 0;
            int nn = glist.size();
            for (int ii = 0; ii < nn; ++ii) {
                IndexedStored indexed = (IndexedStored)glist.get((int)ii).geometry;
                vcount += indexed.getCount();
                icount += indexed.indices.remaining();
            }
            merged.end = vcount - 1;
            ShortBuffer mindices = merged.indices = BufferUtils.createShortBuffer((int)icount);
            int offset = 0;
            for (int ii = glist.size() - 1; ii >= 0; --ii) {
                IndexedStored indexed = (IndexedStored)glist.get((int)ii).geometry;
                ShortBuffer sindices = indexed.indices;
                int delta = offset - indexed.start;
                int jjmax = sindices.limit();
                for (int jj = sindices.position(); jj < jjmax; ++jj) {
                    mindices.put((short)(sindices.get(jj) + delta));
                }
                offset += indexed.getCount();
            }
            merged.indices.rewind();
            return merged;
        }

        @Override
        protected BufferObject getElementArrayBuffer(GlContext ctx) {
            BufferObject buffer;
            BufferObject bufferObject = buffer = this._elementArrayBuffer == null ? null : this._elementArrayBuffer.get();
            if (buffer == null) {
                buffer = new BufferObject(ctx.getRenderer());
                this._elementArrayBuffer = new SoftReference<BufferObject>(buffer);
                buffer.setData(this.indices);
            }
            return buffer;
        }
    }

    public static class ArrayStored
    extends Stored {
        public int first;
        public int count;

        public ArrayStored(Box bounds, Mode mode, AttributeArrayConfig[] vertexAttribArrays, ClientArrayConfig[] texCoordArrays, ClientArrayConfig colorArray, ClientArrayConfig normalArray, ClientArrayConfig vertexArray, int first, int count) {
            super(bounds, mode, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray);
            this.first = first;
            this.count = count;
        }

        public ArrayStored() {
        }

        @Override
        public SimpleBatch.DrawCommand createDrawCommand(boolean ibo) {
            return new SimpleBatch.DrawArrays(this.mode.getConstant(), this.first, this.count);
        }

        @Override
        protected int getFirst() {
            return this.first;
        }

        @Override
        protected int getCount() {
            return this.count;
        }

        @Override
        protected Stored createMerged(List<TransformedGeometry> glist) {
            ArrayStored merged = new ArrayStored();
            int nn = glist.size();
            for (int ii = 0; ii < nn; ++ii) {
                merged.count += ((ArrayStored)glist.get((int)ii).geometry).count;
            }
            return merged;
        }
    }

    public static abstract class Stored
    extends GeometryConfig {
        public Box bounds;
        public Mode mode;
        public AttributeArrayConfig[] vertexAttribArrays;
        public ClientArrayConfig[] texCoordArrays;
        public ClientArrayConfig colorArray;
        public ClientArrayConfig normalArray;
        public ClientArrayConfig vertexArray;
        protected transient Map<PassSummary, BufferObject> _arrayBuffers;
        protected transient Map<PassDescriptor, SimpleBatch.DrawCommand> _listCommands;
        protected transient Map<IdentityKey, float[]> _floatArrays;
        protected transient Map<IdentityKey, int[]> _intArrays;

        public Stored(Box bounds, Mode mode, AttributeArrayConfig[] vertexAttribArrays, ClientArrayConfig[] texCoordArrays, ClientArrayConfig colorArray, ClientArrayConfig normalArray, ClientArrayConfig vertexArray) {
            this.bounds = bounds;
            this.mode = mode;
            this.vertexAttribArrays = vertexAttribArrays;
            this.texCoordArrays = texCoordArrays;
            this.colorArray = colorArray;
            this.normalArray = normalArray;
            this.vertexArray = vertexArray;
        }

        public Stored() {
        }

        public int getVertexCount() {
            return this.vertexArray.floatArray.capacity() * 4 / this.vertexArray.stride;
        }

        public AttributeArrayConfig getVertexAttribArray(String name) {
            if (this.vertexAttribArrays != null) {
                for (AttributeArrayConfig array : this.vertexAttribArrays) {
                    if (!array.name.equals(name)) continue;
                    return array;
                }
            }
            return null;
        }

        public ClientArrayConfig getTexCoordArray(int idx) {
            return this.texCoordArrays != null && this.texCoordArrays.length > idx ? this.texCoordArrays[idx] : null;
        }

        public float[] getFloatArray(boolean align, ClientArrayConfig ... arrays) {
            IdentityKey key;
            float[] array;
            if (this._floatArrays == null) {
                this._floatArrays = CacheUtil.softValues(1);
            }
            if ((array = this._floatArrays.get(key = new IdentityKey((Object)align, (Object[])arrays))) == null) {
                int offset = 0;
                int[] offsets = new int[arrays.length];
                for (int ii = 0; ii < arrays.length; ++ii) {
                    offsets[ii] = offset;
                    offset += arrays[ii].size;
                }
                int stride = align ? GlUtil.nextPowerOfTwo(offset) : offset;
                array = new float[stride * this.getVertexCount()];
                this._floatArrays.put(key, array);
                for (int ii = 0; ii < arrays.length; ++ii) {
                    arrays[ii].populateFloatArray(array, offsets[ii], stride);
                }
            }
            return array;
        }

        public int[] getIntArray(boolean align, ClientArrayConfig ... arrays) {
            IdentityKey key;
            int[] array;
            if (this._intArrays == null) {
                this._intArrays = CacheUtil.softValues(1);
            }
            if ((array = this._intArrays.get(key = new IdentityKey((Object)align, (Object[])arrays))) == null) {
                int offset = 0;
                int[] offsets = new int[arrays.length];
                for (int ii = 0; ii < arrays.length; ++ii) {
                    offsets[ii] = offset;
                    offset += arrays[ii].size;
                }
                int stride = align ? GlUtil.nextPowerOfTwo(offset) : offset;
                array = new int[stride * this.getVertexCount()];
                this._intArrays.put(key, array);
                for (int ii = 0; ii < arrays.length; ++ii) {
                    arrays[ii].populateIntArray(array, offsets[ii], stride);
                }
            }
            return array;
        }

        public Geometry createStaticGeometry(GlContext ctx, Scope scope, PassDescriptor[] passes) {
            final Matrix4f[] boneMatrices = this.getBoneMatrices(scope);
            final CoordSpace[] coordSpaces = this.getCoordSpaces(passes);
            final Vector3f center = this.bounds.getCenter();
            if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
                final ArrayState[] arrayStates = this.createArrayStates(ctx, passes, true, true);
                final SimpleBatch.DrawCommand drawCommand = this.createDrawCommand(true);
                return new Geometry(){

                    @Override
                    public Matrix4f[] getBoneMatrices() {
                        return boneMatrices;
                    }

                    @Override
                    public CoordSpace getCoordSpace(int pass) {
                        return coordSpaces[pass];
                    }

                    @Override
                    public Vector3f getCenter() {
                        return center;
                    }

                    @Override
                    public ArrayState getArrayState(int pass) {
                        return arrayStates[pass];
                    }

                    @Override
                    public SimpleBatch.DrawCommand getDrawCommand(int pass) {
                        return drawCommand;
                    }
                };
            }
            final SimpleBatch.DrawCommand[] drawCommands = this.getListCommands(ctx, passes);
            return new Geometry(){

                @Override
                public Matrix4f[] getBoneMatrices() {
                    return boneMatrices;
                }

                @Override
                public CoordSpace getCoordSpace(int pass) {
                    return coordSpaces[pass];
                }

                @Override
                public Vector3f getCenter() {
                    return center;
                }

                @Override
                public ArrayState getArrayState(int pass) {
                    return ArrayState.DISABLED;
                }

                @Override
                public SimpleBatch.DrawCommand getDrawCommand(int pass) {
                    return drawCommands[pass];
                }
            };
        }

        public Matrix4f[] getBoneMatrices(Scope scope) {
            return null;
        }

        public ArrayState[] createArrayStates(GlContext ctx, PassDescriptor[] passes, boolean staticVBO, boolean staticIBO) {
            return this.createArrayStates(ctx, passes, new PassSummary(passes), staticVBO, staticIBO, null, null);
        }

        public ArrayState[] createArrayStates(GlContext ctx, PassDescriptor[] passes, PassSummary summary, boolean staticVBO, boolean staticIBO, BufferObject arrayBuffer, FloatBuffer floatArray) {
            HashMap vertexAttribArrays = Maps.newHashMap();
            for (String attrib : summary.vertexAttribs) {
                AttributeArrayConfig vertexAttribArray = this.getVertexAttribArray(attrib);
                if (vertexAttribArray == null) continue;
                vertexAttribArrays.put(attrib, vertexAttribArray.createClientArray());
            }
            HashIntMap texCoordArrays = new HashIntMap();
            Iterator i$ = summary.texCoordSets.iterator();
            while (i$.hasNext()) {
                int set = (Integer)i$.next();
                ClientArrayConfig texCoordArray = this.getTexCoordArray(set);
                if (texCoordArray == null) continue;
                texCoordArrays.put(set, (Object)texCoordArray.createClientArray());
            }
            ClientArray colorArray = summary.colors && this.colorArray != null ? this.colorArray.createClientArray() : null;
            ClientArray normalArray = summary.normals && this.normalArray != null ? this.normalArray.createClientArray() : null;
            ClientArray vertexArray = this.vertexArray.createClientArray();
            ArrayList<ClientArray> arrays = GeometryUtil.createList(vertexAttribArrays, (HashIntMap<ClientArray>)texCoordArrays, colorArray, normalArray, vertexArray);
            GeometryUtil.updateOffsetsAndStride(arrays);
            if (arrayBuffer != null || floatArray != null) {
                for (ClientArray array : arrays) {
                    array.arrayBuffer = arrayBuffer;
                    array.floatArray = floatArray;
                }
            } else if (staticVBO) {
                if (this._arrayBuffers == null) {
                    this._arrayBuffers = CacheUtil.softValues(1);
                }
                if ((arrayBuffer = this._arrayBuffers.get(summary)) == null) {
                    arrayBuffer = new BufferObject(ctx.getRenderer());
                    this._arrayBuffers.put(summary, arrayBuffer);
                    floatArray = this.populateClientArrays(vertexAttribArrays, (HashIntMap<ClientArray>)texCoordArrays, colorArray, normalArray, vertexArray);
                    arrayBuffer.setData(floatArray);
                }
                for (ClientArray array : arrays) {
                    array.arrayBuffer = arrayBuffer;
                    array.floatArray = null;
                }
            } else {
                this.populateClientArrays(vertexAttribArrays, (HashIntMap<ClientArray>)texCoordArrays, colorArray, normalArray, vertexArray);
            }
            return GeometryUtil.createArrayStates(vertexAttribArrays, (HashIntMap<ClientArray>)texCoordArrays, colorArray, normalArray, vertexArray, staticIBO ? this.getElementArrayBuffer(ctx) : null, passes);
        }

        public abstract SimpleBatch.DrawCommand createDrawCommand(boolean var1);

        @Override
        public Box getBounds() {
            return this.bounds;
        }

        @Override
        public Geometry createGeometry(GlContext ctx, Scope scope, DeformerConfig deformer, PassDescriptor[] passes) {
            if (passes.length == 0) {
                return Geometry.EMPTY;
            }
            return deformer == null ? this.createStaticGeometry(ctx, scope, passes) : deformer.createGeometry(ctx, scope, this, passes);
        }

        @Override
        public GeometryConfig merge(List<TransformedGeometry> glist) {
            int ii;
            ArrayList merge = Lists.newArrayList();
            Class<?> clazz = this.getClass();
            int vcount = 0;
            for (int ii2 = glist.size() - 1; ii2 >= 0; --ii2) {
                Stored stored;
                TransformedGeometry tgeom = glist.get(ii2);
                if (tgeom.geometry.getClass() != clazz || !this.canMerge(stored = (Stored)tgeom.geometry)) continue;
                glist.remove(ii2);
                merge.add(tgeom);
                vcount += stored.getCount();
            }
            if (merge.isEmpty()) {
                return null;
            }
            Stored merged = this.createMerged(merge);
            merged.bounds = new Box();
            merged.mode = this.mode;
            int stride = this.vertexArray.stride / 4;
            FloatBuffer vbuf = BufferUtils.createFloatBuffer((int)(stride * vcount));
            if (this.vertexAttribArrays != null) {
                merged.vertexAttribArrays = new AttributeArrayConfig[this.vertexAttribArrays.length];
                for (ii = 0; ii < this.vertexAttribArrays.length; ++ii) {
                    AttributeArrayConfig attrArray = this.vertexAttribArrays[ii];
                    merged.vertexAttribArrays[ii] = new AttributeArrayConfig(attrArray.size, attrArray.stride, attrArray.offset, vbuf, attrArray.name);
                }
            }
            if (this.texCoordArrays != null) {
                merged.texCoordArrays = new ClientArrayConfig[this.texCoordArrays.length];
                for (ii = 0; ii < this.texCoordArrays.length; ++ii) {
                    ClientArrayConfig texCoordArray = this.texCoordArrays[ii];
                    merged.texCoordArrays[ii] = new ClientArrayConfig(texCoordArray.size, texCoordArray.stride, texCoordArray.offset, vbuf);
                }
            }
            if (this.colorArray != null) {
                merged.colorArray = new ClientArrayConfig(this.colorArray.size, this.colorArray.stride, this.colorArray.offset, vbuf);
            }
            if (this.normalArray != null) {
                merged.normalArray = new ClientArrayConfig(this.normalArray.size, this.normalArray.stride, this.normalArray.offset, vbuf);
            }
            merged.vertexArray = new ClientArrayConfig(this.vertexArray.size, this.vertexArray.stride, this.vertexArray.offset, vbuf);
            int vpos = 0;
            for (int ii3 = merge.size() - 1; ii3 >= 0; --ii3) {
                TransformedGeometry tgeom = (TransformedGeometry)merge.get(ii3);
                Stored stored = (Stored)tgeom.geometry;
                merged.bounds.addLocal(stored.bounds.transform(tgeom.transform));
                FloatBuffer obuf = stored.vertexArray.floatArray;
                int olimit = obuf.limit();
                int opos = obuf.position();
                int npos = opos + stored.getFirst() * stride;
                int count = stored.getCount();
                obuf.limit(npos + count * stride).position(npos);
                vbuf.put(stored.vertexArray.floatArray);
                obuf.limit(olimit).position(opos);
                tgeom.transform.update(3);
                Matrix4f mat = tgeom.transform.getMatrix();
                int voff = this.vertexArray.offset / 4;
                if (this.normalArray == null) {
                    for (int jj = 0; jj < count; ++jj) {
                        int pos = vpos + voff;
                        float vx = vbuf.get(pos);
                        float vy = vbuf.get(pos + 1);
                        float vz = vbuf.get(pos + 2);
                        vbuf.put(pos, mat.m00 * vx + mat.m10 * vy + mat.m20 * vz + mat.m30);
                        vbuf.put(pos + 1, mat.m01 * vx + mat.m11 * vy + mat.m21 * vz + mat.m31);
                        vbuf.put(pos + 2, mat.m02 * vx + mat.m12 * vy + mat.m22 * vz + mat.m32);
                        vpos += stride;
                    }
                    continue;
                }
                int noff = this.normalArray.offset / 4;
                for (int jj = 0; jj < count; ++jj) {
                    int pos = vpos + voff;
                    float vx = vbuf.get(pos);
                    float vy = vbuf.get(pos + 1);
                    float vz = vbuf.get(pos + 2);
                    vbuf.put(pos, mat.m00 * vx + mat.m10 * vy + mat.m20 * vz + mat.m30);
                    vbuf.put(pos + 1, mat.m01 * vx + mat.m11 * vy + mat.m21 * vz + mat.m31);
                    vbuf.put(pos + 2, mat.m02 * vx + mat.m12 * vy + mat.m22 * vz + mat.m32);
                    pos = vpos + noff;
                    float nx = vbuf.get(pos);
                    float ny = vbuf.get(pos + 1);
                    float nz = vbuf.get(pos + 2);
                    vbuf.put(pos, mat.m00 * nx + mat.m10 * ny + mat.m20 * nz);
                    vbuf.put(pos + 1, mat.m01 * nx + mat.m11 * ny + mat.m21 * nz);
                    vbuf.put(pos + 2, mat.m02 * nx + mat.m12 * ny + mat.m22 * nz);
                    vpos += stride;
                }
            }
            vbuf.rewind();
            return merged;
        }

        protected boolean canMerge(Stored ostored) {
            return this.mode == ostored.mode && this.vertexArray.canMerge(ostored.vertexArray) && this.canMerge(this.normalArray, ostored.normalArray) && this.canMerge(this.colorArray, ostored.colorArray) && this.canMerge(this.texCoordArrays, ostored.texCoordArrays) && this.canMerge(this.vertexAttribArrays, ostored.vertexAttribArrays);
        }

        protected boolean canMerge(ClientArrayConfig[] a1, ClientArrayConfig[] a2) {
            if (a1 == null || a1.length == 0) {
                return a2 == null || a2.length == 0;
            }
            if (a2 == null || a2.length != a1.length) {
                return false;
            }
            for (int ii = 0; ii < a1.length; ++ii) {
                if (this.canMerge(a1[ii], a2[ii])) continue;
                return false;
            }
            return true;
        }

        protected boolean canMerge(ClientArrayConfig a1, ClientArrayConfig a2) {
            return a1 == null ? a2 == null : a2 != null && a1.canMerge(a2);
        }

        protected abstract int getFirst();

        protected abstract int getCount();

        protected abstract Stored createMerged(List<TransformedGeometry> var1);

        protected CoordSpace[] getCoordSpaces(PassDescriptor[] passes) {
            CoordSpace[] spaces = new CoordSpace[passes.length];
            for (int ii = 0; ii < spaces.length; ++ii) {
                spaces[ii] = passes[ii].coordSpace;
            }
            return spaces;
        }

        protected FloatBuffer populateClientArrays(HashMap<String, ClientArray> vertexAttribArrays, HashIntMap<ClientArray> texCoordArrays, ClientArray colorArray, ClientArray normalArray, ClientArray vertexArray) {
            ClientArray clientArray;
            FloatBuffer floatArray = BufferUtils.createFloatBuffer((int)(this.getVertexCount() * vertexArray.stride / 4));
            for (Map.Entry<String, ClientArray> entry : vertexAttribArrays.entrySet()) {
                clientArray = entry.getValue();
                clientArray.floatArray = floatArray;
                this.getVertexAttribArray(entry.getKey()).populateClientArray(clientArray);
            }
            for (Map.Entry<String, ClientArray> entry : texCoordArrays.entrySet()) {
                clientArray = entry.getValue();
                clientArray.floatArray = floatArray;
                this.getTexCoordArray((Integer)((Object)entry.getKey())).populateClientArray(clientArray);
            }
            if (colorArray != null) {
                colorArray.floatArray = floatArray;
                this.colorArray.populateClientArray(colorArray);
            }
            if (normalArray != null) {
                normalArray.floatArray = floatArray;
                this.normalArray.populateClientArray(normalArray);
            }
            vertexArray.floatArray = floatArray;
            this.vertexArray.populateClientArray(vertexArray);
            return floatArray;
        }

        protected BufferObject getElementArrayBuffer(GlContext ctx) {
            return null;
        }

        protected SimpleBatch.DrawCommand[] getListCommands(GlContext ctx, PassDescriptor[] passes) {
            if (this._listCommands == null) {
                this._listCommands = CacheUtil.softValues(1);
            }
            SimpleBatch.DrawCommand[] commands = new SimpleBatch.DrawCommand[passes.length];
            for (int ii = 0; ii < passes.length; ++ii) {
                PassDescriptor pass = passes[ii];
                SimpleBatch.DrawCommand command = this._listCommands.get(pass);
                if (command == null) {
                    command = this.createListCommand(ctx, pass);
                    this._listCommands.put(pass, command);
                }
                commands[ii] = command;
            }
            return commands;
        }

        protected SimpleBatch.DrawCommand createListCommand(GlContext ctx, PassDescriptor pass) {
            Renderer renderer = ctx.getRenderer();
            DisplayList list = new DisplayList(renderer);
            ArrayState state = this.createArrayState(pass);
            SimpleBatch.DrawCommand command = this.createDrawCommand(false);
            state.apply(renderer);
            list.begin();
            command.call();
            list.end();
            return new SimpleBatch.CallList(list, state.getColorArray() != null, command.getPrimitiveCount());
        }

        protected ArrayState createArrayState(PassDescriptor pass) {
            ClientArray[] vertexAttribArrays = new ClientArray[pass.vertexAttribs.length];
            for (int ii = 0; ii < vertexAttribArrays.length; ++ii) {
                AttributeArrayConfig vertexAttribArray = this.getVertexAttribArray(pass.vertexAttribs[ii]);
                vertexAttribArrays[ii] = vertexAttribArray == null ? null : vertexAttribArray.createClientArray();
            }
            ClientArray[] texCoordArrays = new ClientArray[pass.texCoordSets.length];
            for (int ii = 0; ii < texCoordArrays.length; ++ii) {
                ClientArrayConfig texCoordArray = this.getTexCoordArray(pass.texCoordSets[ii]);
                texCoordArrays[ii] = texCoordArray == null ? null : texCoordArray.createClientArray();
            }
            ClientArray colorArray = pass.colors && this.colorArray != null ? this.colorArray.createClientArray() : null;
            ClientArray normalArray = pass.normals && this.normalArray != null ? this.normalArray.createClientArray() : null;
            ClientArray vertexArray = this.vertexArray.createClientArray();
            return new ArrayState(pass.firstVertexAttribIndex, vertexAttribArrays, texCoordArrays, colorArray, normalArray, vertexArray, null);
        }
    }

    public static enum Mode {
        POINTS(0),
        LINES(1),
        LINE_STRIP(3),
        LINE_LOOP(2),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6),
        QUADS(7),
        QUAD_STRIP(8),
        POLYGON(9);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private Mode(int constant) {
            this._constant = constant;
        }
    }
}

