/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor.config;

import com.google.common.base.Objects;
import com.threerings.config.BoundConfig;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.Reference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.compositor.config.RenderSchemeConfig;
import com.threerings.opengl.compositor.config.TargetConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;

public class RenderEffectConfig
extends BoundConfig {
    @Editable
    public Implementation implementation = new Original();

    public int getPriority(GlContext ctx) {
        return this.implementation.getPriority(ctx);
    }

    public Technique getTechnique(GlContext ctx, String scheme) {
        return this.implementation.getTechnique(ctx, scheme);
    }

    @Override
    public void wasUpdated() {
        this.implementation.invalidate();
        super.wasUpdated();
    }

    public static class Technique
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        @Reference(value=RenderSchemeConfig.class)
        public String scheme;
        @Editable
        public TargetConfig[] targets = new TargetConfig[0];
        @Editable
        public TargetConfig.Output output = new TargetConfig.Output();
        @DeepOmit
        protected transient RenderSchemeConfig _schemeConfig = RenderSchemeConfig.INVALID;

        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public Technique process(GlContext ctx, boolean fallback) {
            return this.isSupported(ctx, fallback) ? this : null;
        }

        public boolean isSupported(GlContext ctx, boolean fallback) {
            for (TargetConfig target : this.targets) {
                if (target.isSupported(ctx, fallback)) continue;
                return false;
            }
            return this.output.isSupported(ctx, fallback);
        }

        public RenderSchemeConfig getSchemeConfig(GlContext ctx) {
            if (this._schemeConfig == RenderSchemeConfig.INVALID) {
                return this.scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, this.scheme);
            }
            return this._schemeConfig;
        }

        public void invalidate() {
            this._schemeConfig = RenderSchemeConfig.INVALID;
        }
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<RenderEffectConfig> renderEffect;

        @Override
        public int getPriority(GlContext ctx) {
            RenderEffectConfig config = ctx.getConfigManager().getConfig(RenderEffectConfig.class, this.renderEffect);
            return config == null ? 0 : config.getPriority(ctx);
        }

        @Override
        public Technique getTechnique(GlContext ctx, String scheme) {
            RenderEffectConfig config = ctx.getConfigManager().getConfig(RenderEffectConfig.class, this.renderEffect);
            return config == null ? null : config.getTechnique(ctx, scheme);
        }
    }

    public static class Original
    extends Implementation {
        @Editable
        public int priority;
        @Editable
        public Technique[] techniques = new Technique[0];
        @DeepOmit
        protected transient Technique[] _processedTechniques;

        @Override
        public int getPriority(GlContext ctx) {
            return this.priority;
        }

        @Override
        public Technique getTechnique(GlContext ctx, String scheme) {
            Technique[] processed;
            for (Technique technique : processed = this.getProcessedTechniques(ctx)) {
                if (!Objects.equal((Object)technique.scheme, (Object)scheme)) continue;
                return technique;
            }
            RenderSchemeConfig sconfig = scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, scheme);
            for (Technique technique : processed) {
                RenderSchemeConfig tconfig = technique.getSchemeConfig(ctx);
                if (!(sconfig == null ? tconfig == null || tconfig.isCompatibleWith(sconfig) : sconfig.isCompatibleWith(tconfig))) continue;
                return technique;
            }
            return null;
        }

        @Override
        public void invalidate() {
            this._processedTechniques = null;
            for (Technique technique : this.techniques) {
                technique.invalidate();
            }
        }

        protected Technique[] getProcessedTechniques(GlContext ctx) {
            if (this._processedTechniques == null) {
                ArrayList<Technique> list = new ArrayList<Technique>(this.techniques.length);
                ArrayList<Technique> fallbacks = new ArrayList<Technique>(0);
                for (Technique technique : this.techniques) {
                    Technique processed = technique.process(ctx, false);
                    if (processed == null) {
                        Technique fallback = technique.process(ctx, true);
                        if (fallback == null) continue;
                        fallbacks.add(fallback);
                        continue;
                    }
                    list.add(processed);
                }
                list.addAll(fallbacks);
                this._processedTechniques = list.toArray(new Technique[list.size()]);
            }
            return this._processedTechniques;
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract int getPriority(GlContext var1);

        public abstract Technique getTechnique(GlContext var1, String var2);

        public void invalidate() {
        }
    }
}

