/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.collect.Lists;
import com.samskivert.util.CollectionUtil;
import com.samskivert.util.QuickSort;
import com.samskivert.util.RandomUtil;
import com.threerings.math.Vector2f;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.TargetConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.AgentLogic;
import com.threerings.tudey.server.logic.ConditionLogic;
import com.threerings.tudey.server.logic.EntryLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.server.logic.RegionLogic;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.space.SpaceElement;
import com.threerings.tudey.util.OgnlFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class TargetLogic
extends Logic {
    protected TargetConfig _config;
    protected Logic _source;

    public void init(TudeySceneManager scenemgr, TargetConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public abstract void resolve(Logic var1, Collection<Logic> var2);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    public static class Randomized
    extends TargetLogic {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._target.resolve(activator, this._targets);
            Collections.shuffle(this._targets);
            results.addAll(this._targets);
            this._targets.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Randomized)source)._target, refs);
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((TargetConfig.Randomized)this._config).target, this._source);
        }
    }

    public static class Excluding
    extends TargetLogic {
        protected TargetLogic _target;
        protected TargetLogic _excluding;
        protected ArrayList<Logic> _targets = Lists.newArrayList();
        protected ArrayList<Logic> _excluded = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._target.resolve(activator, this._targets);
            if (this._targets.size() > 0) {
                this._excluding.resolve(activator, this._excluded);
                this._targets.removeAll(this._excluded);
                if (this._targets.size() > 0) {
                    results.addAll(this._targets);
                }
                this._excluded.clear();
            }
            this._targets.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Excluding esource = (Excluding)source;
            this._target.transfer(esource._target, refs);
            this._excluding.transfer(esource._excluding, refs);
        }

        @Override
        protected void didInit() {
            TargetConfig.Excluding config = (TargetConfig.Excluding)this._config;
            this._target = this.createTarget(config.target, this._source);
            this._excluding = this.createTarget(config.excluding, this._source);
        }
    }

    public static class Behavior
    extends TargetLogic {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic result;
                Logic target = this._targets.get(ii);
                if (!(target instanceof AgentLogic) || (result = ((AgentLogic)target).getBehaviorTarget()) == null) continue;
                results.add(result);
            }
            this._targets.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Behavior)source)._target, refs);
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((TargetConfig.Behavior)this._config).target, this._source);
        }
    }

    public static class Compound
    extends TargetLogic {
        protected TargetLogic[] _targets;

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            for (TargetLogic target : this._targets) {
                target.resolve(activator, results);
            }
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            TargetLogic[] stargets = ((Compound)source)._targets;
            for (int ii = 0; ii < this._targets.length; ++ii) {
                this._targets[ii].transfer(stargets[ii], refs);
            }
        }

        @Override
        protected void didInit() {
            ArrayList list = Lists.newArrayList();
            for (TargetConfig config : ((TargetConfig.Compound)this._config).targets) {
                TargetLogic target = this.createTarget(config, this._source);
                if (target == null) continue;
                list.add(target);
            }
            this._targets = list.toArray(new TargetLogic[list.size()]);
        }
    }

    public static class Conditional
    extends TargetLogic {
        protected ConditionLogic _condition;
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._target.resolve(activator, this._targets);
            int nn = this._targets.size();
            for (int ii = 0; ii < nn; ++ii) {
                Logic target = this._targets.get(ii);
                if (!this._condition.isSatisfied(target)) continue;
                results.add(target);
            }
            this._targets.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            Conditional csource = (Conditional)source;
            this._condition.transfer(csource._condition, refs);
            this._target.transfer(csource._target, refs);
        }

        @Override
        protected void didInit() {
            TargetConfig.Conditional config = (TargetConfig.Conditional)this._config;
            this._condition = this.createCondition(config.condition, this._source);
            this._target = this.createTarget(config.target, this._source);
        }
    }

    public static class FarthestSubset
    extends DistanceSubset {
        @Override
        public int compare(Logic l1, Logic l2) {
            return Float.compare(l2.getTranslation().distance(this._reference), l1.getTranslation().distance(this._reference));
        }
    }

    public static class NearestSubset
    extends DistanceSubset {
        @Override
        public int compare(Logic l1, Logic l2) {
            return Float.compare(l1.getTranslation().distance(this._reference), l2.getTranslation().distance(this._reference));
        }
    }

    public static abstract class DistanceSubset
    extends Subset
    implements Comparator<Logic> {
        protected TargetLogic _location;
        protected ArrayList<Logic> _locations = Lists.newArrayList();
        protected Vector2f _reference = new Vector2f();

        @Override
        protected void didInit() {
            super.didInit();
            this._location = this.createTarget(((TargetConfig.DistanceSubset)this._config).location, this._source);
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._location.transfer(((DistanceSubset)source)._location, refs);
        }

        @Override
        protected void selectSubset(int size, Logic activator, Collection<Logic> results) {
            this._location.resolve(activator, this._locations);
            int nlocs = this._locations.size();
            this._reference.set(Vector2f.ZERO);
            for (int ii = 0; ii < nlocs; ++ii) {
                this._reference.addLocal(this._locations.get(ii).getTranslation());
            }
            this._reference.multLocal(1.0f / (float)nlocs);
            this._locations.clear();
            QuickSort.sort((List)this._targets, (Comparator)this);
            results.addAll(this._targets.subList(0, size));
        }
    }

    public static class RandomSubset
    extends Subset {
        @Override
        protected void selectSubset(int size, Logic activator, Collection<Logic> results) {
            if (size == 1) {
                results.add((Logic)RandomUtil.pickRandom((List)this._targets));
            } else {
                results.addAll(CollectionUtil.selectRandomSubset((Collection)this._targets, (int)size));
            }
        }
    }

    public static abstract class Subset
    extends TargetLogic {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._target.resolve(activator, this._targets);
            int size = ((TargetConfig.Subset)this._config).size;
            if (this._targets.size() <= size) {
                results.addAll(this._targets);
            } else {
                this.selectSubset(size, activator, results);
            }
            this._targets.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((Subset)source)._target, refs);
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((TargetConfig.Subset)this._config).target, this._source);
        }

        protected abstract void selectSubset(int var1, Logic var2, Collection<Logic> var3);
    }

    public static class IntersectingMask
    extends TargetLogic {
        protected ConditionLogic _condition;
        protected RegionLogic _region;
        protected ArrayList<Shape> _shapes = Lists.newArrayList();
        protected ArrayList<?> _results = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._region.resolve(activator, this._shapes);
            TargetConfig.IntersectingMask config = (TargetConfig.IntersectingMask)this._config;
            int nn = this._shapes.size();
            for (int ii = 0; ii < nn; ++ii) {
                Shape shape = this._shapes.get(ii);
                if (this._scenemgr.getDebugIntersecting()) {
                    this._scenemgr.flashShape(this._scenemgr.getTimestamp(), null, 100, true, shape);
                }
                ArrayList<SpaceElement> elements = this._results;
                this._scenemgr.getActorSpace().getIntersecting(shape, elements);
                int mm = elements.size();
                for (int jj = 0; jj < mm; ++jj) {
                    ActorLogic logic = (ActorLogic)elements.get(jj).getUserObject();
                    if (logic == null || this._source instanceof PawnLogic && (!(this._source instanceof PawnLogic) || !logic.isVisible((PawnLogic)this._source)) || this._condition != null && (this._condition == null || !this._condition.isSatisfied(logic)) || (logic.getCollisionFlags() & config.collisionMask) == 0) continue;
                    results.add(logic);
                }
                elements.clear();
            }
            this._shapes.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._region.transfer(((Intersecting)source)._region, refs);
            if (this._condition != null) {
                this._condition.transfer(source, refs);
            }
        }

        @Override
        protected void didInit() {
            this._region = this.createRegion(((TargetConfig.IntersectingMask)this._config).region, this._source);
            this._condition = this.createCondition(((TargetConfig.IntersectingMask)this._config).condition, this._source);
        }
    }

    public static class Intersecting
    extends TargetLogic {
        protected ConditionLogic _actorCondition;
        protected ConditionLogic _entryCondition;
        protected RegionLogic _region;
        protected ArrayList<Shape> _shapes = Lists.newArrayList();
        protected ArrayList<?> _results = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._region.resolve(activator, this._shapes);
            TargetConfig.Intersecting config = (TargetConfig.Intersecting)this._config;
            int nn = this._shapes.size();
            for (int ii = 0; ii < nn; ++ii) {
                Shape shape = this._shapes.get(ii);
                if (this._scenemgr.getDebugIntersecting()) {
                    this._scenemgr.flashShape(this._scenemgr.getTimestamp(), null, 100, true, shape);
                }
                if (config.actors) {
                    ArrayList<SpaceElement> elements = this._results;
                    this._scenemgr.getActorSpace().getIntersecting(shape, elements);
                    int mm = elements.size();
                    for (int jj = 0; jj < mm; ++jj) {
                        ActorLogic logic = (ActorLogic)elements.get(jj).getUserObject();
                        if (logic == null || this._source instanceof PawnLogic && (!(this._source instanceof PawnLogic) || !logic.isVisible((PawnLogic)this._source)) || this._actorCondition != null && (this._actorCondition == null || !this._actorCondition.isSatisfied(logic))) continue;
                        results.add(logic);
                    }
                    elements.clear();
                }
                if (!config.entries) continue;
                ArrayList<TudeySceneModel.Entry> entries = this._results;
                TudeySceneModel model = (TudeySceneModel)this._scenemgr.getScene().getSceneModel();
                model.getEntries(shape, entries);
                int mm = entries.size();
                for (int jj = 0; jj < mm; ++jj) {
                    EntryLogic logic = this._scenemgr.getEntryLogic(entries.get(jj).getKey());
                    if (logic == null || this._entryCondition != null && (this._entryCondition == null || !this._entryCondition.isSatisfied(logic))) continue;
                    results.add(logic);
                }
                entries.clear();
            }
            this._shapes.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._region.transfer(((Intersecting)source)._region, refs);
            if (this._actorCondition != null) {
                this._actorCondition.transfer(source, refs);
            }
            if (this._entryCondition != null) {
                this._entryCondition.transfer(source, refs);
            }
        }

        @Override
        protected void didInit() {
            this._region = this.createRegion(((TargetConfig.Intersecting)this._config).region, this._source);
            this._actorCondition = this.createCondition(((TargetConfig.Intersecting)this._config).actorCondition, this._source);
            this._entryCondition = this.createCondition(((TargetConfig.Intersecting)this._config).entryCondition, this._source);
        }
    }

    public static class InstanceOf
    extends TargetLogic {
        protected Class<? extends Logic> _logicClass;

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            results.addAll(this._scenemgr.getInstances(this._logicClass));
        }

        @Override
        protected void didInit() {
            try {
                String cname = ((TargetConfig.InstanceOf)this._config).logicClass;
                Class<?> clazz = Class.forName(cname);
                this._logicClass = clazz;
            }
            catch (ClassNotFoundException e) {
                Log.log.warning((Object)"Missing logic class for InstanceOf target.", new Object[]{e});
                this._logicClass = Logic.class;
            }
        }
    }

    public static class Tagged
    extends TargetLogic {
        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            TargetConfig.Tagged config = (TargetConfig.Tagged)this._config;
            if (config.tag != null) {
                if (config.tag.indexOf("#") >= 0) {
                    results.addAll(this._scenemgr.getTagged(OgnlFilter.filter(config.tag, activator)));
                } else {
                    results.addAll(this._scenemgr.getTagged(config.tag));
                }
            }
        }
    }

    public static class ActivatorOf
    extends TargetLogic {
        protected TargetLogic _target;
        protected ArrayList<Logic> _targets = Lists.newArrayList();

        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            this._target.resolve(activator, this._targets);
            for (Logic target : this._targets) {
                if (!(target instanceof ActorLogic) || ((ActorLogic)target).getActivator() == null) continue;
                results.add(((ActorLogic)target).getActivator());
            }
            this._targets.clear();
        }

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._target.transfer(((ActivatorOf)source)._target, refs);
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((TargetConfig.ActivatorOf)this._config).target, this._source);
        }
    }

    public static class IsPlayer
    extends TargetLogic {
        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            results.add(activator.resolveTarget());
        }
    }

    public static class Activator
    extends TargetLogic {
        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            results.add(activator.resolveTarget());
        }
    }

    public static class Source
    extends TargetLogic {
        @Override
        public void resolve(Logic activator, Collection<Logic> results) {
            results.add(this._source.resolveTarget());
        }
    }
}

