/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.scene.Scene;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.config.CameraConfig;
import com.threerings.tudey.config.SceneGlobalConfig;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.util.TudeyContext;

public class GlobalSprite
extends EntrySprite
implements ConfigUpdateListener<SceneGlobalConfig> {
    protected TudeySceneModel.GlobalEntry _entry;
    protected SceneGlobalConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null, null){};

    public GlobalSprite(TudeyContext ctx, TudeySceneView view, TudeySceneModel.GlobalEntry entry) {
        super(ctx, view);
        this.update(entry);
    }

    @Override
    public void configUpdated(ConfigEvent<SceneGlobalConfig> event) {
        this.updateFromConfig();
    }

    @Override
    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    @Override
    public void update(TudeySceneModel.Entry entry) {
        this._entry = (TudeySceneModel.GlobalEntry)entry;
        this.setConfig(this._entry.sceneGlobal);
    }

    @Override
    public Model getModel() {
        return this._impl.getModel();
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void setConfig(ConfigReference<SceneGlobalConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(SceneGlobalConfig.class, ref));
    }

    protected void setConfig(SceneGlobalConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getSpriteImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    public static class Camera
    extends Implementation {
        protected CameraConfig _camcfg;
        protected CameraConfig[] _camcfgs;
        @Bound
        protected TudeySceneView _view;

        public Camera(TudeyContext ctx, Scope parentScope, SceneGlobalConfig.Camera config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(SceneGlobalConfig.Camera config) {
            if (this._camcfg != null) {
                this._view.removeCameraConfig(this._camcfg);
            }
            if (this._camcfgs != null) {
                for (CameraConfig cc : this._camcfgs) {
                    this._view.removeCameraConfig(cc, 0.0f, null);
                }
            }
            this._camcfg = config.camera;
            this._view.addCameraConfig(this._camcfg);
            for (CameraConfig cc : this._camcfgs = config.cameras) {
                this._view.addCameraConfig(cc, 0.0f, null);
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this._view.removeCameraConfig(this._camcfg);
            for (CameraConfig cc : this._camcfgs) {
                this._view.removeCameraConfig(cc, 0.0f, null);
            }
        }
    }

    public static class EnvironmentModel
    extends Implementation {
        protected Model _model;
        @Bound
        protected Scene _scene;

        public EnvironmentModel(TudeyContext ctx, Scope parentScope, SceneGlobalConfig.EnvironmentModel config) {
            super(ctx, parentScope);
            this._model = new Model(ctx);
            this._scene.add(this._model);
            this._model.setUserObject(parentScope);
            this.setConfig(config);
        }

        public void setConfig(SceneGlobalConfig.EnvironmentModel config) {
            this._model.setConfig(config.model);
            this._model.setLocalTransform(config.transform);
        }

        @Override
        public Model getModel() {
            return this._model;
        }

        @Override
        public void dispose() {
            super.dispose();
            this._scene.remove(this._model);
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        protected TudeyContext _ctx;

        public Implementation(TudeyContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }

        public Model getModel() {
            return null;
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }
}

