/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.base.Preconditions;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.TextComponent;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpinnerLogic {
    protected Button _next;
    protected Button _prev;
    protected TextComponent _label;
    protected SpinnerModel _model;
    protected boolean _enabled = true;
    protected ChangeListener _modelListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            SpinnerLogic.this.updateValue();
        }
    };
    protected ActionListener _buttonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int ii = SpinnerLogic.this.getRotationCount(e); ii > 0; --ii) {
                Object newValue;
                Object object = newValue = e.getSource() == SpinnerLogic.this._next ? SpinnerLogic.this._model.getNextValue() : SpinnerLogic.this._model.getPreviousValue();
                if (newValue == null) break;
                SpinnerLogic.this._model.setValue(newValue);
            }
        }
    };

    public SpinnerLogic(TextComponent label, Button next, Button prev, SpinnerModel model) {
        this._label = (TextComponent)Preconditions.checkNotNull((Object)label);
        this._next = next;
        this._prev = prev;
        this._next.addListener(this._buttonListener);
        this._prev.addListener(this._buttonListener);
        this.setModel(model);
    }

    public void setModel(SpinnerModel newModel) {
        if (!newModel.equals(this._model)) {
            if (this._model != null) {
                this._model.removeChangeListener(this._modelListener);
            }
            this._model = newModel;
            this._model.addChangeListener(this._modelListener);
            this.updateValue();
        }
    }

    public SpinnerModel getModel() {
        return this._model;
    }

    public Object getValue() {
        return this._model.getValue();
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        this._label.setEnabled(this._enabled);
        this.updateButtons();
    }

    protected void updateValue() {
        this._label.setText(String.valueOf(this.getValue()));
        this.updateButtons();
    }

    protected void updateButtons() {
        this._next.setEnabled(this._enabled && null != this._model.getNextValue());
        this._prev.setEnabled(this._enabled && null != this._model.getPreviousValue());
    }

    protected int getRotationCount(ActionEvent event) {
        return 0 == (event.getModifiers() & 0x18) ? 1 : 10;
    }
}

