/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.tools;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.FileUtil;
import com.threerings.export.BinaryExporter;
import com.threerings.export.Log;
import com.threerings.export.XMLImporter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;

public class XMLToBinaryConverter {
    public static void main(String[] args) throws Exception {
        boolean compress = true;
        while (args.length > 0 && args[0].startsWith("-")) {
            String options = args[0];
            args = (String[])ArrayUtil.splice((Object[])args, (int)0, (int)1);
            int nn = options.length();
            block4: for (int ii = 1; ii < nn; ++ii) {
                char option = options.charAt(ii);
                switch (option) {
                    case 'u': {
                        compress = false;
                        continue block4;
                    }
                    default: {
                        System.err.println("Unrecognized option: -" + option);
                        System.exit(1);
                    }
                }
            }
        }
        if (args.length == 2) {
            XMLToBinaryConverter.convert(args[0], args[1], compress);
        } else if (args.length == 1) {
            XMLToBinaryConverter.convert(args[0], compress);
        } else {
            System.err.println("Usage: XMLToBinaryConverter [-options] <xml input file> <binary output file>");
            System.err.println("   or  XMLToBinaryConverter [-options] <xml input file pattern>");
            System.err.println();
            System.err.println("where options include:");
            System.err.println("    -u            do not compress output");
        }
    }

    public static void convert(String pattern, boolean compress) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(".");
        scanner.setIncludes(new String[]{pattern});
        scanner.scan();
        for (String source : scanner.getIncludedFiles()) {
            try {
                XMLToBinaryConverter.convert(source, FileUtil.resuffix((File)new File(source), (String)".xml", (String)".dat"), compress);
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error converting file.", new Object[]{"file", source, e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String source, String dest, boolean compress) throws IOException {
        XMLImporter in = new XMLImporter(new FileInputStream(source));
        BinaryExporter out = new BinaryExporter(new FileOutputStream(dest), compress);
        try {
            try {
                while (true) {
                    out.writeObject(in.readObject());
                }
            }
            catch (EOFException e) {
                in.close();
                out.close();
            }
        }
        catch (Throwable throwable) {
            in.close();
            out.close();
            throw throwable;
        }
    }
}

