/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.tudey.Log;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

@EditorTypes(value={ControllerAction.class, ServerRequest.class, Compound.class})
public abstract class ClientActionConfig
extends DeepObject
implements Exportable,
Streamable {
    public abstract void execute(TudeyContext var1, TudeySceneView var2, Sprite var3);

    public static class Compound
    extends ClientActionConfig {
        @Editable
        public ClientActionConfig[] actions = new ClientActionConfig[0];

        @Override
        public void execute(TudeyContext ctx, TudeySceneView view, Sprite source) {
            ClientActionConfig[] clientActionConfigArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                ClientActionConfig action = clientActionConfigArray[n2];
                action.execute(ctx, view, source);
                ++n2;
            }
        }
    }

    public static class ControllerAction
    extends ClientActionConfig {
        @Editable
        public String command = "";
        @Editable
        public String argument = "";

        @Override
        public void execute(TudeyContext ctx, TudeySceneView view, Sprite source) {
            if (!view.getController().handleAction(source, this.command, this.argument)) {
                Log.log.warning((Object)"Controller didn't handle action.", new Object[]{"command", this.command});
            }
        }
    }

    public static class ServerRequest
    extends ClientActionConfig {
        @Editable
        public String name = "";

        @Override
        public void execute(TudeyContext ctx, TudeySceneView view, Sprite source) {
            view.getController().submitRequest(source, this.name);
        }
    }
}

