/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.scene;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Frustum;
import com.threerings.math.Ray3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.scene.SceneInfluence;
import com.threerings.opengl.scene.SceneObject;
import com.threerings.opengl.scene.ViewerEffect;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Intersectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HashScene
extends Scene {
    protected float _granularity;
    protected int _levels;
    protected HashMap<Coord, Node<SceneElement>> _elements = Maps.newHashMap();
    protected ArrayList<SceneElement> _oversizedElements = new ArrayList();
    protected HashMap<Coord, Node<SceneInfluence>> _influences = Maps.newHashMap();
    protected ArrayList<SceneInfluence> _oversizedInfluences = new ArrayList();
    protected HashMap<Coord, Node<ViewerEffect>> _effects = Maps.newHashMap();
    protected ArrayList<ViewerEffect> _oversizedEffects = new ArrayList();
    protected Box _bounds = new Box();
    protected Coord _minCoord = new Coord(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Coord _maxCoord = new Coord(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    protected int _visit;
    protected Coord _coord = new Coord();
    protected Box _box = new Box();
    protected Vector3f _pt = new Vector3f();
    protected Vector3f[] _lresults;
    protected List<InternalNode<?>> _internalNodePool = Lists.newArrayList();
    protected List<LeafNode<?>> _leafNodePool = Lists.newArrayList();

    public HashScene(GlContext ctx, float granularity, int levels) {
        this(ctx, granularity, levels, 50);
    }

    public HashScene(GlContext ctx, float granularity, int levels, int sources) {
        super(ctx, sources);
        this._granularity = granularity;
        this._levels = levels;
        this._lresults = new Vector3f[levels];
        int ii = 0;
        while (ii < levels) {
            this._lresults[ii] = new Vector3f();
            ++ii;
        }
    }

    @Override
    public void composite() {
        Frustum frustum = this._ctx.getCompositor().getCamera().getWorldVolume();
        this.composite(this._oversizedElements, frustum);
        if (frustum.getIntersectionType(this._bounds) == Frustum.IntersectionType.NONE) {
            return;
        }
        ++this._visit;
        frustum.getBounds().intersect(this._bounds, this._box);
        Vector3f min = this._box.getMinimumExtent();
        Vector3f max = this._box.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        int minz = FloatMath.ifloor(min.z * rgran);
        int maxz = FloatMath.ifloor(max.z * rgran);
        int zz = minz;
        while (zz <= maxz) {
            int yy = miny;
            while (yy <= maxy) {
                int xx = minx;
                while (xx <= maxx) {
                    Node<SceneElement> root = this._elements.get(this._coord.set(xx, yy, zz));
                    if (root != null) {
                        root.composite(frustum);
                    }
                    ++xx;
                }
                ++yy;
            }
            ++zz;
        }
    }

    @Override
    public SceneElement getIntersection(Ray3D ray, Vector3f location, Predicate<? super SceneElement> filter) {
        SceneElement closest = this.getIntersection(this._oversizedElements, ray, location, filter);
        if (!this._bounds.getIntersection(ray, this._pt)) {
            return closest;
        }
        ++this._visit;
        Vector3f origin = ray.getOrigin();
        Vector3f dir = ray.getDirection();
        int xdir = (int)Math.signum(dir.x);
        int ydir = (int)Math.signum(dir.y);
        int zdir = (int)Math.signum(dir.z);
        float rgran = 1.0f / this._granularity;
        float px = this._pt.x * rgran;
        float py = this._pt.y * rgran;
        float pz = this._pt.z * rgran;
        int lx = xdir < 0 ? FloatMath.iceil(px) : FloatMath.ifloor(px);
        int ly = ydir < 0 ? FloatMath.iceil(py) : FloatMath.ifloor(py);
        int lz = zdir < 0 ? FloatMath.iceil(pz) : FloatMath.ifloor(pz);
        Vector3f result = this._lresults[0];
        do {
            float t;
            float zt;
            SceneElement element;
            this._coord.set(lx - (xdir < 0 ? 1 : 0), ly - (ydir < 0 ? 1 : 0), lz - (zdir < 0 ? 1 : 0));
            Node<SceneElement> root = this._elements.get(this._coord);
            if (root != null && (element = root.getIntersection(ray, result, filter)) != null) {
                if (closest == null || origin.distanceSquared(result) < origin.distanceSquared(location)) {
                    closest = element;
                    location.set(result);
                }
                return closest;
            }
            float xt = xdir == 0 ? Float.MAX_VALUE : ((float)(lx + xdir) * this._granularity - origin.x) / dir.x;
            float yt = ydir == 0 ? Float.MAX_VALUE : ((float)(ly + ydir) * this._granularity - origin.y) / dir.y;
            float f = zt = zdir == 0 ? Float.MAX_VALUE : ((float)(lz + zdir) * this._granularity - origin.z) / dir.z;
            float f2 = xt < yt ? (xt < zt ? xt : zt) : (t = yt < zt ? yt : zt);
            if (xt == t) {
                lx += xdir;
            }
            if (yt == t) {
                ly += ydir;
            }
            if (zt != t) continue;
            lz += zdir;
        } while (this._coord.x >= this._minCoord.x && this._coord.x <= this._maxCoord.x && this._coord.y >= this._minCoord.y && this._coord.y <= this._maxCoord.y && this._coord.z >= this._minCoord.z && this._coord.z <= this._maxCoord.z);
        return closest;
    }

    @Override
    public void getElements(Box bounds, Collection<SceneElement> results) {
        this.getIntersecting(this._elements, this._oversizedElements, bounds, results);
    }

    @Override
    public void getInfluences(Box bounds, Collection<SceneInfluence> results) {
        this.getIntersecting(this._influences, this._oversizedInfluences, bounds, results);
    }

    @Override
    public void getEffects(Box bounds, Collection<ViewerEffect> results) {
        this.getIntersecting(this._effects, this._oversizedEffects, bounds, results);
    }

    @Override
    public void boundsWillChange(SceneElement element) {
        super.boundsWillChange(element);
        this.removeFromSpatial(element);
    }

    @Override
    public void boundsDidChange(SceneElement element) {
        super.boundsDidChange(element);
        this.addToSpatial(element);
    }

    @Override
    public void boundsWillChange(SceneInfluence influence) {
        super.boundsWillChange(influence);
        this.removeFromSpatial(influence);
    }

    @Override
    public void boundsDidChange(SceneInfluence influence) {
        super.boundsDidChange(influence);
        this.addToSpatial(influence);
    }

    @Override
    public void boundsWillChange(ViewerEffect effect) {
        super.boundsWillChange(effect);
        this.removeFromSpatial(effect);
    }

    @Override
    public void boundsDidChange(ViewerEffect effect) {
        super.boundsDidChange(effect);
        this.addToSpatial(effect);
    }

    @Override
    protected void addToSpatial(SceneElement element) {
        this.add(this._elements, this._oversizedElements, element);
    }

    @Override
    protected void removeFromSpatial(SceneElement element) {
        this.remove(this._elements, this._oversizedElements, element);
    }

    @Override
    protected void addToSpatial(SceneInfluence influence) {
        this.add(this._influences, this._oversizedInfluences, influence);
    }

    @Override
    protected void removeFromSpatial(SceneInfluence influence) {
        this.remove(this._influences, this._oversizedInfluences, influence);
    }

    @Override
    protected void addToSpatial(ViewerEffect effect) {
        this.add(this._effects, this._oversizedEffects, effect);
    }

    @Override
    protected void removeFromSpatial(ViewerEffect effect) {
        this.remove(this._effects, this._oversizedEffects, effect);
    }

    protected <T extends SceneObject> void add(HashMap<Coord, Node<T>> roots, ArrayList<T> oversized, T object) {
        Box bounds = object.getBounds();
        if (this.areOversized(bounds)) {
            oversized.add(object);
            return;
        }
        int level = this.getLevel(bounds);
        Vector3f min = bounds.getMinimumExtent();
        Vector3f max = bounds.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        int minz = FloatMath.ifloor(min.z * rgran);
        int maxz = FloatMath.ifloor(max.z * rgran);
        int zz = minz;
        while (zz <= maxz) {
            int yy = miny;
            while (yy <= maxy) {
                int xx = minx;
                while (xx <= maxx) {
                    Node<T> root = roots.get(this._coord.set(xx, yy, zz));
                    if (root == null) {
                        root = this.createRoot(xx, yy, zz);
                        roots.put(this._coord.clone(), root);
                        this.addBounds(this._coord, root);
                    }
                    root.add(object, level);
                    ++xx;
                }
                ++yy;
            }
            ++zz;
        }
    }

    protected <T extends SceneObject> void remove(HashMap<Coord, Node<T>> roots, ArrayList<T> oversized, T object) {
        Box bounds = object.getBounds();
        if (this.areOversized(bounds)) {
            oversized.remove(object);
            return;
        }
        int level = this.getLevel(bounds);
        Vector3f min = bounds.getMinimumExtent();
        Vector3f max = bounds.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        int minz = FloatMath.ifloor(min.z * rgran);
        int maxz = FloatMath.ifloor(max.z * rgran);
        int zz = minz;
        while (zz <= maxz) {
            int yy = miny;
            while (yy <= maxy) {
                int xx = minx;
                while (xx <= maxx) {
                    Node<T> root = roots.get(this._coord.set(xx, yy, zz));
                    if (root != null) {
                        root.remove(object, level);
                        if (root.isEmpty()) {
                            roots.remove(this._coord);
                            this.recomputeBounds();
                        }
                    }
                    ++xx;
                }
                ++yy;
            }
            ++zz;
        }
    }

    protected boolean areOversized(Box bounds) {
        return bounds.getLongestEdge() > this._granularity * 2.0f;
    }

    protected <T extends SceneObject> void getIntersecting(HashMap<Coord, Node<T>> roots, ArrayList<T> oversized, Box bounds, Collection<T> results) {
        HashScene.getIntersecting(oversized, bounds, results);
        bounds.intersect(this._bounds, this._box);
        if (this._box.isEmpty()) {
            return;
        }
        ++this._visit;
        Vector3f min = this._box.getMinimumExtent();
        Vector3f max = this._box.getMaximumExtent();
        float rgran = 1.0f / this._granularity;
        int minx = FloatMath.ifloor(min.x * rgran);
        int maxx = FloatMath.ifloor(max.x * rgran);
        int miny = FloatMath.ifloor(min.y * rgran);
        int maxy = FloatMath.ifloor(max.y * rgran);
        int minz = FloatMath.ifloor(min.z * rgran);
        int maxz = FloatMath.ifloor(max.z * rgran);
        int zz = minz;
        while (zz <= maxz) {
            int yy = miny;
            while (yy <= maxy) {
                int xx = minx;
                while (xx <= maxx) {
                    Node<T> root = roots.get(this._coord.set(xx, yy, zz));
                    if (root != null) {
                        root.get(bounds, results);
                    }
                    ++xx;
                }
                ++yy;
            }
            ++zz;
        }
    }

    protected int getLevel(Box bounds) {
        int level = FloatMath.round(FloatMath.log(bounds.getLongestEdge() / this._granularity) / FloatMath.log(0.5f));
        return Math.min(Math.max(level, 0), this._levels - 1);
    }

    protected <T extends SceneObject> Node<T> createRoot(int x, int y, int z) {
        Node<T> root = this.getFromNodePool(this._levels);
        Box bounds = root.getBounds();
        bounds.getMinimumExtent().set((float)x * this._granularity, (float)y * this._granularity, (float)z * this._granularity);
        bounds.getMaximumExtent().set((float)(x + 1) * this._granularity, (float)(y + 1) * this._granularity, (float)(z + 1) * this._granularity);
        return root;
    }

    protected void recomputeBounds() {
        this._bounds.setToEmpty();
        this._minCoord.set(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this._maxCoord.set(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.addBounds(this._elements);
        this.addBounds(this._influences);
        this.addBounds(this._effects);
    }

    protected <T extends SceneObject> void addBounds(HashMap<Coord, Node<T>> roots) {
        for (Map.Entry<Coord, Node<T>> entry : roots.entrySet()) {
            this.addBounds(entry.getKey(), entry.getValue());
        }
    }

    protected <T extends SceneObject> void addBounds(Coord coord, Node<T> node) {
        this._bounds.addLocal(node.getBounds());
        this._minCoord.set(Math.min(coord.x, this._minCoord.x), Math.min(coord.y, this._minCoord.y), Math.min(coord.z, this._minCoord.z));
        this._maxCoord.set(Math.max(coord.x, this._maxCoord.x), Math.max(coord.y, this._maxCoord.y), Math.max(coord.z, this._maxCoord.z));
    }

    protected <T extends SceneObject> Node<T> getFromNodePool(int levels) {
        if (levels > 1) {
            return this.getFromInternalNodePool(levels - 1);
        }
        return this.getFromLeafNodePool();
    }

    protected <T extends SceneObject> InternalNode<T> getFromInternalNodePool(int levels) {
        int size = this._internalNodePool.size();
        if (size == 0) {
            return new InternalNode(levels);
        }
        InternalNode<?> node = this._internalNodePool.remove(size - 1);
        node.reinit(levels);
        return node;
    }

    protected <T extends SceneObject> LeafNode<T> getFromLeafNodePool() {
        int size = this._leafNodePool.size();
        if (size == 0) {
            return new LeafNode();
        }
        LeafNode<?> node = this._leafNodePool.remove(size - 1);
        return node;
    }

    protected static class Coord
    implements Cloneable {
        public int x;
        public int y;
        public int z;

        public Coord(int x, int y, int z) {
            this.set(x, y, z);
        }

        public Coord() {
        }

        public Coord set(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Coord clone() {
            try {
                return (Coord)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public int hashCode() {
            return this.x + 31 * (this.y + 31 * this.z);
        }

        public boolean equals(Object other) {
            Coord ocoord = (Coord)other;
            return this.x == ocoord.x && this.y == ocoord.y && this.z == ocoord.z;
        }
    }

    protected class InternalNode<T extends SceneObject>
    extends Node<T> {
        public int _levels;
        public Node<T>[] _children;

        public InternalNode(int levels) {
            this._children = new Node[8];
            this._levels = levels;
        }

        public void reinit(int levels) {
            this._levels = levels;
        }

        @Override
        public boolean isEmpty() {
            if (!super.isEmpty()) {
                return false;
            }
            Node<T>[] nodeArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Node<T> child = nodeArray[n2];
                if (child != null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        @Override
        public void add(T object, int level) {
            if (level == 0) {
                super.add(object, level);
                return;
            }
            --level;
            Box bounds = object.getBounds();
            int ii = 0;
            while (ii < this._children.length) {
                Node<T> child = this._children[ii];
                if (child == null) {
                    this.getChildBounds(ii, HashScene.this._box);
                    if (HashScene.this._box.intersects(bounds)) {
                        child = HashScene.this.getFromNodePool(this._levels);
                        this._children[ii] = child;
                        child.getBounds().set(HashScene.this._box);
                        child.add(object, level);
                    }
                } else if (child.getBounds().intersects(bounds)) {
                    child.add(object, level);
                }
                ++ii;
            }
        }

        @Override
        public void remove(T object, int level) {
            if (level == 0) {
                super.remove(object, level);
                return;
            }
            --level;
            Box bounds = object.getBounds();
            int ii = 0;
            while (ii < this._children.length) {
                Node<T> child = this._children[ii];
                if (child != null && child.getBounds().intersects(bounds)) {
                    child.remove(object, level);
                    if (child.isEmpty()) {
                        child.returnToPool();
                        this._children[ii] = null;
                    }
                }
                ++ii;
            }
        }

        @Override
        public T getIntersection(Ray3D ray, Vector3f location, Predicate<? super T> filter) {
            T closest = super.getIntersection(ray, location, filter);
            Vector3f origin = ray.getOrigin();
            Vector3f result = HashScene.this._lresults[this._levels];
            Node<T>[] nodeArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                T object;
                Node<? super T> child = nodeArray[n2];
                if (child != null && child.getBounds().intersects(ray) && (object = child.getIntersection(ray, result, filter)) != null && (closest == null || origin.distanceSquared(result) < origin.distanceSquared(location))) {
                    closest = object;
                    location.set(result);
                }
                ++n2;
            }
            return closest;
        }

        @Override
        public void returnToPool() {
            HashScene.this._internalNodePool.add(this);
        }

        @Override
        protected void compositeAll() {
            super.compositeAll();
            Node<T>[] nodeArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Node<T> child = nodeArray[n2];
                if (child != null) {
                    child.compositeAll();
                }
                ++n2;
            }
        }

        @Override
        protected void compositeIntersecting(Frustum frustum) {
            super.compositeIntersecting(frustum);
            Node<T>[] nodeArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Node<T> child = nodeArray[n2];
                if (child != null) {
                    child.composite(frustum);
                }
                ++n2;
            }
        }

        @Override
        protected void getAll(Collection<T> results) {
            super.getAll(results);
            Node<T>[] nodeArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Node<T> child = nodeArray[n2];
                if (child != null) {
                    child.getAll(results);
                }
                ++n2;
            }
        }

        @Override
        protected void getIntersecting(Box bounds, Collection<T> results) {
            super.getIntersecting(bounds, results);
            Node<T>[] nodeArray = this._children;
            int n = this._children.length;
            int n2 = 0;
            while (n2 < n) {
                Node<T> child = nodeArray[n2];
                if (child != null) {
                    child.get(bounds, results);
                }
                ++n2;
            }
        }

        protected void getChildBounds(int idx, Box box) {
            Vector3f pmin = this._bounds.getMinimumExtent();
            Vector3f pmax = this._bounds.getMaximumExtent();
            Vector3f cmin = box.getMinimumExtent();
            Vector3f cmax = box.getMaximumExtent();
            float hsize = (pmax.x - pmin.x) * 0.5f;
            if ((idx & 4) == 0) {
                cmin.x = pmin.x;
                cmax.x = pmin.x + hsize;
            } else {
                cmin.x = pmin.x + hsize;
                cmax.x = pmax.x;
            }
            if ((idx & 2) == 0) {
                cmin.y = pmin.y;
                cmax.y = pmin.y + hsize;
            } else {
                cmin.y = pmin.y + hsize;
                cmax.y = pmax.y;
            }
            if ((idx & 1) == 0) {
                cmin.z = pmin.z;
                cmax.z = pmin.z + hsize;
            } else {
                cmin.z = pmin.z + hsize;
                cmax.z = pmax.z;
            }
        }
    }

    protected class LeafNode<T extends SceneObject>
    extends Node<T> {
        protected LeafNode() {
        }

        @Override
        public void returnToPool() {
            HashScene.this._leafNodePool.add(this);
        }
    }

    protected abstract class Node<T extends SceneObject> {
        public Box _bounds = new Box();
        public ArrayList<T> _objects = new ArrayList(4);

        protected Node() {
        }

        public Box getBounds() {
            return this._bounds;
        }

        public boolean isEmpty() {
            return this._objects.isEmpty();
        }

        public void add(T object, int level) {
            this._objects.add(object);
        }

        public void remove(T object, int level) {
            this._objects.remove(object);
        }

        public void composite(Frustum frustum) {
            Frustum.IntersectionType type = frustum.getIntersectionType(this._bounds);
            if (type == Frustum.IntersectionType.CONTAINS) {
                this.compositeAll();
            } else if (type == Frustum.IntersectionType.INTERSECTS) {
                this.compositeIntersecting(frustum);
            }
        }

        public T getIntersection(Ray3D ray, Vector3f location, Predicate<? super T> filter) {
            SceneObject closest = null;
            Vector3f origin = ray.getOrigin();
            int ii = 0;
            int nn = this._objects.size();
            while (ii < nn) {
                SceneObject object = (SceneObject)this._objects.get(ii);
                if (filter.apply((Object)object) && object.updateLastVisit(HashScene.this._visit) && ((Intersectable)((Object)object)).getIntersection(ray, HashScene.this._result) && (closest == null || origin.distanceSquared(HashScene.this._result) < origin.distanceSquared(location))) {
                    closest = object;
                    location.set(HashScene.this._result);
                }
                ++ii;
            }
            return (T)closest;
        }

        public void get(Box bounds, Collection<T> results) {
            if (bounds.contains(this._bounds)) {
                this.getAll(results);
            } else if (bounds.intersects(this._bounds)) {
                this.getIntersecting(bounds, results);
            }
        }

        public abstract void returnToPool();

        protected void compositeAll() {
            int ii = 0;
            int nn = this._objects.size();
            while (ii < nn) {
                SceneObject object = (SceneObject)this._objects.get(ii);
                if (object.updateLastVisit(HashScene.this._visit)) {
                    HashScene.this.composite((SceneElement)object);
                }
                ++ii;
            }
        }

        protected void compositeIntersecting(Frustum frustum) {
            int ii = 0;
            int nn = this._objects.size();
            while (ii < nn) {
                SceneObject object = (SceneObject)this._objects.get(ii);
                if (object.updateLastVisit(HashScene.this._visit) && frustum.getIntersectionType(object.getBounds()) != Frustum.IntersectionType.NONE) {
                    HashScene.this.composite((SceneElement)object);
                }
                ++ii;
            }
        }

        protected void getAll(Collection<T> results) {
            int ii = 0;
            int nn = this._objects.size();
            while (ii < nn) {
                SceneObject object = (SceneObject)this._objects.get(ii);
                if (object.updateLastVisit(HashScene.this._visit)) {
                    results.add(object);
                }
                ++ii;
            }
        }

        protected void getIntersecting(Box bounds, Collection<T> results) {
            int ii = 0;
            int nn = this._objects.size();
            while (ii < nn) {
                SceneObject object = (SceneObject)this._objects.get(ii);
                if (object.updateLastVisit(HashScene.this._visit) && object.getBounds().intersects(bounds)) {
                    results.add(object);
                }
                ++ii;
            }
        }
    }
}

