/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.FogState;
import com.threerings.util.DeepObject;

@EditorTypes(value={Disabled.class, Linear.class, Exponential.class})
public abstract class FogStateConfig
extends DeepObject
implements Exportable {
    public abstract FogState getState();

    public static class Disabled
    extends FogStateConfig {
        @Override
        public FogState getState() {
            return FogState.DISABLED;
        }
    }

    public static abstract class Enabled
    extends FogStateConfig {
        @Editable(hgroup="p")
        public Color4f color = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static class Exponential
    extends Enabled {
        @Editable(min=0.0, step=0.001, hgroup="p")
        public float density = 1.0f;
        @Editable(hgroup="p")
        public boolean squared;

        public Exponential(Enabled other) {
            this.color.set(other.color);
        }

        public Exponential() {
        }

        @Override
        public FogState getState() {
            return new FogState(this.squared ? 2049 : 2048, this.density, this.color);
        }
    }

    public static class Linear
    extends Enabled {
        @Editable(min=0.0, step=0.1, hgroup="p")
        public float start;
        @Editable(min=0.0, step=0.1, hgroup="p")
        public float end = 1.0f;

        public Linear(Enabled other) {
            this.color.set(other.color);
        }

        public Linear() {
        }

        @Override
        public FogState getState() {
            return new FogState(9729, this.start, this.end, this.color);
        }
    }
}

