/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect;

import com.samskivert.util.QuickSort;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.effect.BaseParticleSystem;
import com.threerings.opengl.effect.Particle;
import com.threerings.opengl.effect.config.BaseParticleSystemConfig;
import com.threerings.opengl.effect.config.ParticleSystemConfig;
import com.threerings.opengl.material.Surface;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.GlContext;
import java.util.Comparator;

public class ParticleSystem
extends BaseParticleSystem {
    protected Box[] _groupBounds = new Box[0];
    protected static final Comparator<Particle> DEPTH_COMP = new Comparator<Particle>(){

        @Override
        public int compare(Particle p1, Particle p2) {
            return Float.compare(p1.depth, p2.depth);
        }
    };

    public ParticleSystem(GlContext ctx, Scope parentScope, ParticleSystemConfig config) {
        super(ctx, parentScope);
        this.setConfig(ctx, config);
    }

    @Override
    protected BaseParticleSystem.Layer createLayer(BaseParticleSystemConfig.Layer config) {
        return new Layer(this._ctx, this, config);
    }

    @Override
    protected void resetBounds() {
        super.resetBounds();
        Box[] boxArray = this._groupBounds;
        int n = this._groupBounds.length;
        int n2 = 0;
        while (n2 < n) {
            Box bounds = boxArray[n2];
            bounds.setToEmpty();
            ++n2;
        }
    }

    protected Box getGroupBounds(int idx) {
        if (this._groupBounds.length <= idx) {
            Box[] obounds = this._groupBounds;
            this._groupBounds = new Box[idx + 1];
            System.arraycopy(obounds, 0, this._groupBounds, 0, obounds.length);
            int ii = obounds.length;
            while (ii < this._groupBounds.length) {
                this._groupBounds[ii] = new Box();
                ++ii;
            }
        }
        return this._groupBounds[idx];
    }

    public static class Layer
    extends BaseParticleSystem.Layer
    implements Enqueueable {
        @Scoped
        protected TransformState _transformState = new TransformState();
        @Scoped
        protected Vector3f _center = new Vector3f();
        protected Surface _surface;
        protected boolean _ownTransformState;

        public Layer(GlContext ctx, Scope parentScope, BaseParticleSystemConfig.Layer config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        @Override
        public void enqueue() {
            ParticleSystemConfig.GroupPriority priorityMode;
            if (this._ownTransformState) {
                this._parentViewTransform.compose(this._config.transform, this._transformState.getModelview());
                this._transformState.setDirty(true);
            }
            ParticleSystemConfig.Layer psconfig = (ParticleSystemConfig.Layer)this._config;
            if (psconfig.depthSort) {
                Transform3D xform = this._transformState.getModelview();
                int ii = 0;
                int nn = this._living.value;
                while (ii < nn) {
                    Particle particle = this._particles[ii];
                    particle.depth = xform.transformPointZ(particle.getPosition());
                    ++ii;
                }
                QuickSort.sort((Object[])this._particles, (int)0, (int)(this._living.value - 1), DEPTH_COMP);
            }
            if ((priorityMode = psconfig.priorityMode) != null) {
                Box bounds = ((ParticleSystem)this._parentScope).getGroupBounds(priorityMode.group);
                bounds.getCenter(this._center);
                Transform3D xform = this._ctx.getCompositor().getCamera().getWorldTransform();
                xform.getRotation().transformUnitZ(_vector).multLocal((float)priorityMode.priority * 1.0E-4f);
                this.pointToLayer(this._center.addLocal(_vector), false);
            }
        }

        @Override
        public void setConfig(BaseParticleSystemConfig.Layer config) {
            super.setConfig(config);
            ParticleSystemConfig.Layer psconfig = (ParticleSystemConfig.Layer)config;
            this._ownTransformState = psconfig.moveParticlesWithEmitter && psconfig.geometry.getMoveTrailsWithParticles();
            TransformState transformState = this._transformState = this._ownTransformState ? new TransformState() : ScopeUtil.resolve(this._parentScope, "viewTransformState", TransformState.IDENTITY, TransformState.class);
            if (this._surface != null) {
                this._surface.dispose();
            }
            this._surface = new Surface(this._ctx, (Scope)this, psconfig.geometry, this._ctx.getConfigManager().getConfig(MaterialConfig.class, psconfig.material));
            this._geometryRadius = psconfig.geometry.getRadius(this._ctx);
        }

        @Override
        public void composite() {
            if (!this._config.visible || this._living.value == 0) {
                return;
            }
            this._ctx.getCompositor().addEnqueueable(this);
            this._surface.composite();
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this._surface != null) {
                this._surface.dispose();
            }
        }

        @Override
        protected void initParticle(int idx) {
            ParticleSystemConfig.Layer psconfig = (ParticleSystemConfig.Layer)this._config;
            this._particles[idx].init(this._config.lifespan.getValue(), this._config.alphaMode, this._config.color, this._config.size, psconfig.geometry.getSegments() > 0 ? psconfig.length : null, psconfig.textureDivisionsS > 1 || psconfig.textureDivisionsT > 1 ? psconfig.frame : null, psconfig.moveParticlesWithEmitter && !psconfig.geometry.getMoveTrailsWithParticles() ? this._worldTransform : null);
        }

        @Override
        protected void addBounds() {
            ParticleSystemConfig.Layer psconfig = (ParticleSystemConfig.Layer)this._config;
            ParticleSystemConfig.GroupPriority priorityMode = psconfig.priorityMode;
            if (priorityMode == null) {
                this._bounds.getCenter(this._center);
            }
            super.addBounds();
            if (priorityMode != null) {
                ((ParticleSystem)this._parentScope).getGroupBounds(priorityMode.group).addLocal(this._bounds);
            }
        }
    }
}

