/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.math.Vector2f;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.tudey.config.HandlerConfig;
import com.threerings.tudey.config.PlaceableConfig;
import com.threerings.tudey.config.SceneGlobalConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.EntryStateLogic;
import com.threerings.tudey.server.logic.HandlerLogic;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.util.TudeySceneMetrics;
import java.util.ArrayList;
import java.util.Map;

public class EntryLogic
extends Logic {
    protected EntityKey.Entry _entityKey;
    protected TudeySceneModel.Entry _entry;
    protected String[] _tags;
    protected boolean _defaultEntrance;
    protected Vector2f _translation;
    protected float _rotation;
    protected Shape _shape;
    protected Vector2f[] _patrolPath;
    protected HandlerLogic[] _handlers;

    public void init(TudeySceneManager scenemgr, TudeySceneModel.Entry entry) {
        super.init(scenemgr);
        this._entityKey = new EntityKey.Entry(entry.getKey());
        this._entry = entry;
        ConfigManager cfgmgr = scenemgr.getConfigManager();
        this._translation = entry.getTranslation(cfgmgr);
        this._rotation = entry.getRotation(cfgmgr);
        this._tags = entry.getTags(cfgmgr);
        this._defaultEntrance = entry.isDefaultEntrance(cfgmgr);
        this._shape = entry.createShape(cfgmgr);
        ArrayList<HandlerLogic> handlers = new ArrayList<HandlerLogic>();
        HandlerConfig[] handlerConfigArray = entry.getHandlers(cfgmgr);
        int n = handlerConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerConfig config = handlerConfigArray[n2];
            HandlerLogic handler = this.createHandler(config, this);
            if (handler != null) {
                handlers.add(handler);
            }
            ++n2;
        }
        this._handlers = handlers.toArray(new HandlerLogic[handlers.size()]);
        this.didInit();
    }

    public TudeySceneModel.Entry getEntry() {
        return this._entry;
    }

    public void added() {
        int timestamp = this._scenemgr.getNextTimestamp();
        HandlerLogic[] handlerLogicArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerLogic handler = handlerLogicArray[n2];
            handler.startup(timestamp);
            ++n2;
        }
        this.wasAdded();
    }

    public void removed() {
        int timestamp = this._scenemgr.getNextTimestamp();
        HandlerLogic[] handlerLogicArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerLogic handler = handlerLogicArray[n2];
            handler.shutdown(timestamp, this, false);
            handler.removed();
            ++n2;
        }
        this.wasRemoved();
    }

    @Override
    public String[] getTags() {
        return this._tags;
    }

    @Override
    public boolean isDefaultEntrance() {
        return this._defaultEntrance;
    }

    @Override
    public boolean isActive() {
        return this._scenemgr.getEntryLogic(this._entry.getKey()) == this;
    }

    @Override
    public EntityKey getEntityKey() {
        return this._entityKey;
    }

    @Override
    public Vector2f getTranslation() {
        return this._translation;
    }

    @Override
    public float getRotation() {
        return this._rotation;
    }

    @Override
    public Shape getShape() {
        return this._shape;
    }

    @Override
    public Vector2f[] getPatrolPath() {
        return this._entry.createPatrolPath(this._shape);
    }

    @Override
    public ConfigReference<ModelConfig> getModel() {
        return this._entry.getModel(this._scenemgr.getConfigManager());
    }

    @Override
    public void signal(int timestamp, Logic source, String name) {
        HandlerLogic[] handlerLogicArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerLogic handler = handlerLogicArray[n2];
            handler.signal(timestamp, source, name);
            ++n2;
        }
    }

    @Override
    public void setVariable(int timestamp, Logic source, String name, Object value) {
        super.setVariable(timestamp, source, name, value);
        HandlerLogic[] handlerLogicArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerLogic handler = handlerLogicArray[n2];
            handler.variableChanged(timestamp, source, name);
            ++n2;
        }
    }

    @Override
    public void request(int timestamp, PawnLogic source, String name) {
        HandlerLogic[] handlerLogicArray = this._handlers;
        int n = this._handlers.length;
        int n2 = 0;
        while (n2 < n) {
            HandlerLogic handler = handlerLogicArray[n2];
            handler.request(timestamp, source, name);
            ++n2;
        }
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        HandlerLogic[] shandlers = ((EntryLogic)source)._handlers;
        int ii = 0;
        while (ii < this._handlers.length) {
            this._handlers[ii].transfer(shandlers[ii], refs);
            ++ii;
        }
    }

    protected void didInit() {
    }

    protected void wasAdded() {
    }

    protected void wasRemoved() {
    }

    public static class Camera
    extends EntryLogic {
        @Override
        protected void wasAdded() {
            TudeySceneModel.GlobalEntry gentry = (TudeySceneModel.GlobalEntry)this._entry;
            SceneGlobalConfig.Camera config = (SceneGlobalConfig.Camera)gentry.getConfig(this._scenemgr.getConfigManager());
            this._scenemgr.setDefaultLocalInterest(TudeySceneMetrics.getLocalInterest(config.camera, 1.3333334f));
        }

        @Override
        protected void wasRemoved() {
            this._scenemgr.setDefaultLocalInterest(TudeySceneMetrics.getDefaultLocalInterest());
        }
    }

    public static class StatefulProp
    extends EntryLogic {
        protected ActorLogic _actor;

        @Override
        public void transfer(Logic source, Map<Object, Object> refs) {
            super.transfer(source, refs);
            this._actor = (ActorLogic)refs.get(((StatefulProp)source)._actor);
        }

        @Override
        protected void wasAdded() {
            super.wasAdded();
            TudeySceneModel.PlaceableEntry pentry = (TudeySceneModel.PlaceableEntry)this._entry;
            PlaceableConfig.StatefulProp config = (PlaceableConfig.StatefulProp)pentry.getConfig(this._scenemgr.getConfigManager());
            if (config.actor != null) {
                this._actor = this._scenemgr.spawnActor(this._scenemgr.getNextTimestamp(), this._translation, this._rotation, config.actor, null, null);
                if (this._actor instanceof EntryStateLogic) {
                    ((EntryStateLogic)this._actor).setEntry(this);
                }
            }
        }

        @Override
        protected void wasRemoved() {
            if (this._actor != null) {
                this._actor.destroy(this._scenemgr.getNextTimestamp(), this, false);
            }
        }
    }
}

