/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing;

import com.threerings.ClydeLog;
import com.threerings.export.Exportable;
import com.threerings.export.Exporter;
import com.threerings.export.Importer;
import com.threerings.export.util.ExportUtil;
import java.io.IOException;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class PrefsTreeNode
extends DefaultMutableTreeNode
implements Exportable {
    protected Object _value;
    protected boolean _expanded;
    protected static final String EXPANDED = "%EXPANDED%";
    protected static final String EMPTY_NAME = "%EMPTY%";
    protected static final String SLASH_REPLACEMENT = "%SLASH%";

    public PrefsTreeNode(Preferences prefs) {
        super(PrefsTreeNode.decode(prefs.name()), true);
        try {
            String[] stringArray = prefs.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (!key.equals(EXPANDED)) {
                    Object object;
                    byte[] bytes = prefs.getByteArray(key, null);
                    Object object2 = object = bytes == null ? null : ExportUtil.fromBytes(bytes);
                    if (object != null) {
                        this.insertSorted(new PrefsTreeNode(PrefsTreeNode.decode(key), object));
                    }
                }
                ++n2;
            }
            stringArray = prefs.childrenNames();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.insertSorted(new PrefsTreeNode(prefs.node(name)));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            ClydeLog.log.warning((Object)"Error reading preferences.", new Object[]{"prefs", prefs, e});
        }
        this._expanded = prefs.getBoolean(EXPANDED, true);
    }

    public PrefsTreeNode(String name, Object value) {
        super(name, value == null);
        this._value = value;
    }

    public PrefsTreeNode() {
    }

    public Object getValue() {
        return this._value;
    }

    public PrefsTreeNode getChild(String name) {
        int ii = 0;
        int nn = this.getChildCount();
        while (ii < nn) {
            PrefsTreeNode child = (PrefsTreeNode)this.getChildAt(ii);
            if (child.getUserObject().equals(name)) {
                return child;
            }
            ++ii;
        }
        return null;
    }

    public void setExpanded(JTree tree, Preferences prefs, boolean expanded) {
        this._expanded = expanded;
        this.getPreferenceNode(prefs).putBoolean(EXPANDED, this._expanded);
        if (this._expanded && this.children != null) {
            for (Object child : this.children) {
                ((PrefsTreeNode)child).expandPaths(tree);
            }
        }
    }

    public String findNameForChild(String base) {
        String name = base;
        int ii = 2;
        while (this.haveChildNamed(name)) {
            name = String.valueOf(base) + " (" + ii + ")";
            ++ii;
        }
        return name;
    }

    public void addToPreferences(Preferences prefs) {
        if (this.getAllowsChildren()) {
            this.getPreferenceNode(prefs).putBoolean(EXPANDED, this._expanded);
            int ii = 0;
            int nn = this.getChildCount();
            while (ii < nn) {
                ((PrefsTreeNode)this.getChildAt(ii)).addToPreferences(prefs);
                ++ii;
            }
        } else {
            byte[] bytes = ExportUtil.toBytes(this._value);
            if (bytes != null) {
                PrefsTreeNode parent = (PrefsTreeNode)this.getParent();
                parent.getPreferenceNode(prefs).putByteArray(this.getName(), bytes);
            }
        }
    }

    public void removeFromPreferences(Preferences prefs) {
        if (this.getAllowsChildren()) {
            Preferences pnode = this.getPreferenceNode(prefs);
            try {
                pnode.removeNode();
            }
            catch (BackingStoreException e) {
                ClydeLog.log.warning((Object)"Error removing preferences.", new Object[]{"prefs", pnode, e});
            }
        } else {
            PrefsTreeNode parent = (PrefsTreeNode)this.getParent();
            parent.getPreferenceNode(prefs).remove(this.getName());
        }
    }

    public int getInsertionIndex(PrefsTreeNode child) {
        if (this.children == null) {
            return 0;
        }
        String name = (String)child.getUserObject();
        boolean folder = child.getAllowsChildren();
        int ii = 0;
        int nn = this.children.size();
        while (ii < nn) {
            PrefsTreeNode ochild = (PrefsTreeNode)this.children.get(ii);
            String oname = (String)ochild.getUserObject();
            boolean ofolder = ochild.getAllowsChildren();
            if (folder == ofolder ? name.compareTo(oname) <= 0 : !folder) {
                return ii;
            }
            ++ii;
        }
        return this.children.size();
    }

    public void expandPaths(JTree tree) {
        if (this._expanded) {
            tree.expandPath(new TreePath(this.getPath()));
            if (this.children != null) {
                for (Object child : this.children) {
                    ((PrefsTreeNode)child).expandPaths(tree);
                }
            }
        }
    }

    public void writeFields(Exporter out) throws IOException {
        out.defaultWriteFields();
        out.write("parent", (PrefsTreeNode)this.parent, null, PrefsTreeNode.class);
        out.write("children", this.children, null, Vector.class);
        out.write("userObject", (String)this.userObject, (String)null);
    }

    public void readFields(Importer in) throws IOException {
        in.defaultReadFields();
        this.setAllowsChildren(this._value == null);
        this.parent = in.read("parent", null, PrefsTreeNode.class);
        this.children = in.read("children", null, Vector.class);
        this.userObject = in.read("userObject", (String)null);
    }

    protected boolean haveChildNamed(String name) {
        String ename = PrefsTreeNode.encode(name);
        int ii = 0;
        int nn = this.getChildCount();
        while (ii < nn) {
            if (((PrefsTreeNode)this.getChildAt(ii)).getName().equals(ename)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    protected Preferences getPreferenceNode(Preferences prefs) {
        return prefs.node(this.getNodeName());
    }

    protected String getNodeName() {
        PrefsTreeNode parent = (PrefsTreeNode)this.getParent();
        if (parent == null) {
            return "";
        }
        if (parent.isRoot()) {
            return this.getName();
        }
        return String.valueOf(parent.getNodeName()) + "/" + this.getName();
    }

    protected String getName() {
        return PrefsTreeNode.encode((String)this.userObject);
    }

    protected void insertSorted(PrefsTreeNode child) {
        this.insert(child, this.getInsertionIndex(child));
    }

    protected static String encode(String name) {
        return name.length() == 0 ? EMPTY_NAME : name.replace("/", SLASH_REPLACEMENT);
    }

    protected static String decode(String name) {
        return name.equals(EMPTY_NAME) ? "" : name.replace(SLASH_REPLACEMENT, "/");
    }
}

