/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.io.Streamable;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.Compound;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.InfluenceFlagConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;

public class CompoundConfig
extends ModelConfig.Implementation {
    @Editable
    public SceneElement.TickPolicy tickPolicy = SceneElement.TickPolicy.DEFAULT;
    @Editable
    public InfluenceFlagConfig influences = new InfluenceFlagConfig(true);
    @Editable
    public ComponentModel[] models = new ComponentModel[0];

    @Override
    public void preload(GlContext ctx) {
        ComponentModel[] componentModelArray = this.models;
        int n = this.models.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentModel model = componentModelArray[n2];
            new Preloadable.Model(model.model).preload(ctx);
            ++n2;
        }
    }

    @Override
    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        if (impl instanceof Compound) {
            ((Compound)impl).setConfig(ctx, this);
        } else {
            impl = new Compound(ctx, scope, this);
        }
        return impl;
    }

    public static class ComponentModel
    extends DeepObject
    implements Exportable,
    Streamable {
        @Editable
        public String node = "";
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
        @Editable(step=0.01)
        public Transform3D transform;

        public ComponentModel() {
            this.transform = new Transform3D();
        }

        public ComponentModel(ConfigReference<ModelConfig> model, Transform3D transform) {
            this.model = model;
            this.transform = transform;
        }
    }
}

