/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.threerings.expr.Bound;
import com.threerings.expr.Function;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.Updater;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.material.Surface;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ArticulatedConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.DebugBounds;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class Articulated
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected ArticulatedConfig _config;
    protected Node[] _nodes;
    protected HashMap<String, Node> _nodesByName = new HashMap(0);
    protected Surface[] _surfaces;
    protected Animation[] _animations;
    protected HashMap<String, Animation> _animationsByName = new HashMap(0);
    protected Model[] _configAttachments;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound(value="getBoneMatrix")
    protected Function _parentGetBoneMatrix = Function.NULL;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform;
    @Scoped
    protected TransformState _transformState = new TransformState();
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    @Scoped
    protected Box _nbounds = new Box();
    protected SceneElement.TickPolicy _tickPolicy;
    protected ArrayList<Model> _userAttachments = new ArrayList(0);
    protected boolean _started;
    protected ArrayList<Animation> _playing = new ArrayList(0);
    protected Animation[] _playingArray = new Animation[0];
    protected int _update;
    protected boolean _completed;

    public Articulated(GlContext ctx, Scope parentScope, ArticulatedConfig config) {
        super(parentScope);
        this._viewTransform = this._transformState.getModelview();
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ArticulatedConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Scoped
    public Matrix4f getBoneMatrix(String name) {
        Node node = this._nodesByName.get(name);
        return node == null ? (Matrix4f)this._parentGetBoneMatrix.call(name) : node.getBoneMatrix();
    }

    @Scoped
    public Node getNode(String name) {
        return this._nodesByName.get(name);
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
    }

    @Override
    public List<Model> getChildren() {
        ArrayList m = Lists.newArrayList((Object[])this._configAttachments);
        m.addAll(this._userAttachments);
        return Collections.unmodifiableList(m);
    }

    @Override
    public Transform3D getPointWorldTransform(String point) {
        Node node = this._nodesByName.get(point);
        return node == null ? null : node.getWorldTransform();
    }

    @Override
    public void attach(String point, Model model, boolean replace) {
        Node node = this.getAttachmentNode(point);
        if (node == null) {
            return;
        }
        if (replace) {
            this.detachAll(node);
        }
        model.setParentScope(node);
        if (this._userAttachments.contains(model)) {
            return;
        }
        this._userAttachments.add(model);
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (scene != null) {
            model.wasAdded(scene);
        }
    }

    @Override
    public void detach(Model model) {
        Scene scene = ((Model)this._parentScope).getScene(this);
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            if (this._userAttachments.get(ii) == model) {
                if (scene != null) {
                    model.willBeRemoved();
                }
                this._userAttachments.remove(ii);
                return;
            }
            ++ii;
        }
        Log.log.warning((Object)"Missing attachment to remove.", new Object[]{"model", model});
    }

    @Override
    public void detachAll(String point) {
        this.detachAll(this._nodesByName.get(point));
    }

    @Override
    public List<Animation> getPlayingAnimations() {
        return this._playing;
    }

    @Override
    public Animation getAnimation(String name) {
        return this._animationsByName.get(name);
    }

    @Override
    public Animation[] getAnimations() {
        return this._animations;
    }

    @Override
    public Animation createAnimation() {
        return new Animation(this._ctx, this);
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void reset() {
        Model[] modelArray = this._configAttachments;
        int n = this._configAttachments.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.reset();
            ++n2;
        }
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            this._userAttachments.get(ii).reset();
            ++ii;
        }
        this._started = false;
        this._completed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        this.tick(0.0f);
    }

    @Override
    public void drawBounds() {
        DebugBounds.draw(this._bounds, Color4f.WHITE);
        Model[] modelArray = this._configAttachments;
        int n = this._configAttachments.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.drawBounds();
            ++n2;
        }
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            this._userAttachments.get(ii).drawBounds();
            ++ii;
        }
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(String.valueOf(prefix) + "Articulated: " + this._worldTransform + " " + this._bounds);
        String pprefix = String.valueOf(prefix) + "  ";
        Scope[] scopeArray = this._nodes;
        int n = this._nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = scopeArray[n2];
            node.dumpInfo(pprefix);
            ++n2;
        }
        scopeArray = this._configAttachments;
        n = this._configAttachments.length;
        n2 = 0;
        while (n2 < n) {
            Scope scope = scopeArray[n2];
            ((Model)scope).dumpInfo(pprefix);
            ++n2;
        }
        for (Model model : this._userAttachments) {
            model.dumpInfo(pprefix);
        }
        for (Animation animation : this._playing) {
            animation.dumpInfo(prefix);
        }
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void wasAdded() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        Model[] modelArray = this._configAttachments;
        int n = this._configAttachments.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.wasAdded(scene);
            ++n2;
        }
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            this._userAttachments.get(ii).wasAdded(scene);
            ++ii;
        }
    }

    @Override
    public void willBeRemoved() {
        Model[] modelArray = this._configAttachments;
        int n = this._configAttachments.length;
        int n2 = 0;
        while (n2 < n) {
            Model model = modelArray[n2];
            model.willBeRemoved();
            ++n2;
        }
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            this._userAttachments.get(ii).willBeRemoved();
            ++ii;
        }
    }

    @Override
    public void tick(float elapsed) {
        if (this._completed) {
            return;
        }
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this._config.skin.bounds.transform(this._worldTransform, this._nbounds);
        if (!this._started) {
            int ii = 0;
            while (ii < this._animations.length) {
                if (this._config.animationMappings[ii].startAutomatically) {
                    this._animations[ii].start();
                }
                ++ii;
            }
            this._started = true;
        }
        boolean tracksCompleted = false;
        this._playingArray = this._playing.toArray(this._playingArray);
        int ii = 0;
        int nn = this._playing.size();
        while (ii < nn) {
            tracksCompleted |= this._playingArray[ii].tick(elapsed);
            ++ii;
        }
        this.updateTransforms();
        if (tracksCompleted) {
            ii = this._playing.size() - 1;
            while (ii >= 0) {
                Animation animation = this._playing.get(ii);
                if (animation.hasCompleted()) {
                    this._playing.remove(ii);
                }
                --ii;
            }
        }
        Scope[] scopeArray = this._nodes;
        int n = this._nodes.length;
        int animation = 0;
        while (animation < n) {
            Node node = scopeArray[animation];
            node.update();
            ++animation;
        }
        this._completed = this._config.completable && this._playing.isEmpty();
        scopeArray = this._configAttachments;
        n = this._configAttachments.length;
        animation = 0;
        while (animation < n) {
            Scope model = scopeArray[animation];
            ((Model)model).tick(elapsed);
            this._nbounds.addLocal(((Model)model).getBounds());
            this._completed &= ((Model)model).hasCompleted();
            ++animation;
        }
        ii = 0;
        nn = this._userAttachments.size();
        while (ii < nn) {
            Model model = this._userAttachments.get(ii);
            model.tick(elapsed);
            this._nbounds.addLocal(model.getBounds());
            this._completed &= model.hasCompleted();
            ++ii;
        }
        if (!this._bounds.equals(this._nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(this._nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed) {
            ((Model)this._parentScope).completed(this);
        }
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        if (!this._bounds.intersects(ray)) {
            return false;
        }
        Vector3f closest = result;
        if (this.getSkinIntersection(ray, result)) {
            result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
        }
        Scope[] scopeArray = this._nodes;
        int n = this._nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = scopeArray[n2];
            if (node.getIntersection(ray, result)) {
                result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
            }
            ++n2;
        }
        scopeArray = this._configAttachments;
        n = this._configAttachments.length;
        n2 = 0;
        while (n2 < n) {
            Scope model = scopeArray[n2];
            if (((Model)model).getIntersection(ray, result)) {
                result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
            }
            ++n2;
        }
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            if (this._userAttachments.get(ii).getIntersection(ray, result)) {
                result = FloatMath.updateClosest(ray.getOrigin(), result, closest);
            }
            ++ii;
        }
        return result != closest;
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        Scope[] scopeArray = this._nodes;
        int n = this._nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = scopeArray[n2];
            node.composite();
            ++n2;
        }
        scopeArray = this._surfaces;
        n = this._surfaces.length;
        n2 = 0;
        while (n2 < n) {
            SimpleScope surface = scopeArray[n2];
            ((Surface)surface).composite();
            ++n2;
        }
        scopeArray = this._configAttachments;
        n = this._configAttachments.length;
        n2 = 0;
        while (n2 < n) {
            Scope model = scopeArray[n2];
            ((Model)model).composite();
            ++n2;
        }
        int ii = 0;
        int nn = this._userAttachments.size();
        while (ii < nn) {
            this._userAttachments.get(ii).composite();
            ++ii;
        }
    }

    protected void updateFromConfig() {
        Model model;
        Object node;
        String[] userAttachmentNodes = new String[this._userAttachments.size()];
        int ii = 0;
        while (ii < userAttachmentNodes.length) {
            userAttachmentNodes[ii] = ((Node)this._userAttachments.get((int)ii).getParentScope()).getConfig().name;
            ++ii;
        }
        IdentityHashMap onodes = Maps.newIdentityHashMap();
        if (this._nodes != null) {
            Node[] nodeArray = this._nodes;
            int n = this._nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeArray[n2];
                onodes.put(node2.getConfig(), node2);
                ++n2;
            }
        }
        this._influenceFlags = this._config.influences.getFlags();
        ArrayList<Node> nnodes = new ArrayList<Node>(8);
        this._config.root.getArticulatedNodes(this._ctx, this, onodes, nnodes, this._worldTransform, this._viewTransform);
        this._nodes = nnodes.toArray(new Node[nnodes.size()]);
        for (Node node3 : onodes.values()) {
            node3.dispose();
        }
        this._nodesByName.clear();
        Object[] objectArray = this._nodes;
        int n = this._nodes.length;
        int n3 = 0;
        while (n3 < n) {
            Node node4 = objectArray[n3];
            this._nodesByName.put(node4.getConfig().name, node4);
            ++n3;
        }
        objectArray = this._config.nodeTransforms;
        n = this._config.nodeTransforms.length;
        n3 = 0;
        while (n3 < n) {
            Object transform = objectArray[n3];
            node = this._nodesByName.get(((ArticulatedConfig.NodeTransform)transform).node);
            if (node != null) {
                ((Node)node).setUpdater(((ArticulatedConfig.NodeTransform)transform).createUpdater(this._ctx, (Node)node));
            }
            ++n3;
        }
        HashMap materialConfigs = Maps.newHashMapWithExpectedSize((int)this._config.materialMappings.length);
        node = this._nodes;
        int n4 = this._nodes.length;
        n = 0;
        while (n < n4) {
            Object node5 = node[n];
            ((Node)node5).createSurfaces(this._ctx, this._config.materialMappings, materialConfigs);
            ++n;
        }
        if (this._surfaces != null) {
            node = this._surfaces;
            n4 = this._surfaces.length;
            n = 0;
            while (n < n4) {
                Object surface = node[n];
                ((Surface)surface).dispose();
                ++n;
            }
        }
        this._surfaces = Articulated.createSurfaces(this._ctx, this, this._config.skin.visible, this._config.materialMappings, materialConfigs);
        Animation[] oanims = this._animations;
        this._animations = new Animation[this._config.animationMappings.length];
        int ii2 = 0;
        while (ii2 < this._animations.length) {
            Animation anim;
            this._animations[ii2] = anim = oanims == null || oanims.length <= ii2 ? new Animation(this._ctx, this) : oanims[ii2];
            ArticulatedConfig.AnimationMapping mapping = this._config.animationMappings[ii2];
            anim.setConfig(mapping.name, mapping.animation);
            if (this._started && mapping.startOnUpdated && !anim.isPlaying()) {
                anim.start();
            }
            ++ii2;
        }
        if (oanims != null) {
            ii2 = this._animations.length;
            while (ii2 < oanims.length) {
                oanims[ii2].dispose();
                ++ii2;
            }
        }
        this._animationsByName.clear();
        Animation[] animationArray = this._animations;
        int mapping = this._animations.length;
        int anim = 0;
        while (anim < mapping) {
            Animation animation = animationArray[anim];
            this._animationsByName.put(animation.getName(), animation);
            ++anim;
        }
        Scene scene = ((Model)this._parentScope).getScene(this);
        Model[] omodels = this._configAttachments;
        this._configAttachments = new Model[this._config.attachments.length];
        int ii3 = 0;
        while (ii3 < this._configAttachments.length) {
            boolean create = omodels == null || omodels.length <= ii3;
            this._configAttachments[ii3] = model = create ? new Model(this._ctx) : omodels[ii3];
            ArticulatedConfig.Attachment attachment = this._config.attachments[ii3];
            model.setParentScope(this.getAttachmentNode(attachment.node));
            model.setConfig(attachment.model);
            model.getLocalTransform().set(attachment.transform);
            if (create && scene != null) {
                model.wasAdded(scene);
            }
            ++ii3;
        }
        if (omodels != null) {
            ii3 = this._configAttachments.length;
            while (ii3 < omodels.length) {
                Model model2 = omodels[ii3];
                if (scene != null) {
                    model2.willBeRemoved();
                }
                model2.dispose();
                ++ii3;
            }
        }
        ArrayList<Model> oattachments = this._userAttachments;
        this._userAttachments = new ArrayList(userAttachmentNodes.length);
        int ii4 = 0;
        while (ii4 < userAttachmentNodes.length) {
            model = oattachments.get(ii4);
            Node node6 = this.getAttachmentNode(userAttachmentNodes[ii4]);
            if (node6 != null) {
                model.setParentScope(node6);
                this._userAttachments.add(model);
            } else if (scene != null) {
                model.willBeRemoved();
            }
            ++ii4;
        }
        SceneElement.TickPolicy npolicy = this._config.tickPolicy;
        if (npolicy == SceneElement.TickPolicy.DEFAULT) {
            npolicy = SceneElement.TickPolicy.WHEN_VISIBLE;
            Model[] modelArray = this._configAttachments;
            int n5 = this._configAttachments.length;
            int node6 = 0;
            while (node6 < n5) {
                model = modelArray[node6];
                npolicy = Articulated.mergePolicy(npolicy, model);
                ++node6;
            }
            int ii5 = 0;
            int nn = this._userAttachments.size();
            while (ii5 < nn) {
                npolicy = Articulated.mergePolicy(npolicy, this._userAttachments.get(ii5));
                ++ii5;
            }
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
        this.updateBounds();
    }

    protected void animationStarted(Animation animation, float overrideBlendOut) {
        this._playing.remove(animation);
        int priority = animation.getPriority();
        if (overrideBlendOut >= 0.0f) {
            ((Model)this._parentScope).stopAnimations(priority, overrideBlendOut);
        }
        int ii = 0;
        int nn = this._playing.size();
        while (ii < nn) {
            if (priority >= this._playing.get(ii).getPriority()) break;
            ++ii;
        }
        this._playing.add(ii, animation);
        ((Model)this._parentScope).animationStarted(animation);
    }

    protected void animationStopped(Animation animation, boolean completed) {
        if (!completed) {
            this._playing.remove(animation);
        }
        ((Model)this._parentScope).animationStopped(animation, completed);
    }

    protected Node getAttachmentNode(String name) {
        Node node = this._nodesByName.get(name);
        if (node == null) {
            Log.log.warning((Object)"Missing node for attachment.", new Object[]{"node", name});
        }
        return node;
    }

    protected void detachAll(Node node) {
        Scene scene = ((Model)this._parentScope).getScene(this);
        int ii = this._userAttachments.size() - 1;
        while (ii >= 0) {
            Model model = this._userAttachments.get(ii);
            if (model.getParentScope() == node) {
                if (scene != null) {
                    model.willBeRemoved();
                }
                this._userAttachments.remove(ii);
            }
            --ii;
        }
    }

    protected void updateTransforms() {
        int nn = this._playing.size();
        if (nn == 1) {
            this._playing.get(0).updateTransforms();
            return;
        }
        ++this._update;
        int ii = 0;
        while (ii < nn) {
            this._playing.get(ii).blendTransforms(this._update);
            ++ii;
        }
    }

    protected boolean getSkinIntersection(Ray3D ray, Vector3f result) {
        CollisionMesh collision = this._config.skin.collision;
        if (collision == null || !collision.getIntersection(ray.transform(this._worldTransform.invert()), result)) {
            return false;
        }
        this._worldTransform.transformPointLocal(result);
        return true;
    }

    protected static SceneElement.TickPolicy mergePolicy(SceneElement.TickPolicy policy, Model model) {
        SceneElement.TickPolicy mpolicy = model.getTickPolicy();
        return mpolicy.ordinal() > policy.ordinal() ? mpolicy : policy;
    }

    public static class MeshNode
    extends Node {
        @Bound(value="nbounds")
        protected Box _parentBounds;
        @Scoped
        protected Box _bounds = new Box();
        @Scoped
        protected TransformState _transformState = new TransformState(2);
        protected Surface _surface;

        public MeshNode(GlContext ctx, Scope parentScope, ArticulatedConfig.MeshNode config, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            super(ctx, parentScope);
            this._viewTransform = this._transformState.getModelview();
            this.setConfig(config, parentWorldTransform, parentViewTransform);
        }

        @Override
        public void createSurfaces(GlContext ctx, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
            ModelConfig.VisibleMesh mesh;
            if (this._surface != null) {
                this._surface.dispose();
            }
            this._surface = (mesh = ((ArticulatedConfig.MeshNode)this._config).visible) == null ? null : Articulated.createSurface(ctx, this, mesh, materialMappings, materialConfigs);
        }

        @Override
        public void update() {
            super.update();
            this._parentBounds.addLocal(this._config.getBounds().transform(this._worldTransform, this._bounds));
        }

        @Override
        public boolean getIntersection(Ray3D ray, Vector3f result) {
            CollisionMesh collision = ((ArticulatedConfig.MeshNode)this._config).collision;
            if (collision == null || !this._bounds.intersects(ray) || !collision.getIntersection(ray.transform(this._worldTransform.invert()), result)) {
                return false;
            }
            this._worldTransform.transformPointLocal(result);
            return true;
        }

        @Override
        public void dumpInfo(String prefix) {
            System.out.println(String.valueOf(prefix) + this._config.name + ": " + this._worldTransform + " " + this._bounds);
        }

        @Override
        public void composite() {
            super.composite();
            if (this._surface != null) {
                this._surface.composite();
            }
        }

        @Override
        public void enqueue() {
            super.enqueue();
            this._transformState.setDirty(true);
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this._surface != null) {
                this._surface.dispose();
            }
        }
    }

    public static class Node
    extends SimpleScope
    implements Enqueueable {
        public int lastUpdate;
        public float totalWeight;
        protected GlContext _ctx;
        protected ArticulatedConfig.Node _config;
        protected Transform3D _parentWorldTransform;
        protected Transform3D _parentViewTransform;
        protected Transform3D _localTransform;
        @Scoped
        protected Transform3D _worldTransform = new Transform3D();
        @Scoped
        protected Transform3D _viewTransform;
        protected Transform3D _boneTransform;
        protected Updater _updater;

        public Node(GlContext ctx, Scope parentScope, ArticulatedConfig.Node config, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            this(ctx, parentScope);
            this._viewTransform = new Transform3D(2);
            this.setConfig(config, parentWorldTransform, parentViewTransform);
        }

        public void setConfig(ArticulatedConfig.Node config, Transform3D parentWorldTransform, Transform3D parentViewTransform) {
            this._config = config;
            this._parentWorldTransform = parentWorldTransform;
            this._parentViewTransform = parentViewTransform;
            if (this._localTransform == null) {
                this._localTransform = new Transform3D(config.transform);
            }
            this._updater = null;
        }

        public ArticulatedConfig.Node getConfig() {
            return this._config;
        }

        public Transform3D getParentWorldTransform() {
            return this._parentWorldTransform;
        }

        public Transform3D getParentViewTransform() {
            return this._parentViewTransform;
        }

        public Transform3D getLocalTransform() {
            return this._localTransform;
        }

        public Transform3D getWorldTransform() {
            return this._worldTransform;
        }

        public Transform3D getViewTransform() {
            return this._viewTransform;
        }

        public Matrix4f getBoneMatrix() {
            if (this._boneTransform == null) {
                this._boneTransform = this._viewTransform.compose(this._config.invRefTransform);
                this._boneTransform.update(3);
            }
            return this._boneTransform.getMatrix();
        }

        public void setUpdater(Updater updater) {
            this._updater = updater;
        }

        public void createSurfaces(GlContext ctx, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
        }

        public void update() {
            if (this._updater instanceof ArticulatedConfig.WorldTransformUpdater) {
                this._updater.update();
            }
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }

        public boolean getIntersection(Ray3D ray, Vector3f result) {
            return false;
        }

        public void dumpInfo(String prefix) {
            System.out.println(String.valueOf(prefix) + this._config.name + ": " + this._worldTransform);
        }

        public void composite() {
            this._ctx.getCompositor().addEnqueueable(this);
        }

        @Override
        public void enqueue() {
            if (this._updater instanceof ArticulatedConfig.ViewTransformUpdater) {
                this._updater.update();
            }
            this._parentViewTransform.compose(this._localTransform, this._viewTransform);
            if (this._boneTransform != null) {
                this._viewTransform.compose(this._config.invRefTransform, this._boneTransform);
                this._boneTransform.update(3);
            }
        }

        @Override
        public String getScopeName() {
            return "node";
        }

        protected Node(GlContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }
    }
}

