/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.layout;

import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.layout.LayoutManager;
import com.threerings.opengl.gui.util.Dimension;
import com.threerings.opengl.gui.util.Insets;
import java.util.Arrays;
import java.util.HashMap;

public class TableLayout
extends LayoutManager {
    public static final Alignment LEFT = new Alignment();
    public static final Alignment CENTER = new Alignment();
    public static final Alignment RIGHT = new Alignment();
    public static final Alignment TOP = new Alignment();
    public static final Alignment BOTTOM = new Alignment();
    public static final Alignment STRETCH = new Alignment();
    protected Alignment _halign = LEFT;
    protected Alignment _valign = TOP;
    protected boolean _equalRows;
    protected int _rowgap;
    protected int _colgap;
    protected boolean[] _fixedColumns;
    protected HashMap<Component, Dimension> _pscache = new HashMap();

    public TableLayout(int columns) {
        this(columns, 0, 0);
    }

    public TableLayout(int columns, int rowgap, int colgap) {
        columns = Math.max(1, columns);
        this._fixedColumns = new boolean[columns];
        this._rowgap = rowgap;
        this._colgap = colgap;
    }

    public TableLayout setHorizontalAlignment(Alignment align) {
        this._halign = align;
        return this;
    }

    public TableLayout setVerticalAlignment(Alignment align) {
        this._valign = align;
        return this;
    }

    public TableLayout setFixedColumn(int column, boolean fixed) {
        this._fixedColumns[column] = fixed;
        return this;
    }

    public TableLayout setEqualRows(boolean equalRows) {
        this._equalRows = equalRows;
        return this;
    }

    @Override
    public Dimension computePreferredSize(Container target, int whint, int hhint) {
        Metrics metrics = this.computeMetrics(target, true, whint);
        int cx = (metrics.columnWidths.length - 1) * this._colgap;
        int rx = (this.computeRows(target, true) - 1) * this._rowgap;
        return new Dimension(this.sum(metrics.columnWidths) + cx, this.sum(metrics.rowHeights) + rx);
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        int availwid = target.getWidth() - insets.getHorizontal();
        Metrics metrics = this.computeMetrics(target, false, availwid);
        int totwidth = this.sum(metrics.columnWidths) + (metrics.columnWidths.length - 1) * this._colgap;
        int totheight = this.sum(metrics.rowHeights) + (this.computeRows(target, false) - 1) * this._rowgap;
        int sx = insets.left;
        if (this._halign == RIGHT) {
            sx += target.getWidth() - insets.getHorizontal() - totwidth;
        } else if (this._halign == CENTER) {
            sx += (target.getWidth() - insets.getHorizontal() - totwidth) / 2;
        }
        int y = insets.bottom + totheight;
        if (this._valign == CENTER) {
            y += (target.getHeight() - insets.getVertical() - totheight) / 2;
        } else if (this._valign == TOP) {
            y = target.getHeight() - insets.top;
        }
        int row = 0;
        int col = 0;
        int x = sx;
        int ii = 0;
        int ll = target.getComponentCount();
        while (ii < ll) {
            Component child = target.getComponent(ii);
            int width = Math.min(metrics.columnWidths[col], availwid);
            child.setBounds(x, y - metrics.rowHeights[row], width, metrics.rowHeights[row]);
            x += metrics.columnWidths[col] + this._colgap;
            if (++col == metrics.columnWidths.length) {
                y -= metrics.rowHeights[row] + this._rowgap;
                ++row;
                col = 0;
                x = sx;
            }
            ++ii;
        }
    }

    protected Metrics computeMetrics(Container target, boolean preferred, int whint) {
        int naturalWidth;
        Metrics metrics = new Metrics();
        metrics.columnWidths = new int[this._fixedColumns.length];
        int rows = this.computeRows(target, preferred);
        if (metrics.rowHeights == null || metrics.rowHeights.length != rows) {
            metrics.rowHeights = new int[rows];
        } else {
            Arrays.fill(metrics.rowHeights, 0);
        }
        Arrays.fill(metrics.columnWidths, 0);
        int row = 0;
        int col = 0;
        int maxrh = 0;
        int ii = 0;
        int ll = target.getComponentCount();
        while (ii < ll) {
            Component child = target.getComponent(ii);
            if (child.isVisible()) {
                Dimension psize = this._pscache.get(child);
                if (psize == null || !child.isValid()) {
                    psize = child.getPreferredSize(whint, -1);
                    this._pscache.put(child, psize);
                }
                if (psize.height > metrics.rowHeights[row]) {
                    metrics.rowHeights[row] = psize.height;
                    if (maxrh < metrics.rowHeights[row]) {
                        maxrh = metrics.rowHeights[row];
                    }
                }
                if (psize.width > metrics.columnWidths[col]) {
                    metrics.columnWidths[col] = psize.width;
                }
            }
            if (++col == metrics.columnWidths.length) {
                col = 0;
                ++row;
            }
            ++ii;
        }
        if (this._pscache.size() != target.getComponentCount()) {
            this._pscache.clear();
        }
        if (!preferred && this._halign == STRETCH && (naturalWidth = this.sum(metrics.columnWidths)) > 0) {
            int freewid = 0;
            int ii2 = 0;
            while (ii2 < this._fixedColumns.length) {
                if (!this._fixedColumns[ii2]) {
                    freewid += metrics.columnWidths[ii2];
                }
                ++ii2;
            }
            int avail = target.getWidth() - target.getInsets().getHorizontal() - naturalWidth - this._colgap * (metrics.columnWidths.length - 1);
            int used = 0;
            int ii3 = 0;
            while (ii3 < metrics.columnWidths.length) {
                if (!this._fixedColumns[ii3]) {
                    int adjust = metrics.columnWidths[ii3] * avail / freewid;
                    int n = ii3;
                    metrics.columnWidths[n] = metrics.columnWidths[n] + adjust;
                    used += adjust;
                }
                ++ii3;
            }
            if (metrics.columnWidths.length > 0) {
                ii3 = 0;
                while (ii3 < this._fixedColumns.length) {
                    if (!this._fixedColumns[ii3]) {
                        int n = ii3;
                        metrics.columnWidths[n] = metrics.columnWidths[n] + (avail - used);
                        break;
                    }
                    ++ii3;
                }
            }
        }
        if (this._equalRows) {
            Arrays.fill(metrics.rowHeights, maxrh);
        }
        return metrics;
    }

    protected int computeRows(Container target, boolean preferred) {
        int ccount = target.getComponentCount();
        int rows = ccount / this._fixedColumns.length;
        if (ccount % this._fixedColumns.length != 0) {
            ++rows;
        }
        return rows;
    }

    protected int sum(int[] values) {
        int total = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            total += value;
            ++n2;
        }
        return total;
    }

    public static class Alignment {
    }

    protected class Metrics {
        public int cachedHint = Integer.MIN_VALUE;
        public int[] columnWidths;
        public int[] rowHeights;

        protected Metrics() {
        }
    }
}

