/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.opengl.gui.Image;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.TextureUnit;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.GL11;

public class MaskedImage
extends Image {
    protected Image _mask;

    public MaskedImage(Image image, Image mask) {
        super(image.getWidth(), image.getHeight());
        this._mask = mask;
        if (image._units != null) {
            this.setTexture((Texture2D)image._units[0].texture);
        } else {
            this._image = image._image;
        }
    }

    @Override
    public void load(Renderer renderer, int format) {
        if (this._units == null) {
            super.load(renderer, format);
        }
        if (this._units[1] == null) {
            Texture2D mtex = this._mask.getTexture(renderer);
            this._units[1] = new TextureUnit(mtex);
        }
    }

    @Override
    public void render(Renderer renderer, int sx, int sy, int swidth, int sheight, int tx, int ty, int twidth, int theight, Color4f color, float alpha) {
        if (alpha == 0.0f) {
            return;
        }
        this.load(renderer, -1);
        float lx = (float)sx / (float)this._twidth;
        float ly = (float)sy / (float)this._theight;
        float ux = (float)(sx + swidth) / (float)this._twidth;
        float uy = (float)(sy + sheight) / (float)this._theight;
        float mwidth = (float)this._mask.getWidth() / (float)this._units[1].texture.getWidth();
        float mheight = (float)this._mask.getHeight() / (float)this._units[1].texture.getHeight();
        float mls = (float)sx / (float)twidth * mwidth;
        float mus = (float)(sx + swidth) / (float)twidth * mwidth;
        float mlt = (float)sy / (float)theight * mheight;
        float mut = (float)(sy + sheight) / (float)theight * mheight;
        float a = color.a * alpha;
        renderer.setColorState(color.r * a, color.g * a, color.b * a, a);
        renderer.setTextureState(this._units);
        renderer.setMatrixMode(5888);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)lx, (float)ly);
        ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mls, (float)mlt);
        GL11.glVertex2f((float)tx, (float)ty);
        GL11.glTexCoord2f((float)ux, (float)ly);
        ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mus, (float)mlt);
        GL11.glVertex2f((float)(tx + twidth), (float)ty);
        GL11.glTexCoord2f((float)ux, (float)uy);
        ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mus, (float)mut);
        GL11.glVertex2f((float)(tx + twidth), (float)(ty + theight));
        GL11.glTexCoord2f((float)lx, (float)uy);
        ARBMultitexture.glMultiTexCoord2fARB((int)33985, (float)mls, (float)mut);
        GL11.glVertex2f((float)tx, (float)(ty + theight));
        GL11.glEnd();
    }

    @Override
    protected void setTexture(Texture2D texture) {
        this._twidth = texture.getWidth();
        this._theight = texture.getHeight();
        this._units = new TextureUnit[2];
        this._units[0] = new TextureUnit(texture);
    }
}

