/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.Log;
import com.threerings.editor.MethodProperty;
import com.threerings.editor.Property;
import com.threerings.editor.swing.editors.ChoiceEditor;
import com.threerings.editor.util.PropertyUtil;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ConfigTypeEditor
extends ChoiceEditor {
    protected static String _cachedName;
    protected static Map<Class<?>, ManagedConfig> _cachedInstances;

    static {
        _cachedInstances = Maps.newHashMap();
    }

    @Override
    public void update() {
        super.update();
        this.setVisible(this._box.getItemCount() > 1);
    }

    @Override
    protected void didInit() {
        TypeProperty typeProperty = new TypeProperty((MethodProperty)this._property);
        this._lineage[this._lineage.length - 1] = typeProperty;
        this._property = typeProperty;
        super.didInit();
    }

    @Override
    public Object[] getOptions() {
        ConfigGroup<? extends ManagedConfig> group = ((ManagedConfig)this._object).getConfigGroup();
        if (group == null) {
            return ArrayUtil.EMPTY_OBJECT;
        }
        List<Class<?>> classes = group.getRawConfigClasses();
        Object[] boxes = new ClassBox[classes.size()];
        int ii = 0;
        int nn = classes.size();
        while (ii < nn) {
            boxes[ii] = new ClassBox(classes.get(ii), this.getLabel(classes.get(ii)));
            ++ii;
        }
        return boxes;
    }

    @Override
    protected void fireStateChanged() {
    }

    protected static ManagedConfig transfer(ManagedConfig source, Class<?> destClass) {
        String cfgName = source.getName();
        if (!cfgName.equals(_cachedName)) {
            _cachedName = cfgName;
            _cachedInstances.clear();
        }
        _cachedInstances.put(source.getClass(), source);
        ManagedConfig dest = _cachedInstances.get(destClass);
        if (dest == null) {
            try {
                dest = (ManagedConfig)destClass.newInstance();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to change type", new Object[]{e});
                return null;
            }
            _cachedInstances.put(destClass, dest);
        }
        PropertyUtil.transferCompatibleProperties(source, dest);
        dest.setName(cfgName);
        return dest;
    }

    protected static class ClassBox {
        public final Class<?> clazz;
        public final String label;

        public ClassBox(Class<?> clazz, String label) {
            this.clazz = clazz;
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object other) {
            return other instanceof ClassBox && this.clazz == ((ClassBox)other).clazz;
        }

        public int hashCode() {
            return this.clazz.hashCode();
        }
    }

    protected class TypeProperty
    extends Property {
        protected MethodProperty _base;

        public TypeProperty(MethodProperty prop) {
            this._base = prop;
            this._name = prop.getName();
        }

        @Override
        public Member getMember() {
            return this._base.getMember();
        }

        @Override
        public Class<?> getType() {
            return Class.class;
        }

        @Override
        public Type getGenericType() {
            return this.getType();
        }

        @Override
        public Object get(Object object) {
            return new ClassBox(object.getClass(), ConfigTypeEditor.this.getLabel(object.getClass()));
        }

        @Override
        public void set(Object object, Object value) {
            Class<?> clazz = ((ClassBox)value).clazz;
            if (object.getClass() == clazz) {
                return;
            }
            ManagedConfig oldCfg = (ManagedConfig)object;
            ManagedConfig newCfg = ConfigTypeEditor.transfer(oldCfg, clazz);
            oldCfg.getConfigGroup().addConfig(newCfg);
        }
    }
}

