/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Polygon;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;
import org.lwjgl.opengl.GL11;

public class Capsule
extends Shape {
    public float radius;
    protected Vector2f _start = new Vector2f();
    protected Vector2f _end = new Vector2f();

    public Capsule(Vector2f start, Vector2f end, float radius) {
        this._start.set(start);
        this._end.set(end);
        this.radius = radius;
        this.updateBounds();
    }

    public Capsule() {
    }

    public Vector2f getStart() {
        return this._start;
    }

    public Vector2f getEnd() {
        return this._end;
    }

    public boolean contains(Vector2f pt) {
        return this.contains(pt.x, pt.y);
    }

    public boolean contains(float x, float y) {
        float a = this._end.x - this._start.x;
        float b = this._end.y - this._start.y;
        float dp = a * x + b * y;
        if (dp <= a * this._start.x + b * this._start.y) {
            float dx = x - this._start.x;
            float dy = y - this._start.y;
            return dx * dx + dy * dy <= this.radius * this.radius;
        }
        if (dp >= a * this._end.x + b * this._end.y) {
            float dx = x - this._end.x;
            float dy = y - this._end.y;
            return dx * dx + dy * dy <= this.radius * this.radius;
        }
        a = this._start.y - this._end.y;
        b = this._end.x - this._start.x;
        float d = a * (x - this._start.x) + b * (y - this._start.y);
        return d * d <= this.radius * this.radius * (a * a + b * b);
    }

    @Override
    public void updateBounds() {
        this._bounds.setToEmpty();
        this._bounds.addLocal(this._start);
        this._bounds.addLocal(this._end);
        this._bounds.expandLocal(this.radius, this.radius);
    }

    @Override
    public Vector2f getCenter(Vector2f result) {
        return this._start.add(this._end, result).multLocal(0.5f);
    }

    @Override
    public Shape transform(Transform2D transform, Shape result) {
        Capsule cresult = result instanceof Capsule ? (Capsule)result : new Capsule();
        transform.transformPoint(this._start, cresult._start);
        transform.transformPoint(this._end, cresult._end);
        cresult.radius = this.radius * transform.approximateUniformScale();
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public Shape expand(float amount, Shape result) {
        Capsule cresult = result instanceof Capsule ? (Capsule)result : new Capsule();
        cresult.getStart().set(this._start);
        cresult.getEnd().set(this._end);
        cresult.radius = this.radius + amount;
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public Shape sweep(Vector2f translation, Shape result) {
        Capsule cresult = result instanceof Capsule ? (Capsule)result : new Capsule();
        cresult.getStart().set(this._start);
        cresult.getEnd().set(this._end);
        cresult.radius = this.radius;
        cresult.updateBounds();
        return cresult;
    }

    @Override
    public boolean getIntersection(Ray2D ray, Vector2f result) {
        return ray.getIntersection(this._start, this._end, this.radius, result);
    }

    @Override
    public void getNearestPoint(Vector2f point, Vector2f result) {
        if (this.contains(point)) {
            result.set(point);
            return;
        }
        Capsule.nearestPointOnSegment(this._start, this._end, point, result);
        Vector2f line = result.subtract(point);
        float length = line.length();
        line.mult((length - this.radius) / length);
        result.set(point).add(line);
    }

    @Override
    public Shape.IntersectionType getIntersectionType(Rect rect) {
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        int ccount = (this.contains(min.x, min.y) ? 1 : 0) + (this.contains(max.x, min.y) ? 1 : 0) + (this.contains(max.x, max.y) ? 1 : 0) + (this.contains(min.x, max.y) ? 1 : 0);
        if (ccount > 0) {
            return ccount == 4 ? Shape.IntersectionType.CONTAINS : Shape.IntersectionType.INTERSECTS;
        }
        if (rect.contains(this._start) || rect.contains(this._end)) {
            return Shape.IntersectionType.INTERSECTS;
        }
        float dx = this._end.x - this._start.x;
        float dy = this._end.y - this._start.y;
        if (this._start.x <= min.x ? this.intersectsLeft(rect, dx, dy) : this._start.x >= max.x && this.intersectsRight(rect, dx, dy)) {
            return Shape.IntersectionType.INTERSECTS;
        }
        if (this._start.y <= min.y ? this.intersectsBottom(rect, dx, dy) : this._start.y >= max.y && this.intersectsTop(rect, dx, dy)) {
            return Shape.IntersectionType.INTERSECTS;
        }
        return Shape.IntersectionType.NONE;
    }

    @Override
    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    @Override
    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public boolean intersects(Point point) {
        return this.contains(point.getLocation());
    }

    @Override
    public boolean intersects(Segment segment) {
        return Capsule.intersects(this._start, this._end, this.radius, segment.getStart(), segment.getEnd());
    }

    @Override
    public boolean intersects(Circle circle) {
        Vector2f center = circle.getCenter();
        float r = circle.radius + this.radius;
        float r2 = r * r;
        if (this._start.distanceSquared(center) <= r2 || this._end.distanceSquared(center) <= r2) {
            return true;
        }
        float dx = this._end.x - this._start.x;
        float ax = this._start.x - center.x;
        float dy = this._end.y - this._start.y;
        float ay = this._start.y - center.y;
        float b = 2.0f * (dx * ax + dy * ay);
        float a = dx * dx + dy * dy;
        float c = ax * ax + ay * ay - r2;
        float radicand = b * b - 4.0f * a * c;
        if (radicand < 0.0f) {
            return false;
        }
        float t = (-b - FloatMath.sqrt(radicand)) / (2.0f * a);
        return t >= 0.0f && t <= 1.0f;
    }

    @Override
    public boolean intersects(Capsule capsule) {
        return Capsule.intersects(this._start, this._end, this.radius + capsule.radius, capsule.getStart(), capsule.getEnd());
    }

    @Override
    public boolean intersects(Polygon polygon) {
        return polygon.intersects(this);
    }

    @Override
    public boolean intersects(Compound compound) {
        return compound.intersects(this);
    }

    @Override
    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Point point, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    @Override
    public Vector2f getPenetration(Segment segment, Vector2f result) {
        Vector2f[] cv = new Vector2f[]{this._start, this._end};
        Vector2f[] sv = new Vector2f[]{segment.getStart(), segment.getEnd()};
        Vector2f minDistance = Capsule.getMinMinkowskyDifference(cv, sv, this.radius, null);
        minDistance = Capsule.getMinMinkowskyDifference(sv, cv, this.radius, minDistance);
        return result.set(minDistance);
    }

    @Override
    public Vector2f getPenetration(Circle circle, Vector2f result) {
        Vector2f center = circle.getCenter();
        Vector2f D = center.subtract(this._start);
        Vector2f axis = this._end.subtract(this._start);
        float d = D.dot(axis);
        d = FloatMath.clamp(d, 0.0f, 1.0f);
        this._start.add(axis.multLocal(d), D);
        float dist = center.distance(D);
        return dist == 0.0f ? result.set(Vector2f.ZERO) : center.subtract(D, result).multLocal((circle.radius + this.radius) / dist - 1.0f);
    }

    @Override
    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        Vector2f[] cv = new Vector2f[]{this._start, this._end};
        Vector2f[] ov = new Vector2f[]{capsule.getStart(), capsule.getEnd()};
        float rad = this.radius + capsule.radius;
        Vector2f minDistance = Capsule.getMinMinkowskyDifference(cv, ov, rad, null);
        minDistance = Capsule.getMinMinkowskyDifference(ov, cv, rad, minDistance);
        return result.set(minDistance);
    }

    @Override
    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        return polygon.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return compound.getPenetration(this, result).negateLocal();
    }

    @Override
    public void draw(boolean outline) {
        float angle;
        int ii;
        float offset = FloatMath.atan2(this._end.x - this._start.x, this._start.y - this._end.y);
        GL11.glBegin((int)(outline ? 2 : 9));
        int nn = 8;
        for (ii = 0; ii <= nn; ++ii) {
            angle = (float)ii * 0.3926991f + offset;
            GL11.glVertex2f((float)(this._start.x + FloatMath.cos(angle) * this.radius), (float)(this._start.y + FloatMath.sin(angle) * this.radius));
        }
        nn = 8;
        for (ii = 0; ii <= nn; ++ii) {
            angle = (float)ii * 0.3926991f - offset;
            GL11.glVertex2f((float)(this._end.x + FloatMath.cos(angle) * this.radius), (float)(this._end.y + FloatMath.sin(angle) * this.radius));
        }
        GL11.glEnd();
    }

    @Override
    public ShapeConfig createConfig() {
        ShapeConfig.Capsule capsule = new ShapeConfig.Capsule();
        capsule.radius = this.radius;
        capsule.length = this._start.distance(this._end);
        ShapeConfig.TransformedShape transformed = new ShapeConfig.TransformedShape();
        transformed.shape = capsule;
        transformed.transform.set(this._start.add(this._end).multLocal(0.5f), this._start.direction(this._end));
        ShapeConfig.Compound compound = new ShapeConfig.Compound();
        compound.shapes = new ShapeConfig.TransformedShape[]{transformed};
        return compound;
    }

    public String toString() {
        return "[start=" + this._start.toString() + ", end=" + this._end.toString() + ", radius=" + this.radius + ", bounds=" + this._bounds + "]";
    }

    protected boolean intersectsLeft(Rect rect, float dx, float dy) {
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        float left = min.x - this.radius;
        if (this._start.x >= left) {
            return this._start.y >= min.y && this._start.y <= max.y;
        }
        if (Math.abs(dx) < 1.0E-6f) {
            return false;
        }
        float t = (left - this._start.x) / dx;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        float iy = this._start.y + t * dy;
        return iy >= min.y && iy <= max.y;
    }

    protected boolean intersectsRight(Rect rect, float dx, float dy) {
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        float right = max.x + this.radius;
        if (this._start.x <= right) {
            return this._start.y >= min.y && this._start.y <= max.y;
        }
        if (Math.abs(dx) < 1.0E-6f) {
            return false;
        }
        float t = (right - this._start.x) / dx;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        float iy = this._start.y + t * dy;
        return iy >= min.y && iy <= max.y;
    }

    protected boolean intersectsBottom(Rect rect, float dx, float dy) {
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        float bottom = min.y - this.radius;
        if (this._start.y >= bottom) {
            return this._start.x >= min.x && this._start.x <= max.x;
        }
        if (Math.abs(dy) < 1.0E-6f) {
            return false;
        }
        float t = (bottom - this._start.y) / dy;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        float ix = this._start.x + t * dx;
        return ix >= min.x && ix <= max.x;
    }

    protected boolean intersectsTop(Rect rect, float dx, float dy) {
        Vector2f min = rect.getMinimumExtent();
        Vector2f max = rect.getMaximumExtent();
        float top = max.y + this.radius;
        if (this._start.y <= top) {
            return this._start.x >= min.x && this._start.x <= max.x;
        }
        if (Math.abs(dy) < 1.0E-6f) {
            return false;
        }
        float t = (top - this._start.y) / dy;
        if (t < 0.0f || t > 1.0f) {
            return false;
        }
        float ix = this._start.x + t * dx;
        return ix >= min.x && ix <= max.x;
    }
}

