/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.util.DeepObject;
import org.lwjgl.opengl.GLContext;

@EditorTypes(value={Modulate.class, Decal.class, Blend.class, Replace.class, Add.class, Combine.class})
public abstract class TextureEnvironmentConfig
extends DeepObject
implements Exportable {
    @Editable(mode="alpha", hgroup="cl")
    public Color4f color = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    @Editable(step=0.01, hgroup="cl")
    public float lodBias;

    public boolean isSupported(boolean fallback) {
        return true;
    }

    public void configure(TextureUnit unit) {
        unit.envMode = this.getMode();
        unit.envColor.set(this.color);
        unit.lodBias = this.lodBias;
    }

    public abstract int getMode();

    public static class AlphaParam
    extends DeepObject
    implements Exportable {
        @Editable(hgroup="p")
        public Source source = Source.TEXTURE;
        @Editable(hgroup="p")
        public AlphaOperand operand = AlphaOperand.SRC_ALPHA;

        public AlphaParam(Source source, AlphaOperand operand) {
            this.source = source;
            this.operand = operand;
        }

        public AlphaParam() {
        }
    }

    public static class RGBParam
    extends DeepObject
    implements Exportable {
        @Editable(hgroup="p")
        public Source source = Source.TEXTURE;
        @Editable(hgroup="p")
        public RGBOperand operand = RGBOperand.SRC_COLOR;

        public RGBParam(Source source, RGBOperand operand) {
            this.source = source;
            this.operand = operand;
        }

        public RGBParam() {
        }
    }

    public static class Combine
    extends TextureEnvironmentConfig {
        @Editable(category="rgb")
        public RGBCombine rgbCombine = RGBCombine.MODULATE;
        @Editable(category="rgb")
        public RGBParam rgbParam0 = new RGBParam(Source.TEXTURE, RGBOperand.SRC_COLOR);
        @Editable(category="rgb")
        public RGBParam rgbParam1 = new RGBParam(Source.PREVIOUS, RGBOperand.SRC_COLOR);
        @Editable(category="rgb")
        public RGBParam rgbParam2 = new RGBParam(Source.CONSTANT, RGBOperand.SRC_ALPHA);
        @Editable(category="rgb")
        public Scale rgbScale = Scale.ONE;
        @Editable(category="alpha")
        public AlphaCombine alphaCombine = AlphaCombine.MODULATE;
        @Editable(category="alpha")
        public AlphaParam alphaParam0 = new AlphaParam(Source.TEXTURE, AlphaOperand.SRC_ALPHA);
        @Editable(category="alpha")
        public AlphaParam alphaParam1 = new AlphaParam(Source.PREVIOUS, AlphaOperand.SRC_ALPHA);
        @Editable(category="alpha")
        public AlphaParam alphaParam2 = new AlphaParam(Source.CONSTANT, AlphaOperand.SRC_ALPHA);
        @Editable(category="alpha")
        public Scale alphaScale = Scale.ONE;

        @Override
        public boolean isSupported(boolean fallback) {
            return GLContext.getCapabilities().GL_ARB_texture_env_combine;
        }

        @Override
        public void configure(TextureUnit unit) {
            super.configure(unit);
            unit.rgbCombine = this.rgbCombine.getConstant();
            unit.alphaCombine = this.alphaCombine.getConstant();
            unit.rgbSource0 = this.rgbParam0.source.getConstant();
            unit.rgbSource1 = this.rgbParam1.source.getConstant();
            unit.rgbSource2 = this.rgbParam2.source.getConstant();
            unit.alphaSource0 = this.alphaParam0.source.getConstant();
            unit.alphaSource1 = this.alphaParam1.source.getConstant();
            unit.alphaSource2 = this.alphaParam2.source.getConstant();
            unit.rgbOperand0 = this.rgbParam0.operand.getConstant();
            unit.rgbOperand1 = this.rgbParam1.operand.getConstant();
            unit.rgbOperand2 = this.rgbParam2.operand.getConstant();
            unit.alphaOperand0 = this.alphaParam0.operand.getConstant();
            unit.alphaOperand1 = this.alphaParam1.operand.getConstant();
            unit.alphaOperand2 = this.alphaParam2.operand.getConstant();
            unit.rgbScale = this.rgbScale.getValue();
            unit.alphaScale = this.alphaScale.getValue();
        }

        @Override
        public int getMode() {
            return 34160;
        }
    }

    public static class Add
    extends TextureEnvironmentConfig {
        @Override
        public boolean isSupported(boolean fallback) {
            return GLContext.getCapabilities().GL_ARB_texture_env_add;
        }

        @Override
        public int getMode() {
            return 260;
        }
    }

    public static class Replace
    extends TextureEnvironmentConfig {
        @Override
        public int getMode() {
            return 7681;
        }
    }

    public static class Blend
    extends TextureEnvironmentConfig {
        @Override
        public int getMode() {
            return 3042;
        }
    }

    public static class Decal
    extends TextureEnvironmentConfig {
        @Override
        public int getMode() {
            return 8449;
        }
    }

    public static class Modulate
    extends TextureEnvironmentConfig {
        @Override
        public int getMode() {
            return 8448;
        }
    }

    public static enum Scale {
        ONE(1.0f),
        TWO(2.0f),
        FOUR(4.0f);

        protected final float _value;

        public float getValue() {
            return this._value;
        }

        private Scale(float value) {
            this._value = value;
        }
    }

    public static enum AlphaOperand {
        SRC_ALPHA(770),
        ONE_MINUS_SRC_ALPHA(771);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private AlphaOperand(int constant) {
            this._constant = constant;
        }
    }

    public static enum RGBOperand {
        SRC_COLOR(768),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        ONE_MINUS_SRC_ALPHA(771);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private RGBOperand(int constant) {
            this._constant = constant;
        }
    }

    public static enum Source {
        TEXTURE(5890),
        CONSTANT(34166),
        PRIMARY_COLOR(34167),
        PREVIOUS(34168);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private Source(int constant) {
            this._constant = constant;
        }
    }

    public static enum AlphaCombine {
        REPLACE(7681),
        MODULATE(8448),
        ADD(260),
        ADD_SIGNED(34164),
        INTERPOLATE(34165),
        SUBTRACT(34023);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private AlphaCombine(int constant) {
            this._constant = constant;
        }
    }

    public static enum RGBCombine {
        REPLACE(7681),
        MODULATE(8448),
        ADD(260),
        ADD_SIGNED(34164),
        INTERPOLATE(34165),
        SUBTRACT(34023),
        DOT3_RGB(34478){

            @Override
            public boolean isSupported(boolean fallback) {
                return GLContext.getCapabilities().GL_ARB_texture_env_dot3;
            }
        }
        ,
        DOT3_RGBA(34479){

            @Override
            public boolean isSupported(boolean fallback) {
                return GLContext.getCapabilities().GL_ARB_texture_env_dot3;
            }
        };

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        public boolean isSupported(boolean fallback) {
            return true;
        }

        private RGBCombine(int constant) {
            this._constant = constant;
        }
    }
}

