/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.HGroupLayout;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.editor.swing.Vector2fPanel;
import com.threerings.math.FloatMath;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Transform2DPanel
extends BasePropertyEditor
implements ChangeListener {
    protected Mode _mode;
    protected Vector2fPanel _tpanel;
    protected JSpinner _rspinner;
    protected JSpinner _sspinner;

    public Transform2DPanel(MessageBundle msgs, Mode mode, float step, float scale) {
        this._msgs = msgs;
        this._mode = mode;
        this.setLayout((LayoutManager)new HGroupLayout(GroupLayout.NONE, GroupLayout.NONE, 5, GroupLayout.CENTER));
        this.setBackground(null);
        JPanel tcont = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.CENTER, (GroupLayout.Policy)GroupLayout.NONE);
        tcont.setBackground(null);
        tcont.setBorder(BorderFactory.createTitledBorder(this.getLabel("translation")));
        this.add(tcont);
        this._tpanel = new Vector2fPanel(msgs, Vector2fPanel.Mode.CARTESIAN, step, scale);
        tcont.add((Component)((Object)this._tpanel));
        this._tpanel.addChangeListener(this);
        JPanel rscont = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.CENTER, (GroupLayout.Policy)GroupLayout.NONE);
        ((GroupLayout)rscont.getLayout()).setOffAxisJustification(GroupLayout.RIGHT);
        rscont.setBackground(null);
        this.add(rscont);
        JPanel rpanel = new JPanel();
        rpanel.setBackground(null);
        rscont.add(rpanel);
        rpanel.add(new JLabel(this.getLabel("rotation") + ":"));
        this._rspinner = new DraggableSpinner(0.0f, -180.0f, 180.0f, 1.0f);
        rpanel.add(this._rspinner);
        this._rspinner.addChangeListener(this);
        if (this._mode == Mode.RIGID) {
            return;
        }
        JPanel spanel = new JPanel();
        spanel.setBackground(null);
        rscont.add(spanel);
        spanel.add(new JLabel(this.getLabel("scale") + ":"));
        this._sspinner = new DraggableSpinner(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(step));
        spanel.add(this._sspinner);
        this._sspinner.addChangeListener(this);
    }

    public Vector2fPanel getTranslationPanel() {
        return this._tpanel;
    }

    public void setValue(Transform2D value) {
        value.update(2);
        this._tpanel.setValue(value.getTranslation());
        this._rspinner.setValue(Float.valueOf(FloatMath.toDegrees(value.getRotation())));
        if (this._mode == Mode.UNIFORM) {
            this._sspinner.setValue(Float.valueOf(value.getScale()));
        }
    }

    public Transform2D getValue() {
        float scale;
        Vector2f translation = this._tpanel.getValue();
        float rotation = FloatMath.toRadians(((Number)this._rspinner.getValue()).floatValue());
        float f = scale = this._sspinner == null ? 1.0f : ((Number)this._sspinner.getValue()).floatValue();
        if (scale == 1.0f) {
            return translation.equals(Vector2f.ZERO) && rotation == 0.0f ? new Transform2D() : new Transform2D(translation, rotation);
        }
        return new Transform2D(translation, rotation, scale);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    public static enum Mode {
        RIGID,
        UNIFORM;

    }
}

