/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.DraggableSpinner;
import com.threerings.math.FloatMath;
import com.threerings.math.Quaternion;
import com.threerings.math.Vector3f;
import com.threerings.util.MessageBundle;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuaternionPanel
extends BasePropertyEditor
implements ChangeListener {
    protected JSpinner[] _spinners;
    protected Mode _mode;

    public QuaternionPanel(MessageBundle msgs, Mode mode) {
        this._msgs = msgs;
        this._mode = mode;
        this.setLayout((LayoutManager)new VGroupLayout(GroupLayout.NONE, GroupLayout.STRETCH, 5, GroupLayout.TOP));
        this.setBackground(null);
        switch (this._mode) {
            case XYZ: {
                this._spinners = new JSpinner[]{this.addSpinnerPanel("x", -180.0f, 180.0f), this.addSpinnerPanel("y", -90.0f, 90.0f), this.addSpinnerPanel("z", -180.0f, 180.0f)};
                break;
            }
            case ZXY: {
                this._spinners = new JSpinner[]{this.addSpinnerPanel("x", -180.0f, 360.0f), this.addSpinnerPanel("y", -90.0f, 360.0f), this.addSpinnerPanel("z", -180.0f, 360.0f)};
            }
        }
    }

    public void setValue(Quaternion value) {
        Vector3f angles = this._mode == Mode.XYZ ? value.toAngles() : value.toAnglesZXY();
        this._spinners[0].setValue(Float.valueOf(FloatMath.toDegrees(angles.x)));
        this._spinners[1].setValue(Float.valueOf(FloatMath.toDegrees(angles.y)));
        this._spinners[2].setValue(Float.valueOf(FloatMath.toDegrees(angles.z)));
    }

    public Quaternion getValue() {
        float x = FloatMath.toRadians(((Number)this._spinners[0].getValue()).floatValue());
        float y = FloatMath.toRadians(((Number)this._spinners[1].getValue()).floatValue());
        float z = FloatMath.toRadians(((Number)this._spinners[2].getValue()).floatValue());
        return this._mode == Mode.XYZ ? new Quaternion().fromAngles(x, y, z) : new Quaternion().fromAnglesZXY(x, y, z);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    protected JSpinner addSpinnerPanel(String name, float min, float max) {
        JPanel panel = new JPanel();
        panel.setBackground(null);
        this.add(panel);
        panel.add(new JLabel(this.getLabel(name) + ":"));
        DraggableSpinner spinner = new DraggableSpinner(Float.valueOf(0.0f), Float.valueOf(min), Float.valueOf(max), Float.valueOf(1.0f));
        panel.add(spinner);
        spinner.addChangeListener(this);
        return spinner;
    }

    public static enum Mode {
        XYZ,
        ZXY;

    }
}

