/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.gson.annotations.SerializedName;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.export.Exportable;
import com.threerings.io.Intern;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;
import java.io.IOException;

public class ConfigReference<T extends ManagedConfig>
extends DeepObject
implements Exportable,
Streamable {
    @Intern
    @SerializedName(value="name")
    protected String _name;
    @SerializedName(value="arguments")
    protected ArgumentMap _arguments = new ArgumentMap();

    public ConfigReference(String name) {
        this._name = name;
    }

    public ConfigReference(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this._name = name;
        this._arguments.put(firstKey, firstValue);
        for (int ii = 0; ii < otherArgs.length; ii += 2) {
            this._arguments.put((String)otherArgs[ii], otherArgs[ii + 1]);
        }
    }

    public ConfigReference() {
    }

    public String getName() {
        return this._name;
    }

    public ArgumentMap getArguments() {
        return this._arguments;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeIntern(this._name);
        this._arguments.writeObject(out);
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._name = in.readIntern();
        this._arguments.readObject(in);
    }

    public T getConfig(ConfigManager cfgMgr, Class<T> token) {
        return cfgMgr.getConfig(token, this);
    }

    @Override
    public Object copy(Object dest) {
        ConfigReference<T> cref;
        if (dest instanceof ConfigReference) {
            cref = (ConfigReference<T>)dest;
            cref._name = this._name;
        } else {
            cref = new ConfigReference<T>(this._name);
        }
        this._arguments.copy(cref.getArguments());
        return cref;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ConfigReference)) {
            return false;
        }
        ConfigReference oref = (ConfigReference)other;
        return this._name.equals(oref.getName()) && this._arguments.equals(oref.getArguments());
    }

    @Override
    public int hashCode() {
        return 31 * this._name.hashCode() + this._arguments.hashCode();
    }

    @Override
    public String toString() {
        return "[name=" + this._name + ", arguments=" + this._arguments + "]";
    }

    @Override
    public ConfigReference<T> clone() {
        return (ConfigReference)super.clone();
    }

    public ConfigReference<T> clone(String arg, Object value) {
        DeepObject that = this.clone();
        ((ConfigReference)that).getArguments().put(arg, value);
        return that;
    }

    public ConfigReference<T> clone(String arg, Object value, Object ... moreArgs) {
        ConfigReference<T> that = this.clone(arg, value);
        int nn = moreArgs.length;
        for (int ii = 0; ii < nn; ii += 2) {
            that.getArguments().put((String)moreArgs[ii], moreArgs[ii + 1]);
        }
        return that;
    }
}

