//
// $Id$
//
// Clyde library - tools for developing networked games
// Copyright (C) 2005-2012 Three Rings Design, Inc.
// http://code.google.com/p/clyde/
//
// Redistribution and use in source and binary forms, with or without modification, are permitted
// provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this list of
//    conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright notice, this list of
//    conditions and the following disclaimer in the documentation and/or other materials provided
//    with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
// INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
// PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package com.threerings.editor.swing.editors;

import java.io.File;

/**
 * Editor for resource references, which are set as files but stored as string paths relative
 * to the resource directory.
 */
public class ResourceEditor extends FileEditor
{
    @Override // documentation inherited
    protected String getDefaultDirectory ()
    {
    	String file = (String)_property.get(_object);
    	if(file != null){
    		return _ctx.getResourceManager().getResourceFile(file).toString();
    	}
        return _ctx.getResourceManager().getResourceFile("").toString();
    }

    @Override // documentation inherited
    protected File getPropertyFile ()
    {
        String path = (String)_property.get(_object);
        return (path == null) ? null : _ctx.getResourceManager().getResourceFile(path);
    }

    @Override // documentation inherited
    protected void setPropertyFile (File file)
    {
        _property.set(_object, (file == null) ?
            null : _ctx.getResourceManager().getResourcePath(file));
    }
}
