/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.shape;

import com.samskivert.util.StringUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Ray2D;
import com.threerings.math.Rect;
import com.threerings.math.Transform2D;
import com.threerings.math.Vector2f;
import com.threerings.tudey.shape.Capsule;
import com.threerings.tudey.shape.Circle;
import com.threerings.tudey.shape.Compound;
import com.threerings.tudey.shape.Point;
import com.threerings.tudey.shape.Segment;
import com.threerings.tudey.shape.Shape;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.space.SpaceElement;
import org.lwjgl.opengl.GL11;

public class Polygon
extends Shape {
    protected Vector2f[] _vertices;

    public Polygon(Vector2f ... vertices) {
        this._vertices = new Vector2f[vertices.length];
        int ii = 0;
        while (ii < vertices.length) {
            this._vertices[ii] = new Vector2f(vertices[ii]);
            ++ii;
        }
        this.updateBounds();
    }

    public Polygon(int vcount) {
        this.initVertices(vcount);
    }

    public int getVertexCount() {
        return this._vertices.length;
    }

    public Vector2f getVertex(int idx) {
        return this._vertices[idx];
    }

    public boolean contains(Vector2f pt) {
        return this.contains(pt.x, pt.y);
    }

    public boolean contains(float x, float y) {
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            if (a * x + b * y < a * start.x + b * start.y) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    @Override
    public void updateBounds() {
        this._bounds.fromPoints(this._vertices);
    }

    @Override
    public Vector2f getCenter(Vector2f result) {
        result.set(0.0f, 0.0f);
        Vector2f[] vector2fArray = this._vertices;
        int n = this._vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vector2f vertex = vector2fArray[n2];
            result.addLocal(vertex);
            ++n2;
        }
        return result.multLocal(1.0f / (float)this._vertices.length);
    }

    @Override
    public Shape transform(Transform2D transform, Shape result) {
        Polygon presult;
        Polygon polygon = presult = result instanceof Polygon ? (Polygon)result : new Polygon(this._vertices.length);
        if (presult.getVertexCount() != this._vertices.length) {
            presult.initVertices(this._vertices.length);
        }
        int ii = 0;
        while (ii < this._vertices.length) {
            transform.transformPoint(this._vertices[ii], presult._vertices[ii]);
            ++ii;
        }
        presult.updateBounds();
        return presult;
    }

    @Override
    public Shape expand(float amount, Shape result) {
        Polygon presult;
        Polygon polygon = presult = result instanceof Polygon ? (Polygon)result : new Polygon(this._vertices.length);
        if (presult.getVertexCount() != this._vertices.length) {
            presult.initVertices(this._vertices.length);
        }
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f current = this._vertices[ii];
            Vector2f next = this._vertices[(ii + 1) % this._vertices.length];
            Vector2f prev = this._vertices[(ii + this._vertices.length - 1) % this._vertices.length];
            float nx = next.y - current.y;
            float ny = current.x - next.x;
            float nl = FloatMath.hypot(nx, ny);
            float px = current.y - prev.y;
            float py = prev.x - current.x;
            float pl = FloatMath.hypot(px, py);
            if (nl < 1.0E-6f) {
                if (pl < 1.0E-6f) {
                    presult._vertices[ii].set(Vector2f.ZERO);
                } else {
                    presult._vertices[ii].set(px, py).multLocal(1.0f / pl);
                }
            } else if (pl < 1.0E-6f) {
                presult._vertices[ii].set(nx, ny).multLocal(1.0f / nl);
            } else {
                float rnl = 1.0f / nl;
                float rpl = 1.0f / pl;
                presult._vertices[ii].set(nx * rnl + px * rpl, ny * rnl + py * rpl).normalizeLocal();
            }
            ++ii;
        }
        ii = 0;
        while (ii < this._vertices.length) {
            Vector2f rvert = presult._vertices[ii];
            this._vertices[ii].addScaled(rvert, amount, rvert);
            ++ii;
        }
        presult.updateBounds();
        return presult;
    }

    @Override
    public Shape sweep(Vector2f translation, Shape result) {
        Polygon poly;
        Vector2f[] vertices;
        if (Vector2f.ZERO.equals(translation)) {
            vertices = this._vertices;
        } else {
            vertices = new Vector2f[this._vertices.length + 2];
            Float odot = null;
            int sidx = -1;
            int eidx = -1;
            int ii = 0;
            int nn = this._vertices.length;
            while (ii < nn + 1) {
                Vector2f start = this._vertices[ii % nn];
                Vector2f end = this._vertices[(ii + 1) % nn];
                Vector2f perp = new Vector2f(start.y - end.y, end.x - start.x);
                float dot = perp.dot(translation) > 0.0f ? 1 : -1;
                if (odot == null) {
                    odot = new Float(dot);
                } else if (odot.floatValue() != dot) {
                    if (dot < 0.0f) {
                        sidx = ii % nn;
                    } else {
                        eidx = ii % nn;
                    }
                    if (sidx >= 0 && eidx >= 0) break;
                    odot = Float.valueOf(dot);
                }
                ++ii;
            }
            boolean add = sidx > eidx;
            int ii2 = 0;
            int nn2 = this._vertices.length;
            int jj = 0;
            while (ii2 < nn2) {
                vertices[jj] = new Vector2f(this._vertices[ii2]);
                if (ii2 == sidx) {
                    add = true;
                    vertices[++jj] = new Vector2f(this._vertices[ii2]);
                }
                if (add) {
                    vertices[jj].addLocal(translation);
                }
                if (ii2 == eidx) {
                    add = false;
                    vertices[++jj] = new Vector2f(this._vertices[ii2]);
                }
                ++ii2;
                ++jj;
            }
        }
        Polygon polygon = poly = result instanceof Polygon ? (Polygon)result : null;
        if (poly != null) {
            poly._vertices = vertices;
        } else {
            poly = new Polygon(vertices);
        }
        return poly;
    }

    @Override
    public Vector2f[] getPerimeterPath() {
        Vector2f[] path = new Vector2f[this._vertices.length + 1];
        int ii = 0;
        while (ii < this._vertices.length) {
            path[ii] = new Vector2f(this._vertices[ii]);
            ++ii;
        }
        path[this._vertices.length] = new Vector2f(this._vertices[0]);
        return path;
    }

    @Override
    public boolean getIntersection(Ray2D ray, Vector2f result) {
        Vector2f origin = ray.getOrigin();
        if (this.contains(origin)) {
            result.set(origin);
            return true;
        }
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            if (a * origin.x + b * origin.y <= a * start.x + b * start.y && ray.getIntersection(start, end, result)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    @Override
    public void getNearestPoint(Vector2f point, Vector2f result) {
        if (this.contains(point)) {
            result.set(point);
            return;
        }
        Vector2f currentResult = new Vector2f();
        float minDist = Float.MAX_VALUE;
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            Polygon.nearestPointOnSegment(start, end, point, currentResult);
            float dist = point.distanceSquared(currentResult);
            if (dist < minDist) {
                minDist = dist;
                result.set(currentResult);
                if (Math.abs(minDist) < 1.0E-6f) {
                    return;
                }
            }
            ++ii;
        }
    }

    @Override
    public Shape.IntersectionType getIntersectionType(Rect rect) {
        if (!this._bounds.intersects(rect)) {
            return Shape.IntersectionType.NONE;
        }
        int ccount = 0;
        Vector2f rmin = rect.getMinimumExtent();
        Vector2f rmax = rect.getMaximumExtent();
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            float c = a * start.x + b * start.y;
            int inside = (a * rmin.x + b * rmin.y >= c ? 1 : 0) + (a * rmax.x + b * rmin.y >= c ? 1 : 0) + (a * rmax.x + b * rmax.y >= c ? 1 : 0) + (a * rmin.x + b * rmax.y >= c ? 1 : 0);
            if (inside == 0) {
                return Shape.IntersectionType.NONE;
            }
            if (inside == 4) {
                ++ccount;
            }
            ++ii;
        }
        return ccount == this._vertices.length ? Shape.IntersectionType.CONTAINS : Shape.IntersectionType.INTERSECTS;
    }

    @Override
    public boolean intersects(SpaceElement element) {
        return element.intersects(this);
    }

    @Override
    public boolean intersects(Shape shape) {
        return shape.intersects(this);
    }

    @Override
    public boolean intersects(Point point) {
        return this.contains(point.getLocation());
    }

    @Override
    public boolean intersects(Segment segment) {
        Vector2f origin = segment.getStart();
        if (this.contains(origin)) {
            return true;
        }
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            if (a * origin.x + b * origin.y <= a * start.x + b * start.y && segment.intersects(start, end)) {
                return true;
            }
            ++ii;
        }
        return false;
    }

    @Override
    public boolean intersects(Circle circle) {
        Vector2f center = circle.getCenter();
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            float l2 = a * a + b * b;
            float d = a * center.x + b * center.y - a * start.x - b * start.y;
            if (!(d >= 0.0f)) {
                Vector2f next = this._vertices[(ii + 2) % this._vertices.length];
                a = end.y - next.y;
                b = next.x - end.x;
                if (a * center.x + b * center.y <= a * end.x + b * end.y) {
                    return end.distanceSquared(center) <= circle.radius * circle.radius;
                }
                Vector2f previous = this._vertices[(ii + this._vertices.length - 1) % this._vertices.length];
                a = previous.y - start.y;
                b = start.x - previous.x;
                if (a * center.x + b * center.y >= a * previous.x + b * previous.y) {
                    return d * d <= l2 * circle.radius * circle.radius;
                }
            }
            ++ii;
        }
        return true;
    }

    @Override
    public boolean intersects(Capsule capsule) {
        Vector2f origin = capsule.getStart();
        Vector2f terminus = capsule.getEnd();
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            float d = a * origin.x + b * origin.y - a * start.x - b * start.y;
            if (!(d >= 0.0f)) {
                if (Polygon.intersects(start, end, capsule.radius, origin, terminus)) {
                    return true;
                }
                Vector2f previous = this._vertices[(ii + this._vertices.length - 1) % this._vertices.length];
                a = previous.y - start.y;
                b = start.x - previous.x;
                if (a * origin.x + b * origin.y <= a * previous.x + b * previous.y) {
                    return Polygon.intersects(previous, start, capsule.radius, origin, terminus);
                }
                Vector2f next = this._vertices[(ii + 2) % this._vertices.length];
                a = end.y - next.y;
                b = next.x - end.x;
                if (a * origin.x + b * origin.y > a * end.x + b * end.y) {
                    return false;
                }
                return Polygon.intersects(end, next, capsule.radius, origin, terminus);
            }
            ++ii;
        }
        return true;
    }

    @Override
    public boolean intersects(Polygon polygon) {
        return this.intersectsOnAxes(polygon) && polygon.intersectsOnAxes(this);
    }

    @Override
    public boolean intersects(Compound compound) {
        return compound.intersects(this);
    }

    @Override
    public Vector2f getPenetration(Shape shape, Vector2f result) {
        return shape.getPenetration(this, result).negateLocal();
    }

    @Override
    public Vector2f getPenetration(Point point, Vector2f result) {
        return result.set(Vector2f.ZERO);
    }

    @Override
    public Vector2f getPenetration(Segment segment, Vector2f result) {
        Vector2f[] cv = new Vector2f[]{segment.getStart(), segment.getEnd()};
        Vector2f minDistance = Polygon.getMinMinkowskyDifference(this._vertices, cv, 0.0f, null);
        minDistance = Polygon.getMinMinkowskyDifference(cv, this._vertices, 0.0f, minDistance);
        return result.set(minDistance);
    }

    @Override
    public Vector2f getPenetration(Circle circle, Vector2f result) {
        Vector2f center = circle.getCenter();
        float mind = Float.MAX_VALUE;
        int midx = 0;
        int ii = 0;
        while (ii < this._vertices.length) {
            Vector2f start = this._vertices[ii];
            Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
            float a = start.y - end.y;
            float b = end.x - start.x;
            float l2 = a * a + b * b;
            float d = a * center.x + b * center.y - a * start.x - b * start.y;
            if (d >= 0.0f) {
                float nd = d / FloatMath.sqrt(l2);
                if (nd < mind) {
                    mind = nd;
                    midx = ii;
                }
            } else {
                float dist;
                Vector2f next = this._vertices[(ii + 2) % this._vertices.length];
                a = end.y - next.y;
                b = next.x - end.x;
                if (a * center.x + b * center.y <= a * end.x + b * end.y && (dist = center.distance(end)) > 0.0f) {
                    return center.subtract(end, result).multLocal(circle.radius / dist - 1.0f);
                }
                Vector2f previous = this._vertices[(ii + this._vertices.length - 1) % this._vertices.length];
                a = previous.y - start.y;
                b = start.x - previous.x;
                if (a * center.x + b * center.y >= a * previous.x + b * previous.y) {
                    return result.set(end.y - start.y, start.x - end.x).multLocal(circle.radius / FloatMath.sqrt(l2) + d / l2);
                }
            }
            ++ii;
        }
        Vector2f start = this._vertices[midx];
        Vector2f end = this._vertices[(midx + 1) % this._vertices.length];
        return result.set(end.y - start.y, start.x - end.x).normalizeLocal().multLocal(circle.radius + mind);
    }

    @Override
    public Vector2f getPenetration(Capsule capsule, Vector2f result) {
        Vector2f[] cv = new Vector2f[]{capsule.getStart(), capsule.getEnd()};
        Vector2f minDistance = Polygon.getMinMinkowskyDifference(this._vertices, cv, capsule.radius, null);
        minDistance = Polygon.getMinMinkowskyDifference(cv, this._vertices, capsule.radius, minDistance);
        return result.set(minDistance);
    }

    @Override
    public Vector2f getPenetration(Polygon polygon, Vector2f result) {
        Vector2f minDistance = Polygon.getMinMinkowskyDifference(this._vertices, polygon._vertices, 0.0f, null);
        minDistance = Polygon.getMinMinkowskyDifference(polygon._vertices, this._vertices, 0.0f, minDistance);
        return result.set(minDistance);
    }

    @Override
    public Vector2f getPenetration(Compound compound, Vector2f result) {
        return compound.getPenetration(this, result).negateLocal();
    }

    @Override
    public void draw(boolean outline) {
        GL11.glBegin((int)(outline ? 2 : 9));
        Vector2f[] vector2fArray = this._vertices;
        int n = this._vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vector2f vertex = vector2fArray[n2];
            GL11.glVertex2f((float)vertex.x, (float)vertex.y);
            ++n2;
        }
        GL11.glEnd();
    }

    @Override
    public ShapeConfig createConfig() {
        ShapeConfig.Polygon polygon = new ShapeConfig.Polygon();
        polygon.vertices = new ShapeConfig.Vertex[this._vertices.length];
        int ii = 0;
        while (ii < this._vertices.length) {
            ShapeConfig.Vertex vertex = polygon.vertices[ii] = new ShapeConfig.Vertex();
            vertex.x = this._vertices[ii].x;
            vertex.y = this._vertices[ii].y;
            ++ii;
        }
        return polygon;
    }

    public String toString() {
        return "Poly:(" + StringUtil.join((Object[])this._vertices) + ")";
    }

    protected void initVertices(int vcount) {
        this._vertices = new Vector2f[vcount];
        int ii = 0;
        while (ii < vcount) {
            this._vertices[ii] = new Vector2f();
            ++ii;
        }
    }

    protected boolean intersectsOnAxes(Polygon other) {
        int ii = 0;
        while (ii < this._vertices.length) {
            block3: {
                Vector2f start = this._vertices[ii];
                Vector2f end = this._vertices[(ii + 1) % this._vertices.length];
                float a = start.y - end.y;
                float b = end.x - start.x;
                float c = a * start.x + b * start.y;
                Vector2f[] vector2fArray = other._vertices;
                int n = other._vertices.length;
                int n2 = 0;
                while (n2 < n) {
                    Vector2f vertex = vector2fArray[n2];
                    if (!(a * vertex.x + b * vertex.y >= c)) {
                        ++n2;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++ii;
        }
        return true;
    }
}

