/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.state;

import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.state.RenderState;

public class PolygonState
extends RenderState {
    public static final PolygonState DEFAULT = new PolygonState(6914, 6914, 0.0f, 0.0f);
    public static final PolygonState WIREFRAME = new PolygonState(6913, 6913, 0.0f, 0.0f);
    protected int _frontPolygonMode;
    protected int _backPolygonMode;
    protected float _polygonOffsetFactor;
    protected float _polygonOffsetUnits;

    public static PolygonState getInstance(int frontPolygonMode, int backPolygonMode, float polygonOffsetFactor, float polygonOffsetUnits) {
        return PolygonState.getInstance(new PolygonState(frontPolygonMode, backPolygonMode, polygonOffsetFactor, polygonOffsetUnits));
    }

    public static PolygonState getInstance(PolygonState state) {
        if (state.equals(DEFAULT)) {
            return DEFAULT;
        }
        if (state.equals(WIREFRAME)) {
            return WIREFRAME;
        }
        return state;
    }

    public PolygonState(int frontPolygonMode, int backPolygonMode, float polygonOffsetFactor, float polygonOffsetUnits) {
        this._frontPolygonMode = frontPolygonMode;
        this._backPolygonMode = backPolygonMode;
        this._polygonOffsetFactor = polygonOffsetFactor;
        this._polygonOffsetUnits = polygonOffsetUnits;
    }

    public int getFrontPolygonMode() {
        return this._frontPolygonMode;
    }

    public int getBackPolygonMode() {
        return this._backPolygonMode;
    }

    public float getPolygonOffsetFactor() {
        return this._polygonOffsetFactor;
    }

    public float getPolygonOffsetUnits() {
        return this._polygonOffsetUnits;
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public void apply(Renderer renderer) {
        renderer.setPolygonState(this._frontPolygonMode, this._backPolygonMode, this._polygonOffsetFactor, this._polygonOffsetUnits);
    }

    public boolean equals(Object other) {
        if (other instanceof PolygonState) {
            PolygonState ostate = (PolygonState)other;
            if (this._frontPolygonMode == ostate._frontPolygonMode && this._backPolygonMode == ostate._backPolygonMode && this._polygonOffsetFactor == ostate._polygonOffsetFactor && this._polygonOffsetUnits == ostate._polygonOffsetUnits) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this._frontPolygonMode;
        result = 31 * result + this._backPolygonMode;
        result = 31 * result + Float.floatToIntBits(this._polygonOffsetFactor);
        result = 31 * result + Float.floatToIntBits(this._polygonOffsetUnits);
        return result;
    }
}

