/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.collect.Lists;
import com.threerings.opengl.gui.Selectable;
import com.threerings.opengl.gui.ToggleButton;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import java.util.List;

public class ButtonGroup
implements ActionListener,
Selectable<ToggleButton> {
    protected boolean _alwaysSelect;
    protected List<ToggleButton> _buttons = Lists.newArrayList();
    protected List<ActionListener> _listeners = Lists.newArrayList();

    public ButtonGroup(ToggleButton ... buttons) {
        this(true, buttons);
    }

    public ButtonGroup(boolean alwaysSelect, ToggleButton ... buttons) {
        this._alwaysSelect = alwaysSelect;
        ToggleButton[] toggleButtonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            ToggleButton button = toggleButtonArray[n2];
            this.add(button);
            ++n2;
        }
    }

    public void addListener(ActionListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(ActionListener listener) {
        this._listeners.remove(listener);
    }

    public void add(ToggleButton button) {
        if (this.getSelectedIndex() != -1) {
            button.setSelected(false);
        } else if (this._alwaysSelect) {
            button.setSelected(true);
        }
        this._buttons.add(button);
        button.addListener(this);
    }

    public void remove(ToggleButton button) {
        this._buttons.remove(button);
        button.removeListener(this);
        if (this._alwaysSelect && button.isSelected() && !this._buttons.isEmpty()) {
            this._buttons.get(0).setSelected(true);
        }
    }

    public void removeAll() {
        int ii = 0;
        int nn = this._buttons.size();
        while (ii < nn) {
            this._buttons.get(ii).removeListener(this);
            ++ii;
        }
        this._buttons.clear();
    }

    public int getButtonCount() {
        return this._buttons.size();
    }

    public void setAlwaysSelect(boolean alwaysSelect) {
        this._alwaysSelect = alwaysSelect;
        if (this._alwaysSelect && this.getSelectedIndex() == -1 && this.getButtonCount() > 0) {
            this.setSelected(this._buttons.get(0));
        }
    }

    @Override
    public ToggleButton getSelected() {
        int idx = this.getSelectedIndex();
        return idx == -1 ? null : this._buttons.get(idx);
    }

    @Override
    public void setSelected(ToggleButton button) {
        if (!button.isSelected()) {
            button.setSelected(true);
            this.selectionChanged(button, 0L, 0);
        }
    }

    public ToggleButton getButton(int idx) {
        return this._buttons.get(idx);
    }

    @Override
    public void setSelectedIndex(int idx) {
        this.setSelected(this._buttons.get(idx));
    }

    @Override
    public int getSelectedIndex() {
        int ii = 0;
        int nn = this._buttons.size();
        while (ii < nn) {
            if (this._buttons.get(ii).isSelected()) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ToggleButton button = (ToggleButton)event.getSource();
        if (button.isSelected()) {
            this.selectionChanged(button, event.getWhen(), event.getModifiers());
        } else if (this._alwaysSelect) {
            button.setSelected(true);
        }
    }

    protected void selectionChanged(ToggleButton selected, long when, int modifiers) {
        int ii = 0;
        int nn = this._buttons.size();
        while (ii < nn) {
            ToggleButton button = this._buttons.get(ii);
            if (button != selected) {
                button.setSelected(false);
            }
            ++ii;
        }
        ActionEvent event = new ActionEvent(this, when, modifiers, "select", selected);
        int ii2 = 0;
        int nn2 = this._listeners.size();
        while (ii2 < nn2) {
            event.dispatch(this._listeners.get(ii2));
            ++ii2;
        }
    }
}

