/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor;

import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.Executor;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.config.RenderEffectConfig;
import com.threerings.opengl.compositor.config.TargetConfig;
import com.threerings.opengl.renderer.TextureRenderer;
import com.threerings.opengl.util.GlContext;

public class RenderEffect
extends DynamicScope
implements ConfigUpdateListener<RenderEffectConfig>,
Comparable<RenderEffect> {
    protected GlContext _ctx;
    @Scoped
    protected String _identity = String.valueOf(System.identityHashCode(this));
    protected RenderEffectConfig _config;
    protected int _priority;
    protected Target[] _targets;
    protected Target _output;
    protected int _idx;
    protected static final RenderEffectConfig.Technique NOOP_TECHNIQUE = new RenderEffectConfig.Technique();

    public RenderEffect(GlContext ctx, Scope parentScope, ConfigReference<RenderEffectConfig> ref) {
        this(ctx, parentScope, ctx.getConfigManager().getConfig(RenderEffectConfig.class, ref));
    }

    public RenderEffect(GlContext ctx, Scope parentScope, RenderEffectConfig config) {
        super("effect", parentScope);
        this._ctx = ctx;
        this.setConfig(config);
    }

    public void setConfig(ConfigReference<RenderEffectConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(RenderEffectConfig.class, ref));
    }

    public void setConfig(RenderEffectConfig config) {
        if (this._config != null) {
            this._config.removeListener(this);
        }
        RenderEffectConfig renderEffectConfig = this._config = config == null ? null : (RenderEffectConfig)config.getInstance(this);
        if (this._config != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    public int getPriority() {
        return this._priority;
    }

    public void render(int idx) {
        this._idx = idx;
        Target[] targetArray = this._targets;
        int n = this._targets.length;
        int n2 = 0;
        while (n2 < n) {
            Target target = targetArray[n2];
            target.render();
            ++n2;
        }
        this._output.render();
    }

    @Override
    public void configUpdated(ConfigEvent<RenderEffectConfig> event) {
        this.updateFromConfig();
    }

    @Override
    public int compareTo(RenderEffect other) {
        return this._priority - other._priority;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    protected void renderPrevious() {
        this._ctx.getCompositor().renderPrevious(this._idx);
    }

    protected void updateFromConfig() {
        RenderEffectConfig.Technique technique;
        this._priority = this._config == null ? 0 : this._config.getPriority(this._ctx);
        String scheme = ScopeUtil.resolve(this._parentScope, "renderScheme", null);
        RenderEffectConfig.Technique technique2 = technique = this._config == null || !this._ctx.getApp().getRenderEffects() ? NOOP_TECHNIQUE : this._config.getTechnique(this._ctx, scheme);
        if (technique == null) {
            Log.log.warning((Object)"No technique available to render effect.", new Object[]{"config", this._config.getName(), "scheme", scheme});
            technique = NOOP_TECHNIQUE;
        }
        if (this._targets != null) {
            Target[] targetArray = this._targets;
            int n = this._targets.length;
            int n2 = 0;
            while (n2 < n) {
                Target target = targetArray[n2];
                target.dispose();
                ++n2;
            }
        }
        this._targets = new Target[technique.targets.length];
        int ii = 0;
        while (ii < this._targets.length) {
            this._targets[ii] = technique.targets[ii].createEffectTarget(this._ctx, this);
            ++ii;
        }
        if (this._output != null) {
            this._output.dispose();
        }
        this._output = technique.output.createEffectTarget(this._ctx, this);
    }

    public static class OutputTarget
    extends Target {
        public OutputTarget(GlContext ctx, Scope parentScope, TargetConfig.Output config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(TargetConfig.Output config) {
            super.setConfig(config);
        }
    }

    public static abstract class Target
    extends SimpleScope {
        protected GlContext _ctx;
        protected TargetConfig _config;
        protected Executor[] _executors;

        public void render() {
            if (this._config.input == TargetConfig.Input.PREVIOUS) {
                ((RenderEffect)this._parentScope).renderPrevious();
            }
            Executor[] executorArray = this._executors;
            int n = this._executors.length;
            int n2 = 0;
            while (n2 < n) {
                Executor executor = executorArray[n2];
                executor.execute();
                ++n2;
            }
        }

        @Override
        public String getScopeName() {
            return "target";
        }

        protected Target(GlContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }

        protected void setConfig(TargetConfig config) {
            this._config = config;
            this._executors = new Executor[config.steps.length];
            int ii = 0;
            while (ii < this._executors.length) {
                this._executors[ii] = config.steps[ii].createExecutor(this._ctx, this);
                ++ii;
            }
        }
    }

    public static class TextureTarget
    extends Target {
        protected TextureRenderer _renderer;

        public TextureTarget(GlContext ctx, Scope parentScope, TargetConfig.Texture config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(TargetConfig.Texture config) {
            super.setConfig(config);
            this._renderer = config.getTextureRenderer(this._ctx);
        }

        @Override
        public void render() {
            this._renderer.startRender();
            try {
                super.render();
            }
            finally {
                this._renderer.commitRender();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            this._renderer.dispose();
        }
    }
}

