/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.lang.ref.SoftReference;

@EditorTypes(value={Default.class, Moving.class, StatefulEntry.class, StatefulModelEntry.class})
public abstract class ActorSpriteConfig
extends DeepObject
implements Exportable {
    @Editable(editor="mask", mode="floor", hgroup="f")
    public int floorFlags;
    @Editable(editor="mask", mode="floor", hgroup="f")
    public int floorMask = 255;
    @Editable(min=0.0, step=0.01, hgroup="s")
    public float scale = 1.0f;
    @Editable(min=0.0, step=0.01, hgroup="s")
    public float smoothZ = 0.0f;
    @Editable(nullable=true)
    public ConfigReference<ModelConfig> model;
    @Editable(nullable=true)
    public ConfigReference<ModelConfig> creationTransient;
    @Editable(nullable=true)
    public ConfigReference<ModelConfig> destructionTransient;

    public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
        preloads.add(new Preloadable.Model(this.model));
        preloads.add(new Preloadable.Model(this.creationTransient));
        preloads.add(new Preloadable.Model(this.destructionTransient));
    }

    public abstract ActorSprite.Implementation getImplementation(TudeyContext var1, Scope var2, ActorSprite.Implementation var3);

    public void invalidate() {
    }

    protected static float[] createWeights(WeightedAnimation[] weighted) {
        float[] weights = new float[weighted.length];
        int ii = 0;
        while (ii < weighted.length) {
            weights[ii] = weighted[ii].weight;
            ++ii;
        }
        return weights;
    }

    public static class Default
    extends ActorSpriteConfig {
        @Override
        public ActorSprite.Implementation getImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
            if (impl != null && impl.getClass() == ActorSprite.Original.class) {
                ((ActorSprite.Original)impl).setConfig(this);
            } else {
                impl = new ActorSprite.Original(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class ModelState
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
    }

    @EditorTypes(value={SingleMovement.class, QuadMovement.class})
    public static abstract class MovementSet
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float speed;

        public abstract void getPreloads(ConfigManager var1, PreloadableSet var2);

        public abstract Animation[] resolve(Model var1);
    }

    public static class Moving
    extends Default {
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float attachedScale = 1.0f;
        @Editable
        public WeightedAnimation[] idles = new WeightedAnimation[0];
        @Editable
        public MovementSet[] movements = new MovementSet[0];
        @Editable
        public RotationSet[] rotations = new RotationSet[0];
        @DeepOmit
        protected transient SoftReference<float[]> _idleWeights;

        public float[] getIdleWeights() {
            float[] weights;
            float[] fArray = weights = this._idleWeights == null ? null : this._idleWeights.get();
            if (weights == null) {
                weights = Moving.createWeights(this.idles);
                this._idleWeights = new SoftReference<float[]>(weights);
            }
            return weights;
        }

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            DeepObject[] deepObjectArray = this.idles;
            int n = this.idles.length;
            int n2 = 0;
            while (n2 < n) {
                WeightedAnimation idle = deepObjectArray[n2];
                preloads.add(new Preloadable.Animation(idle.animation));
                ++n2;
            }
            deepObjectArray = this.movements;
            n = this.movements.length;
            n2 = 0;
            while (n2 < n) {
                DeepObject movement = deepObjectArray[n2];
                ((MovementSet)movement).getPreloads(cfgmgr, preloads);
                ++n2;
            }
            deepObjectArray = this.rotations;
            n = this.rotations.length;
            n2 = 0;
            while (n2 < n) {
                DeepObject rotation = deepObjectArray[n2];
                ((RotationSet)rotation).getPreloads(cfgmgr, preloads);
                ++n2;
            }
        }

        @Override
        public ActorSprite.Implementation getImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
            if (impl != null && impl.getClass() == ActorSprite.Moving.class) {
                ((ActorSprite.Moving)impl).setConfig(this);
            } else {
                impl = new ActorSprite.Moving(ctx, scope, this);
            }
            return impl;
        }

        @Override
        public void invalidate() {
            this._idleWeights = null;
        }
    }

    public static class QuadMovement
    extends MovementSet {
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> forward;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> left;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> backward;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> right;

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            preloads.add(new Preloadable.Animation(this.forward));
            preloads.add(new Preloadable.Animation(this.left));
            preloads.add(new Preloadable.Animation(this.backward));
            preloads.add(new Preloadable.Animation(this.right));
        }

        @Override
        public Animation[] resolve(Model model) {
            return new Animation[]{model.createAnimation(this.backward), model.createAnimation(this.right), model.createAnimation(this.forward), model.createAnimation(this.left)};
        }
    }

    public static class RotationSet
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, scale=0.017453292519943295)
        public float rate;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> left;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> right;

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            preloads.add(new Preloadable.Animation(this.left));
            preloads.add(new Preloadable.Animation(this.right));
        }

        public Animation[] resolve(Model model) {
            return new Animation[]{model.createAnimation(this.left), model.createAnimation(this.right)};
        }
    }

    public static class SingleMovement
    extends MovementSet {
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            preloads.add(new Preloadable.Animation(this.animation));
        }

        @Override
        public Animation[] resolve(Model model) {
            Animation anim = model.createAnimation(this.animation);
            return new Animation[]{anim, anim, anim, anim};
        }
    }

    public static class State
    extends DeepObject
    implements Exportable {
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;
    }

    public static class StatefulEntry
    extends Default {
        @Editable
        public State[] states = new State[0];

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            State[] stateArray = this.states;
            int n = this.states.length;
            int n2 = 0;
            while (n2 < n) {
                State state = stateArray[n2];
                preloads.add(new Preloadable.Animation(state.animation));
                ++n2;
            }
        }

        @Override
        public ActorSprite.Implementation getImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
            if (impl != null && impl.getClass() == ActorSprite.StatefulEntry.class) {
                ((ActorSprite.StatefulEntry)impl).setConfig(this);
            } else {
                impl = new ActorSprite.StatefulEntry(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class StatefulModelEntry
    extends Default {
        @Editable
        public ModelState[] states = new ModelState[0];

        @Override
        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            super.getPreloads(cfgmgr, preloads);
            ModelState[] modelStateArray = this.states;
            int n = this.states.length;
            int n2 = 0;
            while (n2 < n) {
                ModelState state = modelStateArray[n2];
                preloads.add(new Preloadable.Model(state.model));
                ++n2;
            }
        }

        @Override
        public ActorSprite.Implementation getImplementation(TudeyContext ctx, Scope scope, ActorSprite.Implementation impl) {
            if (impl != null && impl.getClass() == ActorSprite.StatefulModelEntry.class) {
                ((ActorSprite.StatefulModelEntry)impl).setConfig(this);
            } else {
                impl = new ActorSprite.StatefulModelEntry(ctx, scope, this);
            }
            return impl;
        }
    }

    public static class WeightedAnimation
    extends DeepObject
    implements Exportable {
        @Editable(min=0.0, step=0.01)
        public float weight = 1.0f;
        @Editable(nullable=true)
        public ConfigReference<AnimationConfig> animation;
    }
}

