/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.math.Quaternion;
import com.threerings.math.Vector3f;
import com.threerings.opengl.gui.text.CharacterTextFactory;
import com.threerings.opengl.gui.text.Text;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleOverlay;
import java.awt.Font;
import org.lwjgl.opengl.GL11;

public class Compass
extends SimpleOverlay {
    protected Text _x;
    protected Text _y;
    protected Text _z;
    protected Vector3f _vector = new Vector3f();

    public Compass(GlContext ctx) {
        super(ctx);
        CharacterTextFactory factory = CharacterTextFactory.getInstance(new Font("Dialog", 0, 12), true, 0.0f);
        this._x = factory.createText("x", new Color4f(0.75f, 0.0f, 0.0f, 1.0f));
        this._y = factory.createText("y", new Color4f(0.0f, 0.75f, 0.0f, 1.0f));
        this._z = factory.createText("z", Color4f.BLUE);
    }

    @Override
    protected void draw() {
        Renderer renderer = this._ctx.getRenderer();
        Quaternion rotation = this._ctx.getCompositor().getCamera().getViewTransform().getRotation();
        rotation.transformUnitX(this._vector);
        this.drawAxis(renderer, this._x, this._vector.x, this._vector.y);
        rotation.transformUnitY(this._vector);
        this.drawAxis(renderer, this._y, this._vector.x, this._vector.y);
        rotation.transformUnitZ(this._vector);
        this.drawAxis(renderer, this._z, this._vector.x, this._vector.y);
    }

    protected void drawAxis(Renderer renderer, Text label, float x, float y) {
        label.render(renderer, (int)(29.0f + 28.0f * x), (int)(29.0f + 28.0f * y), 1.0f);
        renderer.setTextureState(null);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)32.0f, (float)32.0f);
        GL11.glVertex2f((float)(32.0f + 20.0f * x), (float)(32.0f + 20.0f * y));
        GL11.glEnd();
    }
}

