/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.google.common.base.Objects;
import com.samskivert.util.ObserverList;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.DynamicScope;
import com.threerings.expr.MutableLong;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeUpdateListener;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.Log;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.material.Projection;
import com.threerings.opengl.material.Surface;
import com.threerings.opengl.material.config.GeometryMaterial;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.ModelObserver;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.FogState;
import com.threerings.opengl.renderer.state.LightState;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.scene.SceneInfluenceSet;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlContextWrapper;
import com.threerings.opengl.util.Intersectable;
import com.threerings.opengl.util.Tickable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Model
extends DynamicScope
implements SceneElement,
ConfigUpdateListener<ModelConfig> {
    public static final int FOG_INFLUENCE = 1;
    public static final int LIGHT_INFLUENCE = 2;
    public static final int PROJECTION_INFLUENCE = 4;
    public static final int DEFINITION_INFLUENCE = 8;
    protected GlContext _ctx;
    protected ModelConfig _config;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected ObserverList<ModelObserver> _observers;
    @Scoped
    protected MutableLong _epoch = new MutableLong(System.currentTimeMillis());
    @Scoped
    protected Transform3D _localTransform = new Transform3D(2);
    protected Scene _scene;
    protected SceneInfluenceSet _influences = new SceneInfluenceSet();
    @Scoped
    protected String _renderScheme;
    protected boolean _visible = true;
    @Scoped
    protected ColorState _colorState;
    @Scoped
    protected FogState _fogState;
    @Scoped
    protected LightState _lightState;
    @Scoped
    protected Projection[] _projections;
    protected Map<String, Object> _definitions;
    protected Object _userObject;
    protected int _lastVisit;
    protected static CompletedOp _completedOp = new CompletedOp();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    @Override
    public void addListener(ScopeUpdateListener listener) {
        if (listener instanceof Animation.Procedural) {
            super.addListener(0, listener);
        } else {
            super.addListener(listener);
        }
    }

    public static MaterialConfig getMaterialConfig(GlContext ctx, String texture, String tag, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
        String key = String.valueOf(texture) + "|" + tag;
        MaterialConfig config = materialConfigs.get(key);
        if (config == null) {
            config = Model.getMaterialConfig(ctx, texture, tag, materialMappings);
            materialConfigs.put(key, config);
        }
        return config;
    }

    public Model(GlContext ctx) {
        this(ctx, (ModelConfig)null);
    }

    public Model(GlContext ctx, String name) {
        this(ctx, ctx.getConfigManager().getConfig(ModelConfig.class, name));
    }

    public Model(GlContext ctx, String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this(ctx, ctx.getConfigManager().getConfig(ModelConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public Model(GlContext ctx, ConfigReference<ModelConfig> ref) {
        this(ctx, ctx.getConfigManager().getConfig(ModelConfig.class, ref));
    }

    public Model(GlContext ctx, ModelConfig config) {
        super("model");
        this._ctx = new GlContextWrapper(ctx){

            @Override
            public ConfigManager getConfigManager() {
                return Model.this._config == null ? this._wrapped.getConfigManager() : Model.this._config.getConfigManager();
            }
        };
        this.setConfig(config);
    }

    public List<Model> getChildren() {
        return this._impl.getChildren();
    }

    public void setLocalTransform(Transform3D transform) {
        this._localTransform.set(transform);
        this._localTransform.promote(2);
        this.updateBounds();
    }

    public Transform3D getLocalTransform() {
        return this._localTransform;
    }

    public Transform3D getPointWorldTransform(String point) {
        return this._impl.getPointWorldTransform(point);
    }

    public void setConfig(String name) {
        this.setConfig(this._ctx.getConfigManager().getConfig(ModelConfig.class, name));
    }

    public void setConfig(ConfigReference<ModelConfig> ref) {
        this.setConfig(this._ctx.getConfigManager().getConfig(ModelConfig.class, ref));
    }

    public void setConfig(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        this.setConfig(this._ctx.getConfigManager().getConfig(ModelConfig.class, name, firstKey, firstValue, otherArgs));
    }

    public void clearConfig() {
        this.setConfig((ModelConfig)null);
    }

    public void setConfig(ModelConfig config) {
        if (this._config == config) {
            return;
        }
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    public ModelConfig getConfig() {
        return this._config;
    }

    public void setRenderScheme(String scheme) {
        if (!Objects.equal((Object)this._renderScheme, (Object)scheme)) {
            this._renderScheme = scheme;
            this.wasUpdated();
        }
    }

    public String getRenderScheme() {
        return this._renderScheme;
    }

    public void setVisible(boolean visible) {
        boolean oldVis = this._visible;
        this._visible = visible;
        this._impl.setVisible(visible);
        if (oldVis != visible) {
            this.visibilityWasSet();
        }
    }

    public void visibilityWasSet() {
        this._impl.visibilityWasSet();
        List<Model> children = this.getChildren();
        for (Model m : children) {
            m.visibilityWasSet();
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public boolean isShowing() {
        if (!this._visible) {
            return this._visible;
        }
        Scope curScope = this._parentScope;
        boolean parentVis = true;
        while (curScope != null && !(curScope instanceof Model)) {
            curScope = curScope.getParentScope();
        }
        if (curScope instanceof Model) {
            parentVis = ((Model)curScope).isShowing();
        }
        return parentVis;
    }

    public void setColorState(ColorState state) {
        if (this._colorState != state) {
            this._colorState = state;
            this.wasUpdated();
        }
    }

    public ColorState getColorState() {
        return this._colorState;
    }

    public void setFogState(FogState state) {
        if (this._fogState != state) {
            this._fogState = state;
            this.wasUpdated();
        }
    }

    public FogState getFogState() {
        return this._fogState;
    }

    public void setLightState(LightState state) {
        if (this._lightState != state) {
            this._lightState = state;
            this.wasUpdated();
        }
    }

    public LightState getLightState() {
        return this._lightState;
    }

    public void attach(String point, Model model) {
        this.attach(point, model, true);
    }

    public void attach(String point, Model model, boolean replace) {
        this._impl.attach(point, model, replace);
    }

    public void detach(Model model) {
        this._impl.detach(model);
    }

    public void detachAll(String point) {
        this._impl.detachAll(point);
    }

    public void startAnimation(String name) {
        Animation animation = this.getAnimation(name);
        if (animation != null) {
            animation.start();
        } else {
            Log.log.warning((Object)"Animation not found.", new Object[]{"name", name});
        }
    }

    public void stopAnimation(String name) {
        Animation animation = this.getAnimation(name);
        if (animation != null) {
            animation.stop();
        }
    }

    public void stopAnimations(int priority, float blendOut) {
        List<Animation> playing = this.getPlayingAnimations();
        int ii = 0;
        int nn = playing.size();
        while (ii < nn) {
            Animation anim = playing.get(ii);
            if (anim.getPriority() == priority) {
                anim.stop(blendOut);
            }
            ++ii;
        }
    }

    public void stopAllAnimations() {
        List<Animation> playing = this.getPlayingAnimations();
        int ii = 0;
        int nn = playing.size();
        while (ii < nn) {
            playing.get(ii).stop();
            ++ii;
        }
    }

    public List<Animation> getPlayingAnimations() {
        return this._impl.getPlayingAnimations();
    }

    public boolean isAnimationPlaying(String name) {
        Animation animation = this.getAnimation(name);
        return animation != null && animation.isPlaying();
    }

    public Animation getAnimation(String name) {
        return this._impl.getAnimation(name);
    }

    public Animation[] getAnimations() {
        return this._impl.getAnimations();
    }

    public Animation createAnimation(String name) {
        Animation anim = this.createAnimation();
        if (anim != null) {
            anim.setConfig(null, name);
        }
        return anim;
    }

    public Animation createAnimation(ConfigReference<AnimationConfig> ref) {
        Animation anim = this.createAnimation();
        if (anim != null) {
            anim.setConfig(null, ref);
        }
        return anim;
    }

    public Animation createAnimation(String name, String firstKey, Object firstValue, Object ... otherArgs) {
        Animation anim = this.createAnimation();
        if (anim != null) {
            anim.setConfig(null, name, firstKey, firstValue, otherArgs);
        }
        return anim;
    }

    public Animation createAnimation() {
        return this._impl.createAnimation();
    }

    public boolean hasCompleted() {
        return this._impl.hasCompleted();
    }

    public void addObserver(ModelObserver observer) {
        if (this._observers == null) {
            this._observers = ObserverList.newFastUnsafe();
        }
        this._observers.add((Object)observer);
    }

    public void removeObserver(ModelObserver observer) {
        if (this._observers == null) {
            return;
        }
        this._observers.remove((Object)observer);
        if (this._observers.isEmpty()) {
            this._observers = null;
        }
    }

    public void reset() {
        this.resetEpoch();
        this._impl.reset();
    }

    public void updateBounds() {
        this._impl.updateBounds();
    }

    public void drawBounds() {
        this._impl.drawBounds();
    }

    public void dumpInfo(String prefix) {
        System.out.println(String.valueOf(prefix) + (this._config == null ? null : this._config.getReference()));
        this._impl.dumpInfo(prefix);
    }

    public void setTickPolicy(SceneElement.TickPolicy policy) {
        this._impl.setTickPolicy(policy);
    }

    public void setUserObject(Object object) {
        this._userObject = object;
    }

    public Scene getScene() {
        return this._scene;
    }

    public ModelConfig.TransientPolicy getTransientPolicy() {
        return this._impl.getTransientPolicy();
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._impl.getTickPolicy();
    }

    @Override
    public Object getUserObject() {
        return this._userObject;
    }

    @Override
    public Box getBounds() {
        return this._impl.getBounds();
    }

    @Override
    public void wasAdded(Scene scene) {
        this._scene = scene;
        this._impl.wasAdded();
    }

    @Override
    public void willBeRemoved() {
        this._impl.willBeRemoved();
        this._scene = null;
    }

    @Override
    public void setInfluences(SceneInfluenceSet influences) {
        Map<String, Object> definitions;
        Projection[] projections;
        LightState lightState;
        FogState fogState;
        boolean influenceable;
        int flags = this._impl.getInfluenceFlags();
        boolean bl = influenceable = flags != 0;
        if (influenceable ? this._influences.equals(influences) : this._influences.isEmpty()) {
            return;
        }
        this._influences.clear();
        if (influenceable) {
            this._influences.addAll(influences);
        }
        Box bounds = this.getBounds();
        boolean updated = false;
        FogState fogState2 = fogState = (flags & 1) == 0 ? null : this._influences.getFogState(bounds, this._fogState);
        if (this._fogState != fogState) {
            this._fogState = fogState;
            updated = true;
        }
        LightState lightState2 = lightState = (flags & 2) == 0 ? null : this._influences.getLightState(bounds, this._lightState);
        if (this._lightState != lightState) {
            this._lightState = lightState;
            updated = true;
        }
        Projection[] projectionArray = projections = (flags & 4) == 0 ? null : this._influences.getProjections(this._projections);
        if (this._projections != projections) {
            this._projections = projections;
            updated = true;
        }
        Map<String, Object> map = definitions = (flags & 8) == 0 ? null : this._influences.getDefinitions(this._definitions);
        if (this._definitions != definitions) {
            this._definitions = definitions;
            updated = true;
        }
        if (updated) {
            this.wasUpdated();
        }
    }

    @Override
    public boolean isInfluenceable() {
        return this._impl.getInfluenceFlags() != 0;
    }

    @Override
    public boolean updateLastVisit(int visit) {
        if (this._lastVisit == visit) {
            return false;
        }
        this._lastVisit = visit;
        return true;
    }

    @Override
    public void tick(float elapsed) {
        this._impl.tick(elapsed);
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        return this._impl.getIntersection(ray, result);
    }

    @Override
    public void composite() {
        if (this._visible) {
            this._impl.composite();
        }
    }

    @Override
    public void configUpdated(ConfigEvent<ModelConfig> event) {
        this.updateFromConfig();
    }

    @Override
    public <T> T get(String name, Class<T> clazz) {
        T result = super.get(name, clazz);
        if (result != null || this._definitions == null) {
            return result;
        }
        Object value = this._definitions.get(name);
        return clazz.isInstance(value) ? (T)clazz.cast(value) : null;
    }

    @Override
    public void wasUpdated() {
        super.wasUpdated();
        if (this._impl != null && this._compoundDepth == 0) {
            this.updateFromConfig();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this._impl.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    public Scene getScene(Implementation impl) {
        return this._impl.isImplementation(impl) ? this._scene : null;
    }

    public void completed(Implementation impl) {
        if (this._observers != null && this._impl.isImplementation(impl)) {
            _completedOp.init(this);
            this._observers.apply((ObserverList.ObserverOp)_completedOp);
            _completedOp.clear();
        }
    }

    public void tickPolicyWillChange(Implementation impl) {
        if (this._scene != null && this._parentScope == this._scene && this._impl.isImplementation(impl)) {
            this._scene.tickPolicyWillChange(this);
        }
    }

    public void tickPolicyDidChange(Implementation impl) {
        if (this._scene != null && this._parentScope == this._scene && this._impl.isImplementation(impl)) {
            this._scene.tickPolicyDidChange(this);
        }
    }

    public void boundsWillChange(Implementation impl) {
        if (this._scene != null && this._parentScope == this._scene && this._impl.isImplementation(impl)) {
            this._scene.boundsWillChange(this);
        }
    }

    public void boundsDidChange(Implementation impl) {
        if (this._scene != null && this._parentScope == this._scene && this._impl.isImplementation(impl)) {
            this._scene.boundsDidChange(this);
        }
    }

    protected void resetEpoch() {
        this._epoch.value = ScopeUtil.resolveTimestamp((Scope)this, (String)"now").value;
    }

    protected void updateFromConfig() {
        boolean boundsChanging;
        Implementation nimpl = this._config == null ? null : this._config.getModelImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl == nimpl) {
            return;
        }
        boolean tickPolicyChanging = this._impl.getTickPolicy() != nimpl.getTickPolicy();
        boolean bl = boundsChanging = !this._impl.getBounds().equals(nimpl.getBounds());
        if (tickPolicyChanging) {
            this.tickPolicyWillChange(this._impl);
        }
        if (boundsChanging) {
            this.boundsWillChange(this._impl);
        }
        if (this._scene != null) {
            this._impl.willBeRemoved();
        }
        this._impl.dispose();
        this._impl = nimpl;
        if (tickPolicyChanging) {
            this.tickPolicyDidChange(this._impl);
        }
        if (boundsChanging) {
            this.boundsDidChange(this._impl);
        }
        if (this._scene != null) {
            this._impl.wasAdded();
        }
    }

    protected void animationStarted(Animation animation) {
        Animation.applyStartedOp(this._observers, animation);
    }

    protected void animationStopped(Animation animation, boolean completed) {
        Animation.applyStoppedOp(this._observers, animation, completed);
    }

    protected static MaterialConfig getMaterialConfig(GlContext ctx, String texture, String tag, ModelConfig.Imported.MaterialMapping[] materialMappings) {
        ModelConfig.Imported.MaterialMapping[] materialMappingArray = materialMappings;
        int n = materialMappings.length;
        int n2 = 0;
        while (n2 < n) {
            ModelConfig.Imported.MaterialMapping mapping = materialMappingArray[n2];
            if (Objects.equal((Object)texture, (Object)mapping.texture) && tag.equals(mapping.tag)) {
                if (mapping.material == null) {
                    return null;
                }
                MaterialConfig config = ctx.getConfigManager().getConfig(MaterialConfig.class, mapping.material);
                if (config == null) {
                    Log.log.warning((Object)"Missing material for mapping.", new Object[]{"material", mapping.material});
                }
                return config;
            }
            ++n2;
        }
        Log.log.warning((Object)"No material mapping found.", new Object[]{"texture", texture, "tag", tag});
        return null;
    }

    protected static class CompletedOp
    implements ObserverList.ObserverOp<ModelObserver> {
        protected Model _model;

        protected CompletedOp() {
        }

        public void init(Model model) {
            this._model = model;
        }

        public void clear() {
            this._model = null;
        }

        public boolean apply(ModelObserver observer) {
            return observer.modelCompleted(this._model);
        }
    }

    public static abstract class Implementation
    extends SimpleScope
    implements Tickable,
    Intersectable,
    Compositable {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public List<Model> getChildren() {
            return Collections.emptyList();
        }

        public Transform3D getPointWorldTransform(String point) {
            return null;
        }

        public void attach(String point, Model model, boolean replace) {
            Log.log.warning((Object)"Attachment not supported.", new Object[]{"point", point, "model", model});
        }

        public void detach(Model model) {
            Log.log.warning((Object)"Model not attached.", new Object[]{"model", model});
        }

        public void detachAll(String point) {
        }

        public List<Animation> getPlayingAnimations() {
            return Collections.emptyList();
        }

        public Animation getAnimation(String name) {
            return null;
        }

        public Animation[] getAnimations() {
            return Animation.EMPTY_ARRAY;
        }

        public Animation createAnimation() {
            return null;
        }

        public boolean hasCompleted() {
            return false;
        }

        public void setVisible(boolean visible) {
        }

        public void visibilityWasSet() {
        }

        public void reset() {
        }

        public int getInfluenceFlags() {
            return 0;
        }

        public Box getBounds() {
            return Box.EMPTY;
        }

        public void updateBounds() {
        }

        public void drawBounds() {
        }

        public void dumpInfo(String prefix) {
        }

        public void setTickPolicy(SceneElement.TickPolicy policy) {
            Log.log.warning((Object)"Setting tick policy not supported.", new Object[]{"policy", policy});
        }

        public ModelConfig.TransientPolicy getTransientPolicy() {
            return ModelConfig.TransientPolicy.ALWAYS;
        }

        public SceneElement.TickPolicy getTickPolicy() {
            return SceneElement.TickPolicy.NEVER;
        }

        public void wasAdded() {
        }

        public void willBeRemoved() {
        }

        public boolean isImplementation(Implementation impl) {
            return this == impl;
        }

        @Override
        public void tick(float elapsed) {
            this.updateBounds();
        }

        @Override
        public boolean getIntersection(Ray3D ray, Vector3f result) {
            return false;
        }

        @Override
        public void composite() {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }

        protected static Surface[] createSurfaces(GlContext ctx, Scope scope, GeometryMaterial[] gmats) {
            Surface[] surfaces = new Surface[gmats.length];
            int ii = 0;
            while (ii < gmats.length) {
                GeometryMaterial gmat = gmats[ii];
                surfaces[ii] = new Surface(ctx, scope, gmat.geometry, gmat.material);
                ++ii;
            }
            return surfaces;
        }

        protected static Surface[] createSurfaces(GlContext ctx, Scope scope, ModelConfig.VisibleMesh[] meshes, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
            Surface[] surfaces = new Surface[meshes.length];
            int ii = 0;
            while (ii < meshes.length) {
                surfaces[ii] = Implementation.createSurface(ctx, scope, meshes[ii], materialMappings, materialConfigs);
                ++ii;
            }
            return surfaces;
        }

        protected static Surface createSurface(GlContext ctx, Scope scope, ModelConfig.VisibleMesh mesh, ModelConfig.Imported.MaterialMapping[] materialMappings, Map<String, MaterialConfig> materialConfigs) {
            return new Surface(ctx, scope, mesh.geometry, Model.getMaterialConfig(ctx, mesh.texture, mesh.tag, materialMappings, materialConfigs));
        }
    }
}

