/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.util;

public class Insets {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    public int left;
    public int top;
    public int right;
    public int bottom;

    public Insets(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public Insets(Insets other) {
        this.left = other.left;
        this.top = other.top;
        this.right = other.right;
        this.bottom = other.bottom;
    }

    public Insets() {
    }

    public int getHorizontal() {
        return this.left + this.right;
    }

    public int getVertical() {
        return this.top + this.bottom;
    }

    public Insets add(Insets insets) {
        if (ZERO_INSETS.equals(this)) {
            return insets;
        }
        if (ZERO_INSETS.equals(insets)) {
            return this;
        }
        return new Insets(this.left + insets.left, this.top + insets.top, this.right + insets.right, this.bottom + insets.bottom);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Insets)) {
            return false;
        }
        Insets oi = (Insets)other;
        return this.left == oi.left && this.top == oi.top && this.right == oi.right && this.bottom == oi.bottom;
    }

    public int hashCode() {
        return this.left ^ this.top ^ this.right ^ this.bottom;
    }

    public String toString() {
        return "l:" + this.left + " t:" + this.top + " r:" + this.right + " b:" + this.bottom;
    }
}

