/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.config;

import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.opengl.effect.Counter;
import com.threerings.probs.FloatVariable;
import com.threerings.util.DeepObject;

@EditorTypes(value={Unlimited.class, ConstantRate.class, RandomIntervals.class})
public abstract class CounterConfig
extends DeepObject
implements Exportable {
    public abstract Counter createCounter();

    public static class ConstantRate
    extends CounterConfig {
        @Editable(min=0.0, step=0.1)
        public float rate = 10.0f;

        @Override
        public Counter createCounter() {
            return new Counter(){
                protected float _accum;

                @Override
                public int count(float elapsed, int maximum) {
                    int count = (int)(this._accum += elapsed * ConstantRate.this.rate);
                    this._accum -= (float)count;
                    return Math.min(count, maximum);
                }

                @Override
                public void reset() {
                    this._accum = 0.0f;
                }
            };
        }
    }

    public static class RandomIntervals
    extends CounterConfig {
        @Editable(min=0.0, step=0.01)
        public FloatVariable interval = new FloatVariable.Uniform(0.07f, 0.2f);

        @Override
        public Counter createCounter() {
            return new Counter(){
                protected float _remaining;

                @Override
                public int count(float elapsed, int maximum) {
                    float f;
                    this._remaining -= elapsed;
                    if (f > 0.0f) {
                        return 0;
                    }
                    int count = Math.min(1, maximum);
                    while (count < maximum && (this._remaining += this.getInterval()) < 0.0f) {
                        ++count;
                    }
                    return count;
                }

                @Override
                public void reset() {
                    this._remaining = this.getInterval();
                }

                protected float getInterval() {
                    return Math.max(0.0f, RandomIntervals.this.interval.getValue());
                }
            };
        }
    }

    public static class Unlimited
    extends CounterConfig {
        @Override
        public Counter createCounter() {
            return new Counter(){

                @Override
                public int count(float elapsed, int maximum) {
                    return maximum;
                }

                @Override
                public void reset() {
                }
            };
        }
    }
}

