/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor.config;

import com.samskivert.util.QuickSort;
import com.threerings.config.ManagedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Batch;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class RenderQueueConfig
extends ManagedConfig {
    @Editable(hgroup="t")
    public String type = "normal";
    @Editable(hgroup="t")
    public int priority;
    @Editable
    public SortMode sortMode = SortMode.BACK_TO_FRONT;
    @Editable
    public RenderMode renderMode = new Normal();

    public static class Normal
    extends RenderMode {
    }

    public static class Ortho
    extends RenderMode {
        protected Vector3f _onormal = new Vector3f();

        @Override
        public void render(GlContext ctx, RenderQueue queue) {
            if (queue.isEmpty()) {
                return;
            }
            Renderer renderer = ctx.getRenderer();
            float oleft = renderer.getLeft();
            float oright = renderer.getRight();
            float obottom = renderer.getBottom();
            float otop = renderer.getTop();
            float onear = renderer.getNear();
            float ofar = renderer.getFar();
            this._onormal.set(renderer.getNearFarNormal());
            boolean oortho = renderer.isOrtho();
            Rectangle viewport = renderer.getViewport();
            renderer.setProjection(0.0f, viewport.width, 0.0f, viewport.height, -1.0f, 1.0f, Vector3f.UNIT_Z, true);
            super.render(ctx, queue);
            renderer.setProjection(oleft, oright, obottom, otop, onear, ofar, this._onormal, oortho);
        }
    }

    @EditorTypes(value={Normal.class, Ortho.class, Skybox.class})
    public static abstract class RenderMode
    extends DeepObject
    implements Exportable {
        public void render(GlContext ctx, RenderQueue queue) {
            queue.renderLists(ctx.getRenderer());
        }
    }

    public static class Skybox
    extends RenderMode {
        @Editable(min=0.0, step=0.01)
        public float fovScale = 1.0f;
        protected Vector3f _onormal = new Vector3f();

        @Override
        public void render(GlContext ctx, RenderQueue queue) {
            if (queue.isEmpty()) {
                return;
            }
            Renderer renderer = ctx.getRenderer();
            if (ctx.getCompositor().getSubrenderDepth() > 0) {
                super.render(ctx, queue);
                this.clearDepth(renderer);
                return;
            }
            float oleft = renderer.getLeft();
            float oright = renderer.getRight();
            float obottom = renderer.getBottom();
            float otop = renderer.getTop();
            float onear = renderer.getNear();
            float ofar = renderer.getFar();
            this._onormal.set(renderer.getNearFarNormal());
            boolean oortho = renderer.isOrtho();
            float tfov = otop / onear;
            float scale = FloatMath.tan(this.fovScale * FloatMath.atan(tfov)) / tfov;
            renderer.setProjection(oleft * scale, oright * scale, obottom * scale, otop * scale, onear, ofar, this._onormal, false);
            super.render(ctx, queue);
            renderer.setProjection(oleft, oright, obottom, otop, onear, ofar, this._onormal, oortho);
            this.clearDepth(renderer);
        }

        protected void clearDepth(Renderer renderer) {
            renderer.setClearDepth(1.0f);
            renderer.setState(DepthState.TEST_WRITE);
            GL11.glClear((int)256);
        }
    }

    public static enum SortMode {
        NONE(null){

            @Override
            public void sort(List<Batch> batches) {
            }
        }
        ,
        BY_STATE(new Comparator<Batch>(){

            @Override
            public int compare(Batch b1, Batch b2) {
                int comp = Batch.compareKeys(b1.key, b2.key);
                return comp == 0 ? Float.compare(b2.depth, b1.depth) : comp;
            }
        }),
        BACK_TO_FRONT(new Comparator<Batch>(){

            @Override
            public int compare(Batch b1, Batch b2) {
                return Float.compare(b1.depth, b2.depth);
            }
        }),
        FRONT_TO_BACK(new Comparator<Batch>(){

            @Override
            public int compare(Batch b1, Batch b2) {
                return Float.compare(b2.depth, b1.depth);
            }
        });

        protected final Comparator<Batch> _comparator;

        public void sort(List<Batch> batches) {
            QuickSort.sort(batches, this._comparator);
        }

        private SortMode(Comparator<Batch> comparator) {
            this._comparator = comparator;
        }
    }
}

