/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;

public class Streams {
    public static InputStream input(InputStream source) throws IOException {
        long length = Streams.readVarLong(source);
        if (length == -1L) {
            return null;
        }
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Next stream is too long! [length=" + length + "]");
        }
        byte[] bytes = new byte[(int)length];
        ByteStreams.readFully((InputStream)source, (byte[])bytes);
        return new ByteArrayInputStream(bytes);
    }

    public static OutputStream output(final OutputStream dest) {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                Streams.writeVarLong(dest, this.size());
                this.writeTo(dest);
                dest.flush();
                this.reset();
            }
        };
    }

    public static void writeVarLong(OutputStream out, long value) throws IOException, IllegalArgumentException {
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0);
        while (true) {
            int bite = (int)(value & 0x7FL);
            if ((value >>= 7) == 0L) {
                out.write(bite);
                return;
            }
            out.write(bite | 0x80);
        }
    }

    public static long readVarLong(InputStream in) throws IOException {
        long ret = 0L;
        int shift = 0;
        while (shift < 63) {
            int bite = in.read();
            if (bite == -1) {
                if (shift != 0) break;
                return -1L;
            }
            ret |= (long)(bite & 0x7F) << shift;
            if ((bite & 0x80) == 0) {
                if (shift > 0 && (bite & 0x7F) == 0) break;
                return ret;
            }
            shift += 7;
        }
        throw new StreamCorruptedException();
    }

    public static void writeVarInt(OutputStream out, int value) throws IOException, IllegalArgumentException {
        Streams.writeVarLong(out, value);
    }

    public static int readVarInt(InputStream in) throws IOException, IllegalArgumentException {
        return Ints.checkedCast((long)Streams.readVarLong(in));
    }

    public static void writeVarString(OutputStream out, String s) throws IOException {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        Streams.writeVarInt(out, bytes.length);
        out.write(bytes);
    }

    public static String readVarString(InputStream in) throws IOException {
        int length = Streams.readVarInt(in);
        byte[] buf = new byte[length];
        ByteStreams.readFully((InputStream)in, (byte[])buf);
        return new String(buf, Charsets.UTF_8);
    }
}

